/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.impl.soap.ClientUtility;
import blackboard.admin.persist.datasource.impl.soap.ServerUtility;
import blackboard.admin.persist.impl.AdminLoader;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.soap.ServerResponse;

public class DataSourceRemoteLoader
extends AdminLoader
implements DataSourceLoader {
    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        block2: {
            try {
                super.init(pm, appVersion);
            }
            catch (RuntimeBbServiceException exc) {
                if (!this._lMgr.isLicensed("integration.apis")) break block2;
                throw exc;
            }
        }
    }

    public DataSource loadByBatchUid(String batchUid) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.load(batchUid);
        ServerResponse response = this.executeSoapCall(req);
        BbList list = ServerUtility.unMarshallDataSourceObject((String)response.getResults());
        DataSource obj = (DataSource)list.get(0);
        return obj;
    }

    public BbList loadAll() throws PersistenceException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.load();
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = ServerUtility.unMarshallDataSourceObject((String)response.getResults());
        return bList;
    }

    public DataSourceObjectCount loadAdminObjectCount(String dataSourceBatchUid, DataType dataType, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadCount(dataSourceBatchUid, dataType, status);
        ServerResponse response = this.executeSoapCall(req);
        BbList list = ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
        DataSourceObjectCount obj = (DataSourceObjectCount)list.get(0);
        return obj;
    }

    public BbList loadAllAdminObjectCounts(String dataSourceBatchUid, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        super.checkApiLicensing();
        ClientUtility req = new ClientUtility();
        req.loadAllCounts(dataSourceBatchUid, status);
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = ServerUtility.unMarshallDataSourceObjectCount((String)response.getResults());
        return bList;
    }
}

