/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl.soap;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import java.util.Calendar;
import java.util.Vector;

public class ClientUtility
implements IClientUtility {
    private static final String SOAP_URN = "DataSourceServerUtility";
    private static final String CREATE = "create";
    private static final String MODIFY = "modify";
    private static final String DISABLE = "disable";
    private static final String DISABLE_ALL = "disableAll";
    private static final String REMOVE = "remove";
    private static final String PURGE = "purge";
    private static final String PURGE_ALL = "purgeAll";
    private static final String PURGE_SNAPSHOT = "purgeSnapshotSessions";
    private static final String LOAD = "load";
    private static final String LOAD_COUNT = "loadCount";
    private static final String LOAD_ALL_COUNTS = "loadAllCounts";
    private String _sMethod;
    private Vector<String> _vArgs = new Vector();

    public String getObjectNameSpace() {
        return SOAP_URN;
    }

    public String getMethodName() {
        return this._sMethod;
    }

    public Vector getArguments() {
        return this._vArgs;
    }

    public void create(DataSource dataSource) throws PersistenceException {
        this._sMethod = CREATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(dataSource, 0));
    }

    public void modify(DataSource dataSource) throws PersistenceException {
        this._sMethod = MODIFY;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(dataSource, 0));
    }

    public void remove(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        this._sMethod = REMOVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
    }

    public void disableAll(String dataSourceBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        this._sMethod = DISABLE_ALL;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        if (cal != null) {
            this._vArgs.add(TimeFormat.calendarToString(cal, "yyyy-MM-dd"));
        }
    }

    public void disable(String dataSourceBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        this._sMethod = DISABLE;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(dataType.getName());
        if (cal != null) {
            this._vArgs.add(TimeFormat.calendarToString(cal, "yyyy-MM-dd"));
        }
    }

    public void purgeAll(String dataSourceBatchUid, Calendar cal) throws PersistenceException, KeyNotFoundException {
        this._sMethod = PURGE_ALL;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        if (cal != null) {
            this._vArgs.add(TimeFormat.calendarToString(cal, "yyyy-MM-dd"));
        }
    }

    public void purge(String dataSourceBatchUid, DataType dataType, Calendar cal) throws PersistenceException, KeyNotFoundException {
        this._sMethod = PURGE;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(dataType.getName());
        if (cal != null) {
            this._vArgs.add(TimeFormat.calendarToString(cal, "yyyy-MM-dd"));
        }
    }

    public void purgeSnapshotSessions() throws PersistenceException {
        this._sMethod = PURGE_SNAPSHOT;
        this._vArgs.removeAllElements();
    }

    public void load(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        this._sMethod = LOAD;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
    }

    public void load() throws PersistenceException {
        this._sMethod = LOAD;
        this._vArgs.removeAllElements();
    }

    public void loadCount(String dataSourceBatchUid, DataType dataType, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        this._sMethod = LOAD_COUNT;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(dataType.getName());
        if (status != null) {
            this._vArgs.add(String.valueOf(ConversionUtility.rowStatusToInt(status)));
        }
    }

    public void loadAllCounts(String dataSourceBatchUid, IAdminObject.RowStatus status) throws PersistenceException, KeyNotFoundException {
        this._sMethod = LOAD_ALL_COUNTS;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        if (status != null) {
            this._vArgs.add(String.valueOf(ConversionUtility.rowStatusToInt(status)));
        }
    }

    protected static String convertToString(DataSource obj, int pos) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        sb.append("BatchUid" + pos);
        sb.append("=");
        sb.append(obj.getBatchUid());
        if (obj.getReplacementBatchUid() != null) {
            sb.append("\r\n");
            sb.append("ReplacementBatchUid" + pos);
            sb.append("=");
            sb.append(obj.getReplacementBatchUid());
        }
        if (obj.getDescription() != null) {
            sb.append("\r\n");
            sb.append("Description" + pos);
            sb.append("=");
            sb.append(obj.getDescription());
        }
        if (obj.getId() != null && obj.getId() != Id.UNSET_ID) {
            sb.append("\r\n");
            sb.append("id" + pos);
            sb.append("=");
            sb.append(obj.getId().toExternalString());
        }
        return sb.toString();
    }

    protected static String convertToString(DataSourceObjectCount obj, int pos) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        sb.append("ObjDataTable" + pos);
        sb.append("=");
        sb.append(obj.getObjectDataTable());
        sb.append("\r\n");
        sb.append("ObjCount" + pos);
        sb.append("=");
        sb.append(String.valueOf(obj.getObjectCount()));
        return sb.toString();
    }
}

