/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.datasource.impl.soap;

import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.datasource.DataSourceObjectCount;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.datasource.DataSourcePersister;
import blackboard.admin.persist.datasource.impl.soap.ClientUtility;
import blackboard.admin.persist.impl.soap.IServerUtility;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.persist.DataType;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.BbServiceManager;
import blackboard.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class ServerUtility
implements IServerUtility {
    public static void create(String dataSource) throws PersistenceException, ValidationException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        BbList col = ServerUtility.unMarshallDataSourceObject(dataSource);
        DataSource obj = (DataSource)col.get(0);
        p.create(obj);
    }

    public static void modify(String dataSource) throws PersistenceException, ValidationException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        BbList col = ServerUtility.unMarshallDataSourceObject(dataSource);
        DataSource obj = (DataSource)col.get(0);
        p.modify(obj);
    }

    public static void remove(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.removeByBatchUid(dataSourceBatchUid);
    }

    public static void disableAll(String dataSourceBatchUid, String cal) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.disableAllAdminObjects(dataSourceBatchUid, TimeFormat.stringToCalendar(cal, "yyyy-MM-dd"));
    }

    public static void disableAll(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.disableAllAdminObjects(dataSourceBatchUid, null);
    }

    public static void disable(String dataSourceBatchUid, String dataType, String cal) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        try {
            p.disableAdminObjectsByDataType(dataSourceBatchUid, new DataType(Class.forName(dataType)), TimeFormat.stringToCalendar(cal, "yyyy-MM-dd"));
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
    }

    public static void disable(String dataSourceBatchUid, String dataType) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        try {
            p.disableAdminObjectsByDataType(dataSourceBatchUid, new DataType(Class.forName(dataType)), null);
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
    }

    public static void purgeAll(String dataSourceBatchUid, String cal) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.purgeAllAdminObjects(dataSourceBatchUid, TimeFormat.stringToCalendar(cal, "yyyy-MM-dd"));
    }

    public static void purgeAll(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.purgeAllAdminObjects(dataSourceBatchUid, null);
    }

    public static void purge(String dataSourceBatchUid, String dataType, String cal) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        try {
            p.purgeAdminObjectsByDataType(dataSourceBatchUid, new DataType(Class.forName(dataType)), TimeFormat.stringToCalendar(cal, "yyyy-MM-dd"));
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
    }

    public static void purge(String dataSourceBatchUid, String dataType) throws PersistenceException, KeyNotFoundException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        try {
            p.purgeAdminObjectsByDataType(dataSourceBatchUid, new DataType(Class.forName(dataType)), null);
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
    }

    public void purgeSnapshotSessions() throws PersistenceException {
        DataSourcePersister p = (DataSourcePersister)ServerUtility.getPersister();
        p.purgeSnapshotSessions();
    }

    public static String load(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        DataSource obj = l.loadByBatchUid(dataSourceBatchUid);
        String tmp = ClientUtility.convertToString(obj, 0);
        return tmp;
    }

    public static String load() throws PersistenceException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        BbList list = l.loadAll();
        Iterator iter = list.iterator();
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (iter.hasNext()) {
            DataSource obj = (DataSource)iter.next();
            String tmp = ClientUtility.convertToString(obj, pos);
            sb.append(tmp);
            sb.append("\r\n");
            ++pos;
        }
        return sb.toString();
    }

    public static String loadCount(String dataSourceBatchUid, String dataType, String status) throws PersistenceException, KeyNotFoundException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        DataSourceObjectCount count = null;
        try {
            ConversionUtility cvUtil = new ConversionUtility();
            count = l.loadAdminObjectCount(dataSourceBatchUid, new DataType(Class.forName(dataType)), cvUtil.intToRowStatus(XmlUtil.parseInteger((String)status)));
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
        return ClientUtility.convertToString(count, 0);
    }

    public static String loadCount(String dataSourceBatchUid, String dataType) throws PersistenceException, KeyNotFoundException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        DataSourceObjectCount count = null;
        try {
            count = l.loadAdminObjectCount(dataSourceBatchUid, new DataType(Class.forName(dataType)), null);
        }
        catch (ClassNotFoundException cnf) {
            throw new PersistenceException((Throwable)cnf);
        }
        return ClientUtility.convertToString(count, 0);
    }

    public static String loadAllCounts(String dataSourceBatchUid, String status) throws PersistenceException, KeyNotFoundException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        ConversionUtility util = new ConversionUtility();
        BbList list = l.loadAllAdminObjectCounts(dataSourceBatchUid, util.intToRowStatus(XmlUtil.parseInteger((String)status)));
        Iterator iter = list.iterator();
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (iter.hasNext()) {
            DataSourceObjectCount obj = (DataSourceObjectCount)iter.next();
            String tmp = ClientUtility.convertToString(obj, pos);
            sb.append(tmp);
            sb.append("\r\n");
            ++pos;
        }
        return sb.toString();
    }

    public static String loadAllCounts(String dataSourceBatchUid) throws PersistenceException, KeyNotFoundException {
        DataSourceLoader l = (DataSourceLoader)ServerUtility.getLoader();
        BbList list = l.loadAllAdminObjectCounts(dataSourceBatchUid, null);
        Iterator iter = list.iterator();
        StringBuffer sb = new StringBuffer();
        int pos = 0;
        while (iter.hasNext()) {
            DataSourceObjectCount obj = (DataSourceObjectCount)iter.next();
            String tmp = ClientUtility.convertToString(obj, pos);
            sb.append(tmp);
            sb.append("\r\n");
            ++pos;
        }
        return sb.toString();
    }

    private static Persister getPersister() throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("DataSourcePersister");
    }

    private static Loader getLoader() throws PersistenceException {
        return BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("DataSourceLoader");
    }

    public static BbList unMarshallDataSourceObject(String src) throws PersistenceException {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(src.getBytes("UTF-8")));
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        BbList list = new BbList();
        int pos = 0;
        while (props.containsKey("BatchUid" + pos)) {
            DataSource obj = new DataSource();
            if (props.containsKey("BatchUid" + pos)) {
                obj.setBatchUid(props.getProperty("BatchUid" + pos));
            }
            if (props.containsKey("ReplacementBatchUid" + pos)) {
                obj.setReplacementBatchUid(props.getProperty("ReplacementBatchUid" + pos));
            }
            if (props.containsKey("Description" + pos)) {
                obj.setDescription(props.getProperty("Description" + pos));
            }
            if (props.containsKey("id" + pos)) {
                obj.setId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, props.getProperty("id" + pos)));
            }
            list.add((Object)obj);
            ++pos;
        }
        return list;
    }

    public static BbList unMarshallDataSourceObjectCount(String src) throws PersistenceException {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(src.getBytes("UTF-8")));
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        BbList list = new BbList();
        int pos = 0;
        while (props.containsKey("ObjDataTable" + pos)) {
            DataSourceObjectCount obj = new DataSourceObjectCount();
            if (props.containsKey("ObjDataTable" + pos)) {
                obj.setObjectDataTable(props.getProperty("ObjDataTable" + pos));
            }
            if (props.containsKey("ObjCount" + pos)) {
                obj.setObjectCount(XmlUtil.parseInteger((String)props.getProperty("ObjCount" + pos)));
            }
            list.add((Object)obj);
            ++pos;
        }
        return list;
    }
}

