/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.base.AppVersion;
import blackboard.base.NestedException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.Loader;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.platform.LicenseManager;
import blackboard.platform.soap.ClientRequest;
import blackboard.platform.soap.ServerResponse;
import blackboard.platform.soap.service.BbSoapClientService;

public abstract class AdminLoader
implements Loader {
    protected BbPersistenceManager _pm = null;
    protected AppVersion _appVersion = null;
    protected LicenseManager _lMgr;
    protected static final String DOES_NOT_EXIST = "does not exist";

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        this._pm = pm;
        this._appVersion = appVersion;
        this._lMgr = BbServiceManager.getLicenseManager();
        this.checkApiLicensing();
    }

    public AppVersion getAppVersion() {
        return this._appVersion;
    }

    protected void checkApiLicensing() {
        this._lMgr.runtimeAssertIsLicensed("integration.apis");
    }

    protected ServerResponse executeSoapCall(IClientUtility request) throws PersistenceException {
        BbSoapClientService service = (BbSoapClientService)BbServiceManager.safeLookupService(BbSoapClientService.class);
        ServerResponse response = null;
        try {
            response = service.processRequest(null, (ClientRequest)request);
            return response;
        }
        catch (NestedException ne) {
            String message = ne.getFullMessageTrace();
            if (message.indexOf(DOES_NOT_EXIST) > -1) {
                throw new KeyNotFoundException(message);
            }
            throw new PersistenceException((Throwable)ne);
        }
        catch (Exception exc) {
            throw new PersistenceException((Throwable)exc);
        }
    }
}

