/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.persist.impl.AdminSelectQuery;
import blackboard.base.AppVersion;
import blackboard.data.BbAttribute;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.data.user.User;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.impl.NewBaseDbLoader;
import blackboard.platform.BbServiceManager;
import blackboard.platform.LicenseManager;
import java.util.Calendar;
import java.util.List;

public class AdminNewBaseDbLoader
extends NewBaseDbLoader {
    protected LicenseManager _lMgr;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        super.init(pm, appVersion);
        this._lMgr = BbServiceManager.getLicenseManager();
        this.checkApiLicensing();
    }

    protected void checkApiLicensing() {
        this._lMgr.runtimeAssertIsLicensed("integration.apis");
    }

    protected void generateWhereClause(BbObject obj, AdminSelectQuery query) {
        BbAttributes bbAttribs = obj.getBbAttributes();
        List list = bbAttribs.getBbAttributeList();
        for (BbAttribute attrib : list) {
            if (!attrib.getIsDirty()) continue;
            if (attrib.getValue() == null || attrib.getValue() == User.Gender.UNKNOWN) {
                query.addNullWhere(attrib.getName());
                continue;
            }
            if (attrib.getValue() instanceof Calendar) {
                query.addDateAfterWhere(attrib.getName(), (Calendar)attrib.getValue());
                continue;
            }
            String value = attrib.getValue().toString();
            if (value.indexOf("%") >= 0 || value.indexOf("?") >= 0) {
                query.addLikeWhere(attrib.getName(), attrib.getValue());
                continue;
            }
            if (attrib.getType() == BbAttribute.Type.STRING) {
                if (query.getBbDatabase().isOracle()) {
                    if (attrib.getValue() != null) {
                        query.addLikeWhere(attrib.getName(), attrib.getValue());
                        continue;
                    }
                    query.addNullWhere(attrib.getName());
                    continue;
                }
                query.addLikeWhere(attrib.getName(), attrib.getValue());
                continue;
            }
            query.addWhere(attrib.getName(), attrib.getValue());
        }
    }
}

