/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.base.NestedException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.Persister;
import blackboard.platform.BbServiceManager;
import blackboard.platform.LicenseManager;
import blackboard.platform.soap.ClientRequest;
import blackboard.platform.soap.ServerResponse;
import blackboard.platform.soap.service.BbSoapClientService;
import blackboard.util.ObjectSerializer;
import java.util.ArrayList;

public abstract class AdminPersister
implements Persister {
    protected static final String DOES_NOT_EXIST = "does not exist";
    protected static final String CONSTRAINT_VIOLATION = "ConstraintViolationException";
    protected static final String KEYNOTFOUND_VIOLATION = "KeyNotFoundException";
    protected BbPersistenceManager _pm = null;
    protected AppVersion _appVersion = null;
    protected LicenseManager _lMgr;
    protected ConversionUtility _cvUtility;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        this._pm = pm;
        this._appVersion = appVersion;
        this._lMgr = BbServiceManager.getLicenseManager();
        this.checkApiLicensing();
        this._cvUtility = new ConversionUtility();
    }

    public AppVersion getAppVersion() {
        return this._appVersion;
    }

    protected void checkApiLicensing() {
        this._lMgr.runtimeAssertIsLicensed("integration.apis");
    }

    protected ServerResponse executeSoapCall(IClientUtility request) throws PersistenceException {
        BbSoapClientService service = (BbSoapClientService)BbServiceManager.safeLookupService(BbSoapClientService.class);
        ServerResponse response = null;
        try {
            response = service.processRequest(null, (ClientRequest)request);
            return response;
        }
        catch (NestedException ne) {
            String message = ne.getFullMessageTrace();
            if (message.indexOf(DOES_NOT_EXIST) > -1) {
                throw new KeyNotFoundException(message);
            }
            throw new PersistenceException(message);
        }
        catch (Exception exc) {
            throw new PersistenceException(exc.getMessage());
        }
    }

    protected void checkForConstraintViolationException(PersistenceException exc) throws ConstraintViolationException {
        String message = exc.getMessage();
        if (message.indexOf(CONSTRAINT_VIOLATION) > -1) {
            throw new ConstraintViolationException(message);
        }
    }

    protected void checkForKeyNotFoundException(PersistenceException exc) throws KeyNotFoundException {
        String message = exc.getMessage();
        if (message.indexOf(KEYNOTFOUND_VIOLATION) > -1) {
            throw new KeyNotFoundException(message);
        }
    }

    protected Results resolveInternalId(BbList objList, ServerResponse response, String idList) throws PersistenceException {
        Object obj = response.getResults();
        if (obj == null) {
            return null;
        }
        RemoteResults results = (RemoteResults)ObjectSerializer.deSerializeObject((String)((String)obj));
        ArrayList aList = (ArrayList)results.getAttribute(idList);
        if (aList == null) {
            return results;
        }
        for (int cnt = 0; cnt < aList.size(); ++cnt) {
            this.resolveInternalId((IAdminObject)objList.get(cnt), aList, cnt);
        }
        return results;
    }

    protected void resolveInternalId(IAdminObject objToUpdate, ServerResponse response) throws PersistenceException {
        Object obj = response.getResults();
        if (obj == null) {
            return;
        }
        this.resolveInternalId(objToUpdate, (ArrayList)ObjectSerializer.deSerializeObject((String)((String)obj)), 0);
    }

    protected void resolveInternalId(IAdminObject objToUpdate, ArrayList aList, int pos) throws PersistenceException {
        if (aList == null || aList.isEmpty()) {
            return;
        }
        String idString = (String)aList.get(pos);
        if (idString.length() == 0 || idString.indexOf("_") == -1) {
            return;
        }
        objToUpdate.setId(this._pm.generateId(objToUpdate.getDataType(), idString));
    }
}

