/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.db.BbDatabase;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.platform.BbServiceManager;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AdminRemoveProcedureQuery
extends StoredProcedureQuery {
    private DbObjectMap _dbBbObjMap = null;
    private BbObject _bbObj = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminRemoveProcedureQuery(DbObjectMap map, BbObject obj) {
        super("delete_" + map.getAliasTableName() + "_proc");
        DbObjectMap dbObjectMap = map;
        synchronized (dbObjectMap) {
            map.removeMapping("RecStatus");
        }
        List list = map.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        String[] aColumns = null;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (use == DbMapping.Use.NONE) continue;
            aColumns = mapping2.getColumns();
            for (int j = 0; j < aColumns.length; ++j) {
                if (use == DbMapping.Use.INPUT) {
                    this.addInputParameter(aColumns[j]);
                    continue;
                }
                if (use == DbMapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    if (aColumns[j].startsWith("p_")) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    this.addOutputParameter("p_" + aColumns[j]);
                    continue;
                }
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("db.mapping.invalid");
                throw new RuntimeException(msg + use.toString());
            }
        }
        this._dbBbObjMap = map;
        this._bbObj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            BbDatabase bbDatabase = BbServiceManager.getJdbcService().getDefaultDatabase();
            if (bbDatabase != null) {
                this._bUseResultSet = new Boolean(bbDatabase.isSqlServer());
            } else {
                throw new RuntimeException(ConfigurationManager.getGlobalLocaleExceptionMessage("db.no.output.type"));
            }
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        BbAttributes attribs = this._bbObj.getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        int nStartPos = 0;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            String mapName = mapping2.getColumns()[0];
            nStartPos = this.getColumnPosition(mapName);
            if (use == DbMapping.Use.INPUT) {
                mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, nStartPos, attribs.getBbAttribute(mapping2.getName()).getValue());
                continue;
            }
            if (use != DbMapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping2.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping2.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            String mapName = mapping2.getColumns()[0];
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            obj = mapping2.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            obj = mapping2.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }
}

