/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.impl;

import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.data.IBbObject;
import blackboard.db.BbDatabase;
import blackboard.db.DbUtil;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.GenericProcedureQuery;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.IDbLobMapping;
import blackboard.platform.BbServiceManager;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class AdminUpdateProcedureQuery
extends GenericProcedureQuery {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminUpdateProcedureQuery(DbObjectMap map, BbObject obj) {
        super("update_" + map.getAliasTableName() + "_proc");
        DbObjectMap dbObjectMap = map;
        synchronized (dbObjectMap) {
            map.removeMapping("RecStatus");
        }
        List list = map.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        String[] aColumns = null;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (use == DbMapping.Use.NONE) continue;
            aColumns = mapping2.getColumns();
            for (int j = 0; j < aColumns.length; ++j) {
                if (use == DbMapping.Use.INPUT) {
                    if (aColumns[j].equals("data_src_pk1")) continue;
                    if (aColumns[j].startsWith("p_")) {
                        this.addInputParameter(aColumns[j]);
                        continue;
                    }
                    this.addInputParameter("p_" + aColumns[j]);
                    this.addInputParameter("f_" + aColumns[j]);
                    continue;
                }
                if (use == DbMapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    if (aColumns[j].startsWith("p_")) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    this.addOutputParameter("p_" + aColumns[j]);
                    continue;
                }
                String msg = ConfigurationManager.getGlobalLocaleExceptionMessage("db.mapping.invalid");
                throw new RuntimeException(msg + use.toString());
            }
        }
        this._dbBbObjMap = map;
        this._obj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            BbDatabase bbDatabase = BbServiceManager.getJdbcService().getDefaultDatabase();
            if (bbDatabase != null) {
                this._bUseResultSet = new Boolean(bbDatabase.isSqlServer());
            } else {
                throw new RuntimeException(ConfigurationManager.getGlobalLocaleExceptionMessage("db.no.output.type"));
            }
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        if (!(this._obj instanceof IBbObject)) {
            throw new PersistenceException("CMS-Admin objects must sub-class BbObject");
        }
        BbAttributes attribs = ((IBbObject)this._obj).getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        int nStartPos = 0;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (this._bbDatabase.isOracle() && mapping2 instanceof IDbLobMapping) {
                this._bDoOracleLobKludge = true;
            }
            String mapName = mapping2.getColumns()[0];
            nStartPos = this.getColumnPosition(mapName);
            if (use == DbMapping.Use.INPUT) {
                if (mapName.equals("data_src_pk1")) continue;
                if (mapName.startsWith("p_")) {
                    mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, nStartPos, this._dbBbObjMap.getTargetValue(this._obj, mapping2.getName()));
                    continue;
                }
                mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), this._dbBbObjMap.getTargetValue(this._obj, mapping2.getName()));
                DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping2.getName()).getIsDirty()));
                continue;
            }
            if (use != DbMapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping2.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping2.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            String mapName = mapping2.getColumns()[0];
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            obj = mapping2.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue(this._obj, mapping2.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            obj = mapping2.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue(this._obj, mapping2.getName(), obj);
        }
    }
}

