/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.integration.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.integration.LmsIntegrationLoader;
import blackboard.admin.persist.integration.LmsIntegrationPersister;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.course.Course;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.platform.integration.CourseLmsIntegration;
import blackboard.platform.integration.LmsIntegration;
import blackboard.platform.integration.service.LmsIntegrationManagerFactory;
import blackboard.platform.log.LogServiceFactory;
import blackboard.util.ExceptionUtil;

public class CourseLmsIntegrationPersister
implements SnapshotPersister {
    private CourseSitePersister _internalPersister = null;
    private LmsIntegration _integration = null;
    private Authority _authority = null;
    private CourseLmsIntegrationTransformer _transformer = null;
    private static final String BATCHUID_CONSTRAINT = "course_main_ak1";
    private static final String COURSEID_CONSTRAINT = "course_main_ak2";
    private static final String IMMUTABLE_COURSE_ID = "Course id is immutable";

    public CourseLmsIntegrationPersister(LmsIntegration integration, CourseSitePersister persister, Authority authority) {
        this._internalPersister = persister;
        this._integration = integration;
        this._authority = authority;
        this._transformer = new CourseLmsIntegrationTransformer();
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        this._internalPersister.closeSession(strSessionId);
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        this._internalPersister.createSession(dataSourceBatchUid, sessionId);
    }

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return this._internalPersister.createSession(dataSourceBatchUid);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return this._internalPersister.remove(objList);
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this._internalPersister.save(obj, strSessionId);
    }

    public Results save(BbList objList, String sessionId) throws PersistenceException {
        Results results = new Results();
        this._transformer.transform(objList);
        results = this.saveCourses(objList, sessionId);
        BbList filteredList = this.removeObjectsWithErrors(objList, results);
        LmsIntegrationLoader loader = LmsIntegrationLoader.Default.getInstance();
        for (CourseSite course : filteredList) {
            CourseLmsIntegration courseIntegration;
            if (((Object)((Object)course.getRecStatus())).equals((Object)IAdminObject.RecStatus.DELETE) || (courseIntegration = loader.getCourseIntegration(course.getId())) != null) continue;
            this.saveCourseIntegration(results, course);
        }
        return results;
    }

    private Results saveCourses(BbList objList, String sessionId) throws PersistenceException {
        Results results = this._internalPersister.save(objList, sessionId);
        return this.handleUniqueIdErrors(objList, results, sessionId);
    }

    private void updateChangedCourseId(CourseSite course, Results myResults, String sessionId) {
        String originalCourseId = course.getCourseId();
        try {
            CourseSiteLoader loader = CourseSiteLoader.Default.getInstance();
            CourseSite loadedCourse = loader.load(course.getBatchUid());
            if (!course.getCourseId().equals(loadedCourse.getCourseId())) {
                course.setCourseId(loadedCourse.getCourseId());
                this._internalPersister.save(course, sessionId);
                String str = "Course ID conflict for course with id \"%s\" and batchUid \"%s\". Changed id to \"%s\".";
                this._authority.logWarning(String.format(str, originalCourseId, course.getBatchUid(), course.getCourseId()));
            }
        }
        catch (ValidationException e) {
            myResults.addError((BbObject)course, new PersistenceException((Throwable)e));
        }
        catch (PersistenceException e) {
            myResults.addError((BbObject)course, e);
        }
    }

    private Results handleUniqueIdErrors(BbList objList, Results results, String sessionId) {
        Results newResults = new Results();
        for (int i = 0; i < results.getErrorCount(); ++i) {
            Results.Error err = results.getError(i);
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)err.getException(), (String)COURSEID_CONSTRAINT) || ExceptionUtil.isSqlConstraintViolation((Throwable)err.getException(), (String)BATCHUID_CONSTRAINT)) {
                LmsIntegration.ResolutionUseCase resolutionUseCase = this._integration.getResolutionUseCase();
                switch (resolutionUseCase) {
                    case Always: 
                    case Never: {
                        newResults.addError(err);
                        break;
                    }
                    case OnCollision: {
                        CourseSite course = (CourseSite)err.getObject();
                        this.resolveConflictsAndResave(sessionId, newResults, course);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid resolution use case encountered.");
                    }
                }
                continue;
            }
            if (ExceptionUtil.isSqlConstraintViolation((Throwable)err.getException(), (String)IMMUTABLE_COURSE_ID)) {
                CourseSite course = (CourseSite)err.getObject();
                this.updateChangedCourseId(course, newResults, sessionId);
                continue;
            }
            newResults.addError(err);
        }
        return newResults;
    }

    private void resolveConflictsAndResave(String sessionId, Results results, CourseSite course) {
        try {
            String originalCourseId = course.getCourseId();
            String originalBatchUid = course.getBatchUid();
            this._transformer.applyConflictResolution(course);
            this._internalPersister.save(course, sessionId);
            String message = "Collision Detected: Changed course_id/batch_uid from " + originalCourseId + "/" + originalBatchUid + " to " + course.getCourseId() + "/" + course.getBatchUid();
            this._authority.logWarning(message);
        }
        catch (ValidationException e) {
            results.addError((BbObject)course, new PersistenceException((Throwable)e));
        }
        catch (PersistenceException pe) {
            results.addError((BbObject)course, pe);
        }
    }

    private void saveCourseIntegration(Results results, CourseSite course) {
        CourseLmsIntegration courseIntegration = this.buildCourseIntegrationObject(this._integration, course);
        try {
            LmsIntegrationPersister persister = (LmsIntegrationPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("LmsIntegrationPersister");
            persister.saveCourseIntegration(courseIntegration);
        }
        catch (Exception e) {
            results.addError((BbObject)course, new PersistenceException("Could not create an integration between course " + course.getId() + " and integration " + this._integration.getId(), (Throwable)e));
        }
    }

    private BbList removeObjectsWithErrors(BbList objList, Results results) {
        BbList filteredList = (BbList)objList.clone();
        int numErrors = results.getErrorCount();
        if (numErrors > 0) {
            for (int i = 0; i < numErrors; ++i) {
                Results.Error error = results.getError(i);
                CourseSite failedCourseSite = (CourseSite)error.getObject();
                if (!filteredList.contains((Object)failedCourseSite)) continue;
                filteredList.remove((Object)failedCourseSite);
            }
        }
        return filteredList;
    }

    private CourseLmsIntegration buildCourseIntegrationObject(LmsIntegration integration, CourseSite course) {
        CourseLmsIntegration courseIntegration = new CourseLmsIntegration();
        courseIntegration.setCourseId(course.getId());
        courseIntegration.setLmsIntegrationId(integration.getId());
        courseIntegration.setSourcedidId(course.getBbAttributes().getString("sourcedid_id"));
        courseIntegration.setSourcedidSource(course.getSourcedidSource());
        return courseIntegration;
    }

    private class CourseLmsIntegrationTransformer {
        private CourseLmsIntegrationTransformer() {
        }

        public void transform(BbList courses) {
            for (CourseSite course : courses) {
                Course oldCourse = this.getExistingIntegratedCourse(course);
                if (null != oldCourse) {
                    this.populateFromExistingCourse(course, oldCourse);
                    continue;
                }
                this.transformNewCourse(course);
            }
        }

        private Course getExistingIntegratedCourse(CourseSite course) {
            try {
                return LmsIntegrationManagerFactory.getInstance().getCourseBySourcedid(CourseLmsIntegrationPersister.this._integration.getId(), course.getSourcedidSource(), course.getBbAttributes().getString("sourcedid_id"));
            }
            catch (PersistenceException e) {
                LogServiceFactory.getInstance().logError("Unexpected exception", (Throwable)e);
                return null;
            }
        }

        private void populateFromExistingCourse(CourseSite course, Course oldCourse) {
            course.setCourseId(oldCourse.getCourseId());
            course.setBatchUid(oldCourse.getBatchUid());
        }

        private void applyConflictResolution(CourseSite course) {
            course.setCourseId(this.resolveIdConflict(course.getCourseId()));
            course.setBatchUid(this.resolveIdConflict(course.getBatchUid()));
        }

        private void transformNewCourse(CourseSite course) {
            String courseId = this.replaceIllegalChars(course.getCourseId());
            course.setCourseId(courseId);
            if (CourseLmsIntegrationPersister.this._integration.getResolutionUseCase() == LmsIntegration.ResolutionUseCase.Always) {
                this.applyConflictResolution(course);
            }
        }

        private String resolveIdConflict(String id) {
            LmsIntegration.ResolutionStringType strType = CourseLmsIntegrationPersister.this._integration.getResolutionStringType();
            return strType.apply(id, CourseLmsIntegrationPersister.this._integration.getResolutionString());
        }

        private String replaceIllegalChars(String s) {
            if (s != null) {
                char[] charBuffer = s.toCharArray();
                for (int pos = 0; pos < charBuffer.length; ++pos) {
                    if (Character.isLetterOrDigit(charBuffer[pos])) continue;
                    boolean bCheck = false;
                    for (int val = 0; val < AdminCourse.validChars.length; ++val) {
                        if (charBuffer[pos] != AdminCourse.validChars[val]) continue;
                        bCheck = true;
                        break;
                    }
                    if (bCheck) continue;
                    charBuffer[pos] = 95;
                }
                return String.valueOf(charBuffer);
            }
            return "";
        }
    }
}

