/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.integration.impl;

import blackboard.admin.persist.impl.AdminNewBaseDbLoader;
import blackboard.admin.persist.integration.LmsIntegrationLoader;
import blackboard.data.role.PortalRole;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.SelectQuery;
import blackboard.persist.impl.SimpleJoinQuery;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.FilteredDbObjectMap;
import blackboard.persist.impl.mapping.annotation.AnnotationMappingFactory;
import blackboard.persist.role.impl.PortalRoleDbMap;
import blackboard.platform.integration.CourseLmsIntegration;
import blackboard.platform.integration.LmsIntegration;
import blackboard.platform.integration.service.LmsIntegrationManagerFactory;
import blackboard.platform.query.Criteria;
import java.util.List;

public class LmsIntegrationDbLoader
extends AdminNewBaseDbLoader
implements LmsIntegrationLoader {
    public LmsIntegration getIntegrationByGlcId(String glcId) throws KeyNotFoundException, PersistenceException {
        FilteredDbObjectMap portalRoleMap = new FilteredDbObjectMap(PortalRoleDbMap.MAP, new String[]{"RoleID"});
        SimpleJoinQuery query = new SimpleJoinQuery(AnnotationMappingFactory.getMap(LmsIntegration.class), "li");
        query.addJoin(SimpleJoinQuery.JoinType.Inner, (DbObjectMap)portalRoleMap, "role", "id", "roleId", true);
        Criteria c = query.getCriteria();
        c.add(c.equal("institutionGlcid", (Object)glcId));
        List list = super.loadList((SelectQuery)query, null);
        List integrationList = (List)list.get(0);
        LmsIntegration integration = (LmsIntegration)integrationList.get(0);
        PortalRole role = (PortalRole)integrationList.get(1);
        integration.setRoleName(role.getRoleID());
        return integration;
    }

    public CourseLmsIntegration getCourseIntegration(Id courseId) {
        return LmsIntegrationManagerFactory.getInstance().getCourseIntegration(courseId);
    }

    public List getIntegrationsByUsersSourcedId(String source, String id) throws KeyNotFoundException, PersistenceException {
        return LmsIntegrationManagerFactory.getInstance().getIntegrationsByUsersSourcedId(source, id);
    }
}

