/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.integration.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.Membership;
import blackboard.admin.persist.integration.impl.LmsIntegrationCourseResolver;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.base.BbList;
import blackboard.data.ValidationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.integration.LmsIntegration;

public class MembershipLmsIntegrationPersister
implements SnapshotPersister {
    private SnapshotPersister _internalPersister = null;
    private LmsIntegration _integration = null;
    private Authority _authority = null;

    public MembershipLmsIntegrationPersister(LmsIntegration integration, SnapshotPersister persister, Authority authority) {
        this._internalPersister = persister;
        this._integration = integration;
        this._authority = authority;
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        this._internalPersister.closeSession(strSessionId);
    }

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return this._internalPersister.createSession(dataSourceBatchUid);
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        this._internalPersister.createSession(dataSourceBatchUid, sessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return this._internalPersister.remove(objList);
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveIntegrationBatchUid((Membership)obj);
        this._internalPersister.save(obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveIntegrationBatchUid(objList);
        return this._internalPersister.save(objList, strSessionId);
    }

    private void resolveIntegrationBatchUid(Membership obj) throws PersistenceException {
        LmsIntegrationCourseResolver.resolveBatchUid(this._integration, obj, "GroupSourcedidSource", "GroupBatchUid");
        LmsIntegrationCourseResolver.resolveBatchUid(this._integration, obj, "InheritedFromGroupSourcedidSource", "InheritedFromGroupBatchUid");
    }

    private void resolveIntegrationBatchUid(BbList objList) throws PersistenceException {
        for (Membership obj : objList) {
            this.resolveIntegrationBatchUid(obj);
        }
    }
}

