/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.integration.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.integration.LmsIntegrationLoader;
import blackboard.admin.persist.integration.LmsIntegrationPersister;
import blackboard.admin.persist.role.PortalRoleMembershipPersister;
import blackboard.admin.persist.user.PersonLoader;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.InsertProcedureQuery;
import blackboard.persist.impl.Query;
import blackboard.persist.user.UserDbLoader;
import blackboard.platform.BbServiceManager;
import blackboard.platform.RuntimeBbServiceException;
import blackboard.platform.integration.LmsIntegration;
import blackboard.platform.integration.UserLmsIntegration;
import blackboard.platform.security.Domain;
import blackboard.platform.security.DomainAdmin;
import blackboard.platform.security.DomainManagerFactory;
import blackboard.platform.security.impl.DomainAdminDbMap;
import blackboard.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonLmsIntegrationPersister
implements SnapshotPersister {
    private PersonPersister _internalPersister = null;
    private LmsIntegration _integration = null;
    private Authority _authority = null;
    private HashMap<String, String> _originalUserNames = new HashMap();
    private static final String BATCHUID_CONSTRAINT = "users_ak1";
    private static final String USERID_CONSTRAINT = "users_ak2";

    public PersonLmsIntegrationPersister(LmsIntegration integration, PersonPersister persister, Authority authority) {
        this._integration = integration;
        this._internalPersister = persister;
        this._authority = authority;
    }

    @Override
    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        this._internalPersister.closeSession(strSessionId);
    }

    @Override
    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        this._internalPersister.createSession(dataSourceBatchUid, sessionId);
    }

    @Override
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return this._internalPersister.createSession(dataSourceBatchUid);
    }

    @Override
    public Results remove(BbList objList) throws PersistenceException {
        return this._internalPersister.remove(objList);
    }

    @Override
    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this._internalPersister.save(obj, strSessionId);
    }

    @Override
    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        HashMap<String, BbList> beforeMap = this.beforeLmsPersonPersist(objList);
        BbList newUsers = beforeMap.get("newUsers");
        BbList existingUsers = beforeMap.get("existingUsers");
        Results results = new Results();
        results.addAllResults(this.afterLmsPersonPersistLoop(this._integration, newUsers, strSessionId, false));
        results.addAllResults(this.afterLmsPersonPersistLoop(this._integration, existingUsers, strSessionId, true));
        return results;
    }

    private Results afterLmsPersonPersistLoop(LmsIntegration integration, BbList persons, String strSessionId, boolean areExisting) throws PersistenceException {
        Results results = new Results();
        if (persons.size() > 0) {
            Iterator iter = persons.iterator();
            while (iter.hasNext()) {
                Results userResult = new Results();
                Person person = (Person)iter.next();
                try {
                    this._internalPersister.save(person, strSessionId);
                }
                catch (PersistenceException persistenceException) {
                    userResult.addError((BbObject)person, persistenceException);
                    results = this.handleErrors(userResult);
                }
                catch (ValidationException validationException) {
                    userResult.addError((BbObject)person, new PersistenceException((Throwable)validationException));
                }
            }
            results = this.afterLmsPersonPersist(persons, results, areExisting);
        }
        return results;
    }

    private HashMap<String, BbList> beforeLmsPersonPersist(BbList list) throws PersistenceException {
        HashMap<String, BbList> results = new HashMap<String, BbList>();
        BbList newUsers = new BbList();
        BbList existingUsers = new BbList();
        for (Person person : list) {
            person.setDataSourceId(this._authority.getDataSource().getId());
            person.setDataSourceBatchUid(this._authority.getDataSource().getBatchUid());
            List<List> integrationsForUser = this.getIntegrations(person);
            String rawUserName = person.getBbAttributes().getString("RawUserName");
            this._originalUserNames.put(person.getBatchUid(), rawUserName);
            if (integrationsForUser.size() == 0) {
                if (this._integration.getResolutionUseCase() == LmsIntegration.ResolutionUseCase.Always) {
                    String newUserName = this.resolveUserName(person.getUserName());
                    person.setUserName(newUserName);
                }
                newUsers.add((Object)person);
                continue;
            }
            Id userId = this.getUserId(integrationsForUser);
            person.setId(userId);
            if (((Object)((Object)person.getRecStatus())).equals((Object)IAdminObject.RecStatus.DELETE)) {
                this.deintegrateUser(person, this._integration);
                continue;
            }
            String lmsUserName = this.getUsernameInCurrentIntegration(integrationsForUser);
            if (lmsUserName == null) {
                lmsUserName = this.integrateUser(person);
            } else {
                this.checkAndRenameUser(person, lmsUserName);
            }
            int lowestPriority = this.getLowestDelegationPriority(integrationsForUser);
            if (this._integration.getDelegationPriority() <= lowestPriority) {
                User existingUser = UserDbLoader.Default.getInstance().loadById(userId);
                person.setUserName(existingUser.getUserName());
                existingUsers.add((Object)person);
                continue;
            }
            String str = "Integration \"%s\" is not the Authoritative Integration for user \"%s\".  THis user will not be updated.";
            str = String.format(str, this._integration.getShortName(), lmsUserName);
            this._authority.logWarning(str);
        }
        results.put("newUsers", newUsers);
        results.put("existingUsers", existingUsers);
        return results;
    }

    private List<List> getIntegrations(Person person) throws PersistenceException {
        return this.getLmsLoader().getIntegrationsByUsersSourcedId(person.getSourcedidSource(), person.getBatchUid());
    }

    private void deintegrateUser(Person person, LmsIntegration integration) {
        try {
            this.getLmsPersister().removeUserFromLmsIntegration(person.getId(), integration.getId());
        }
        catch (Exception e) {
            String str = "The user \"%s\" could not be removed from integration \"%s\".";
            str = String.format(str, person.getUserName(), integration.getShortName());
            try {
                this._authority.logError((BbObject)person, str, (Exception)((Object)new SnapshotException(str, e)));
            }
            catch (SnapshotException se) {
                // empty catch block
            }
        }
    }

    private String integrateUser(Person person) throws PersistenceException {
        PortalRoleMembership membership = new PortalRoleMembership();
        membership.setDataSourceId(this._authority.getDataSource().getId());
        membership.setPersonBatchUid(person.getBatchUid());
        membership.setPortalRoleBatchUid(this._integration.getRoleName());
        String lmsUserName = this._originalUserNames.get(person.getBatchUid());
        try {
            Domain domain;
            this.getPortalRoleMemPersister().save(membership, this._authority.getSessionId());
            this.getLmsPersister().addUserToLmsIntegration(person.getId(), this._integration.getId(), lmsUserName, person.getSourcedidSource(), person.getBatchUid());
            String integrationRoleIdentifier = person.getBbAttributes().getString("LmsIntegrationRole");
            if (integrationRoleIdentifier != null && (domain = DomainManagerFactory.getInstance().getDomainByBatchUid(this._integration.getInstitutionGlcid())) != null) {
                DomainAdmin domAdmin = new DomainAdmin();
                domAdmin.setDomainId(domain.getId());
                domAdmin.setRole(integrationRoleIdentifier);
                domAdmin.setUserId(person.getId());
                BbPersistenceManager bbpm = BbServiceManager.getPersistenceService().getDbPersistenceManager();
                InsertProcedureQuery insertRole = new InsertProcedureQuery(DomainAdminDbMap.MAP, (Object)domAdmin);
                bbpm.runDbQuery((Query)insertRole, null);
            }
        }
        catch (ValidationException e) {
            try {
                this._authority.logError((BbObject)person, "Error adding user to the integration ", (Exception)((Object)e));
            }
            catch (SnapshotException se) {
                // empty catch block
            }
        }
        return lmsUserName;
    }

    private String getUsernameInCurrentIntegration(List integrations) {
        String lmsUsername = null;
        for (List lmsIntegrationList : integrations) {
            LmsIntegration lmsIntegration = (LmsIntegration)lmsIntegrationList.get(0);
            UserLmsIntegration userLmsIntegration = (UserLmsIntegration)lmsIntegrationList.get(1);
            if (!this._integration.getId().equals((Object)lmsIntegration.getId())) continue;
            lmsUsername = userLmsIntegration.getLmsUsername();
        }
        return lmsUsername;
    }

    private Id getUserId(List<List> integrations) {
        List innerList = integrations.iterator().next();
        UserLmsIntegration userLmsIntegration = (UserLmsIntegration)innerList.get(1);
        return userLmsIntegration.getUserId();
    }

    private int getLowestDelegationPriority(List<List> integrations) {
        int delegationPriority = Integer.MAX_VALUE;
        for (List list : integrations) {
            LmsIntegration lmsIntegration = (LmsIntegration)list.get(0);
            if (lmsIntegration.getDelegationPriority() >= delegationPriority) continue;
            delegationPriority = lmsIntegration.getDelegationPriority();
        }
        return delegationPriority;
    }

    private void checkAndRenameUser(Person person, String lmsUserName) throws PersistenceException {
        String originalUserName = this._originalUserNames.get(person.getBatchUid());
        if (!lmsUserName.equals(originalUserName)) {
            try {
                this.getLmsPersister().setLmsUsername(this._integration.getId(), person.getId(), originalUserName);
                String str = "Changed lmsUsername for user, from \"%s\" to \"%s\"";
                this._authority.logWarning(String.format(str, lmsUserName, originalUserName));
            }
            catch (ValidationException e) {
                try {
                    this._authority.logError((BbObject)person, "Error changing lmsUsername for user " + lmsUserName, (Exception)((Object)e));
                }
                catch (SnapshotException se) {
                    // empty catch block
                }
            }
        }
    }

    private Results afterLmsPersonPersist(BbList list, Results results, boolean areExisting) throws PersistenceException {
        PersonLoader personLoader = PersonLoader.Default.getInstance();
        if (!areExisting) {
            for (Person user : list) {
                try {
                    Person fetchedUser = personLoader.load(user.getBatchUid());
                    user.setId(fetchedUser.getId());
                    this.integrateUser(user);
                }
                catch (KeyNotFoundException knfe) {
                }
                catch (PersistenceException e) {
                    results.addError((BbObject)user, e);
                }
            }
        }
        return results;
    }

    private Results handleErrors(Results results) {
        Results newResults = new Results();
        Results.Error error = results.getError(0);
        Person person = (Person)error.getObject();
        String userName = person.getUserName();
        if (ExceptionUtil.isSqlConstraintViolation((Throwable)error.getException(), (String)BATCHUID_CONSTRAINT)) {
            throw new RuntimeException("Invalid constraint encountered.");
        }
        if (ExceptionUtil.isSqlConstraintViolation((Throwable)error.getException(), (String)USERID_CONSTRAINT)) {
            LmsIntegration.ResolutionUseCase resolutionUseCase = this._integration.getResolutionUseCase();
            switch (resolutionUseCase) {
                case Always: 
                case Never: {
                    newResults.addError(error);
                    break;
                }
                case OnCollision: {
                    person.setUserName(this.resolveUserName(userName));
                    try {
                        this._internalPersister.save(person);
                        String message = "Collision Detected: Changed username from " + userName + " to " + person.getUserName();
                        this._authority.logWarning(message);
                    }
                    catch (ConstraintViolationException e) {
                        newResults.addError(error);
                    }
                    catch (ValidationException e) {
                        newResults.addError(error);
                    }
                    catch (PersistenceException pe) {
                        newResults.addError(error);
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid resolution use case encountered.");
                }
            }
        } else {
            newResults.addError(error);
        }
        return newResults;
    }

    private LmsIntegrationLoader getLmsLoader() throws PersistenceException, RuntimeBbServiceException {
        return LmsIntegrationLoader.Default.getInstance();
    }

    private LmsIntegrationPersister getLmsPersister() throws PersistenceException, RuntimeBbServiceException {
        return LmsIntegrationPersister.Default.getInstance();
    }

    private PortalRoleMembershipPersister getPortalRoleMemPersister() throws PersistenceException, RuntimeBbServiceException {
        return PortalRoleMembershipPersister.Default.getInstance();
    }

    private String resolveUserName(String userName) {
        LmsIntegration.ResolutionStringType strType = this._integration.getResolutionStringType();
        return strType.apply(userName, this._integration.getResolutionString());
    }
}

