/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.role.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.role.PortalRoleMembershipPersister;
import blackboard.admin.persist.role.impl.PortalRoleMembershipDbLoader;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipDeleteDbMap;
import blackboard.admin.persist.role.impl.mapping.PortalRoleMembershipPersisterDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class PortalRoleMembershipDbPersister
extends SnapshotDbPersister
implements PortalRoleMembershipPersister {
    String[] CONSTRAINTS = new String[]{"USER_ROLES_PK", "USERS_INST_ROLES_UK1"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "userrole");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "userrole", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "userrole");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((PortalRoleMembership)obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(PortalRoleMembershipPersisterDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(PortalRoleMembershipDeleteDbMap.MAP, objList);
    }

    public void save(PortalRoleMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void save(PortalRoleMembership objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(PortalRoleMembershipPersisterDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(PortalRoleMembership objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(PortalRoleMembership objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(PortalRoleMembershipPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void remove(PortalRoleMembership objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(PortalRoleMembershipDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(PortalRoleMembership objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("PersonBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("PortalRoleBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        PortalRoleMembershipDbLoader loader = (PortalRoleMembershipDbLoader)this._pm.getLoader("PortalRoleMembershipLoader");
        PortalRoleMembership obj = new PortalRoleMembership();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        PortalRoleMembership personRole = (PortalRoleMembership)list.get(0);
        objInput.setPersonBatchUid(personRole.getPersonBatchUid());
        objInput.setPortalRoleBatchUid(personRole.getPortalRoleBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (PortalRoleMembership obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

