/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.role.impl.soap.portalrolemembership;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.persist.impl.soap.IClientUtility;
import blackboard.admin.persist.role.PortalRoleMembershipXmlPersister;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.base.BbList;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.util.ObjectSerializer;
import blackboard.xml.XmlUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClientUtility
implements IClientUtility {
    private static final String SOAP_URN = "PortalRoleMembershipServerUtility";
    private static final String SAVE = "save";
    private static final String INSERT = "insert";
    private static final String UPDATE = "update";
    private static final String REMOVE = "remove";
    private static final String REMOVE_LIST = "removeList";
    private static final String CREATE_SESSION = "createSession";
    private static final String CLOSE_SESSION = "closeSession";
    private static final String LOAD = "load";
    private static final String LOAD_BY_TEMPLATE = "loadByTemplate";
    private String _sMethod;
    private Vector<String> _vArgs = new Vector();

    public String getObjectNameSpace() {
        return SOAP_URN;
    }

    public void insert(PortalRoleMembership obj) throws PersistenceException {
        this._sMethod = INSERT;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(obj));
    }

    public void update(PortalRoleMembership obj) throws PersistenceException {
        this._sMethod = UPDATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(obj));
    }

    public void save(PortalRoleMembership obj) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(obj));
    }

    public void save(IAdminObject obj, String sessionId) throws PersistenceException {
        this.save((PortalRoleMembership)obj, sessionId);
    }

    public void save(PortalRoleMembership obj, String sessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(obj));
        this._vArgs.add(sessionId);
    }

    public void save(BbList list) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(list));
    }

    public void save(BbList list, String sessionId) throws PersistenceException {
        this._sMethod = SAVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(list));
        this._vArgs.add(sessionId);
        Authority.getSettings().setProperty("encrypt.password", "N");
        this._vArgs.add(ObjectSerializer.serializeObject((Object)Authority.getSettings()));
    }

    public void remove(PortalRoleMembership obj) throws PersistenceException {
        this._sMethod = REMOVE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(obj));
    }

    public void remove(BbList list) throws PersistenceException {
        this._sMethod = REMOVE_LIST;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(list));
    }

    public void createSession(String dataSourceBatchUid) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
    }

    public void createSession(String dataSourceBatchUid, String session) {
        this._sMethod = CREATE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(dataSourceBatchUid);
        this._vArgs.add(session);
    }

    public void closeSession(String strSessionId) {
        this._sMethod = CLOSE_SESSION;
        this._vArgs.removeAllElements();
        this._vArgs.add(strSessionId);
    }

    public void load(String personBatchUid, String roleBatchUid) {
        this._sMethod = LOAD;
        this._vArgs.removeAllElements();
        this._vArgs.add(personBatchUid);
        this._vArgs.add(roleBatchUid);
    }

    public void load(PortalRoleMembership template) throws PersistenceException {
        this._sMethod = LOAD_BY_TEMPLATE;
        this._vArgs.removeAllElements();
        this._vArgs.add(ClientUtility.convertToString(template));
    }

    public String getMethodName() {
        return this._sMethod;
    }

    public Vector getArguments() {
        return this._vArgs;
    }

    protected static String convertToString(PortalRoleMembership obj) throws PersistenceException {
        Document doc;
        PortalRoleMembershipXmlPersister persist = (PortalRoleMembershipXmlPersister)BbServiceManager.getPersistenceService().getXmlPersistenceManager().getPersister("PortalRoleMembershipXmlPersister");
        try {
            doc = XmlUtil.buildDocument();
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        Element element = persist.persist(obj, doc);
        doc.appendChild(element);
        String tmp = null;
        try {
            tmp = XmlUtil.createEncodedStringFromDoc((Document)doc, (boolean)false, (String)"UTF-8");
        }
        catch (IOException io) {
            throw new PersistenceException((Throwable)io);
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
        return tmp;
    }

    protected static String convertToString(BbList list) throws PersistenceException {
        StringBuffer sb = new StringBuffer();
        Iterator iter = list.iterator();
        sb.append("<enterprise>");
        while (iter.hasNext()) {
            sb.append(ClientUtility.convertToString((PortalRoleMembership)iter.next()));
        }
        sb.append("</enterprise>");
        return sb.toString();
    }
}

