/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.persist.impl.AdminSelectQuery;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationDbMap;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.user.observer.ObserverUserException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminObserverSelectQuery
extends AdminSelectQuery {
    private static final String USERS_OBSERVER_ALIAS = "O";
    private static final String USERS_OBSERVEE_ALIAS = "N";

    public AdminObserverSelectQuery(DbObjectMap map, String tableName) {
        super(map, tableName);
    }

    @Override
    protected String getSelectClause(String tableName) {
        if (tableName != ObserverAssociationDbMap.TABLE_NAME) {
            throw new ObserverUserException(AdminObserverSelectQuery.class + " requires table '" + ObserverAssociationDbMap.TABLE_NAME + "'; instead was passed " + tableName);
        }
        String sql = "SELECT " + ObserverAssociationDbMap.TABLE_NAME + ".*, " + USERS_OBSERVER_ALIAS + ".batch_uid as " + ObserverAssociationDbMap.OBSERVER_BATCH_UID_COL + ", " + USERS_OBSERVEE_ALIAS + ".batch_uid as " + ObserverAssociationDbMap.OBSERVEE_BATCH_UID_COL + "," + "data_source.batch_uid as data_src_batch_uid " + " FROM " + ObserverAssociationDbMap.TABLE_NAME + ", users O, users N, data_source ";
        return sql;
    }

    @Override
    protected List<String> getCustomParameter(String colName) {
        ArrayList<String> customSql = new ArrayList<String>();
        String customParam = null;
        if (colName.equals(ObserverAssociationDbMap.OBSERVER_BATCH_UID_COL)) {
            customParam = ObserverAssociationDbMap.TABLE_NAME + ".observer_pk1 = " + USERS_OBSERVER_ALIAS + ".pk1 " + " AND " + USERS_OBSERVER_ALIAS + ".batch_uid ";
        } else if (colName.equals(ObserverAssociationDbMap.OBSERVEE_BATCH_UID_COL)) {
            customParam = ObserverAssociationDbMap.TABLE_NAME + ".users_pk1 = " + USERS_OBSERVEE_ALIAS + ".pk1 " + " AND " + USERS_OBSERVEE_ALIAS + ".batch_uid ";
        } else {
            return super.getCustomParameter(colName);
        }
        customSql.add(customParam);
        customSql.add("");
        return customSql;
    }
}

