/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.user.ObserverAssociationPersister;
import blackboard.admin.persist.user.impl.ObserverAssociationDbLoader;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationDbMap;
import blackboard.admin.persist.user.impl.mapping.ObserverAssociationDeleteDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class ObserverAssociationDbPersister
extends SnapshotDbPersister
implements ObserverAssociationPersister {
    String[] CONSTRAINTS = new String[]{"OBSERVER_USER_PK", "OBSERVER_USER_FK1", "OBSERVER_USER_FK2", "OBSERVER_USER_FK3"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, ObserverAssociationDbMap.TABLE_ALIAS);
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, ObserverAssociationDbMap.TABLE_ALIAS, sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, ObserverAssociationDbMap.TABLE_ALIAS);
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid((ObserverAssociation)obj);
        super.save(ObserverAssociationDbMap.MAP, obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(ObserverAssociationDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(ObserverAssociationDeleteDbMap.MAP, objList);
    }

    public void save(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void save(ObserverAssociation objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(ObserverAssociationDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(ObserverAssociationDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void remove(ObserverAssociation objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(ObserverAssociationDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    private void resolveBatchUid(ObserverAssociation objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("ObserverBatchUid").getIsDirty() && objInput.getBbAttributes().getBbAttribute("UserBatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        ObserverAssociationDbLoader loader = (ObserverAssociationDbLoader)this._pm.getLoader("ObserverAssociationLoader");
        ObserverAssociation obj = new ObserverAssociation();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        ObserverAssociation oa = (ObserverAssociation)list.get(0);
        objInput.setObserverBatchUid(oa.getObserverBatchUid());
        objInput.setUsersBatchUid(oa.getUsersBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (ObserverAssociation obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

