/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.persist.user.ObserverAssociationPersister;
import blackboard.admin.persist.user.impl.soap.observer.ClientUtility;
import blackboard.admin.snapshot.persist.Results;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.platform.soap.ServerResponse;
import blackboard.util.ObjectSerializer;

public class ObserverAssociationRemotePersister
extends AdminPersister
implements ObserverAssociationPersister {
    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid);
        ServerResponse response = this.executeSoapCall(req);
        return (String)response.getResults();
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.createSession(dataSourceBatchUid, sessionId);
        this.executeSoapCall(req);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        ClientUtility req = new ClientUtility();
        req.closeSession(strSessionId);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        try {
            this.save((ObserverAssociation)obj, strSessionId);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.save(objList, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        return this.resolveInternalId(objList, response, "observerassociation.id.list");
    }

    public Results remove(BbList objList) throws PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove(objList);
        ServerResponse response = this.executeSoapCall(req);
        return (Results)ObjectSerializer.deSerializeObject((String)((String)response.getResults()));
    }

    public void save(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save((BbObject)objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void save(ObserverAssociation objToSave, String strSessionId) throws PersistenceException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.save((BbObject)objToSave, strSessionId);
        ServerResponse response = this.executeSoapCall(req);
        BbList bList = new BbList();
        bList.add((Object)objToSave);
        this.resolveInternalId(bList, response, "observerassociation.id.list");
    }

    public void insert(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.insert((BbObject)objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void update(ObserverAssociation objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        objToSave.validate();
        ClientUtility req = new ClientUtility();
        req.update((BbObject)objToSave);
        ServerResponse response = null;
        try {
            response = this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForConstraintViolationException(pe);
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
        this.resolveInternalId(objToSave, response);
    }

    public void remove(ObserverAssociation objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        ClientUtility req = new ClientUtility();
        req.remove((BbObject)objToRemove);
        try {
            this.executeSoapCall(req);
        }
        catch (PersistenceException pe) {
            this.checkForKeyNotFoundException(pe);
            throw pe;
        }
    }
}

