/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.ObserverAssociationXmlDef;
import blackboard.admin.persist.impl.AdminPersister;
import blackboard.admin.persist.user.ObserverAssociationXmlPersister;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbList;
import blackboard.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ObserverAssociationXmlPersisterImpl
extends AdminPersister
implements ObserverAssociationXmlDef,
ObserverAssociationXmlPersister {
    public Element persist(ObserverAssociation obj, Document doc) {
        Element rootElement = doc.createElement("observer_membership");
        this.persistMembershipSourceIdNode(obj, rootElement, doc);
        rootElement.appendChild(this.persistMember(obj, doc));
        return rootElement;
    }

    protected Element persistMember(ObserverAssociation obj, Document doc) {
        Element rootElement = doc.createElement("observer_user");
        this.persistMemberSourceIdNode(obj, rootElement, doc);
        this.persistExtensionNode(obj, rootElement, doc);
        return rootElement;
    }

    public Element persist(BbList objList, Document doc) {
        boolean bToggle = false;
        Element rootElement = doc.createElement("observer_membership");
        for (ObserverAssociation tmp : objList) {
            if (!bToggle) {
                this.persistMembershipSourceIdNode(tmp, rootElement, doc);
                bToggle = false;
            }
            rootElement.appendChild(this.persistMember(tmp, doc));
        }
        return rootElement;
    }

    protected void persistMembershipSourceIdNode(ObserverAssociation obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getBbAttributes().getSafeString("ObserverBatchUid"));
        rootElement.appendChild(childElement);
    }

    protected void persistMemberSourceIdNode(ObserverAssociation obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("sourcedid");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"source", (String)"Bb Platform");
        XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"id", (String)obj.getBbAttributes().getSafeString("UserBatchUid"));
        rootElement.appendChild(childElement);
    }

    protected void persistExtensionNode(ObserverAssociation obj, Element rootElement, Document doc) {
        Element childElement = null;
        childElement = doc.createElement("extension");
        if (obj.getBbAttributes().getBbAttribute("RowStatus").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_row_status", (String)String.valueOf(ConversionUtility.rowStatusToInt((IAdminObject.RowStatus)obj.getBbAttributes().getBbEnum("RowStatus"))));
        }
        if (obj.getBbAttributes().getBbAttribute("DataSourceBatchUid").getValue() != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_datasource_key", (String)obj.getBbAttributes().getSafeString("DataSourceBatchUid"));
        }
        if (obj.getBbAttributes().getId("DataSourceId").isSet()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_data_source_id", (String)obj.getBbAttributes().getId("DataSourceId").toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("id").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_internal_id", (String)obj.getId().toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("UsersId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_observer_id", (String)obj.getBbAttributes().getSafeId("UsersId").toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("ObserverId").getIsDirty()) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_observer_id", (String)obj.getBbAttributes().getId("ObserverId").toExternalString());
        }
        if (obj.getBbAttributes().getBbAttribute("embed") != null) {
            XmlUtil.buildChildElement((Document)doc, (Element)childElement, (String)"x_bb_embedded_source", (String)obj.getBbAttributes().getSafeString("embed"));
        }
        rootElement.appendChild(childElement);
    }
}

