/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.persist.user.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.impl.AdminInsertProcedureQuery;
import blackboard.admin.persist.impl.AdminRemoveProcedureQuery;
import blackboard.admin.persist.impl.AdminSaveProcedureQuery;
import blackboard.admin.persist.impl.AdminUpdateProcedureQuery;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.persist.user.impl.PersonDbLoader;
import blackboard.admin.persist.user.impl.mapping.PersonDeleteDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonInsertDbMap;
import blackboard.admin.persist.user.impl.mapping.PersonPersisterDbMap;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.SnapshotDbPersister;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Query;

public class PersonDbPersister
extends SnapshotDbPersister
implements PersonPersister {
    String[] CONSTRAINTS = new String[]{"USERS_PK", "USERS_AK1", "USERS_AK2"};

    public String createSession(String dataSourceBatchUid) throws PersistenceException {
        return super._createSession(dataSourceBatchUid, "user");
    }

    public void createSession(String dataSourceBatchUid, String sessionId) throws PersistenceException {
        super._createSession(dataSourceBatchUid, "user", sessionId);
    }

    public void closeSession(String strSessionId) throws PersistenceException, KeyNotFoundException {
        super.closeSession(strSessionId, "user");
    }

    public void save(IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        this.save((Person)obj, strSessionId);
    }

    public Results save(BbList objList, String strSessionId) throws PersistenceException {
        this.resolveBatchUid(objList);
        return super.save(PersonPersisterDbMap.MAP, objList, strSessionId);
    }

    public Results remove(BbList objList) throws PersistenceException {
        return super.remove(PersonDeleteDbMap.MAP, objList);
    }

    public void save(Person objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminSaveProcedureQuery query = new AdminSaveProcedureQuery(PersonPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
    }

    public void save(Person objToSave, String strSessionId) throws PersistenceException, ValidationException {
        this.resolveBatchUid(objToSave);
        super.save(PersonPersisterDbMap.MAP, objToSave, strSessionId);
    }

    public void insert(Person objToSave) throws PersistenceException, ConstraintViolationException, ValidationException {
        objToSave.validate();
        AdminInsertProcedureQuery query = new AdminInsertProcedureQuery(PersonInsertDbMap.MAP, (BbObject)objToSave);
        try {
            super.runQuery((Query)query, null);
        }
        catch (PersistenceException exc) {
            super._checkForConstraintViolation(exc, this.CONSTRAINTS);
        }
    }

    public void update(Person objToSave) throws PersistenceException, ConstraintViolationException, KeyNotFoundException, ValidationException {
        this.resolveBatchUid(objToSave);
        objToSave.validate();
        AdminUpdateProcedureQuery query = new AdminUpdateProcedureQuery(PersonPersisterDbMap.MAP, (BbObject)objToSave);
        super.runQuery((Query)query, null);
        this.resolveReplacementBatchUid(objToSave);
    }

    private void resolveReplacementBatchUid(Person objToModify) {
        if (objToModify.getBbAttributes().getBbAttribute("ReplacementBatchUid").getIsDirty()) {
            objToModify.setBatchUid(objToModify.getReplacementBatchUid());
        }
    }

    public void remove(Person objToRemove) throws ValidationException, KeyNotFoundException, PersistenceException {
        AdminRemoveProcedureQuery query = new AdminRemoveProcedureQuery(PersonDeleteDbMap.MAP, (BbObject)objToRemove);
        super.runQuery((Query)query, null);
    }

    public void changeKey(Person objToSave, String newKey) throws PersistenceException, ValidationException, ConstraintViolationException, KeyNotFoundException {
        objToSave.setReplacementBatchUid(newKey);
        this.update(objToSave);
    }

    private void resolveBatchUid(Person objInput) throws PersistenceException {
        if (objInput.getBbAttributes().getBbAttribute("BatchUid").getIsDirty() || !this._pm.isValidId(objInput.getId())) {
            return;
        }
        PersonDbLoader loader = (PersonDbLoader)this._pm.getLoader("PersonLoader");
        Person obj = new Person();
        obj.setId(objInput.getId());
        BbList list = loader.load(obj);
        if (list.isEmpty()) {
            throw new KeyNotFoundException("");
        }
        Person person = (Person)list.get(0);
        objInput.setBatchUid(person.getBatchUid());
    }

    private void resolveBatchUid(BbList list) throws PersistenceException {
        for (Person obj : list) {
            this.resolveBatchUid(obj);
        }
    }
}

