/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.authority;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.CourseCategory;
import blackboard.admin.data.category.CourseCategoryMembership;
import blackboard.admin.data.category.OrganizationCategory;
import blackboard.admin.data.category.OrganizationCategoryMembership;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.AdminCourseCourse;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Enrollment;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.course.OrganizationMembership;
import blackboard.admin.data.course.StaffAssignment;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.Person;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.persist.course.CourseSiteLoader;
import blackboard.admin.persist.course.CourseSitePersister;
import blackboard.admin.persist.course.OrganizationPersister;
import blackboard.admin.persist.course.impl.AdminCourseCourseDbPersister;
import blackboard.admin.persist.course.impl.CourseSiteRemotePersister;
import blackboard.admin.persist.course.impl.EnrollmentDbPersister;
import blackboard.admin.persist.course.impl.OrganizationRemotePersister;
import blackboard.admin.persist.course.impl.StaffAssignmentDbPersister;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.integration.impl.CourseCourseLmsIntegrationPersister;
import blackboard.admin.persist.integration.impl.CourseLmsIntegrationPersister;
import blackboard.admin.persist.integration.impl.MembershipLmsIntegrationPersister;
import blackboard.admin.persist.integration.impl.PersonLmsIntegrationPersister;
import blackboard.admin.persist.user.PersonPersister;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.config.MsgConstants;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbEnum;
import blackboard.base.BbList;
import blackboard.base.InitializationException;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.platform.StatusCode;
import blackboard.platform.integration.LmsIntegration;
import blackboard.platform.log.LogService;
import blackboard.util.ThreadContextManager;
import blackboard.util.UuidFactory;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class Authority {
    public static final String DEFAULT_ENCODING = "US-ASCII";
    private static ThreadContextManager _threadContext = new ThreadContextManager(true);
    private Writer _logStream;
    protected IParser _parser;
    protected long _lCount;
    protected long _lSuccessCount;
    private long _lMaxErrorCount;
    protected long _lErrorCount;
    protected long _lWarningCount;
    protected String _strSessionId;
    protected long _lStart;
    private String _stdOutMessage = "";
    private DataSource _dataSrc;
    private DataSource _membershipDataSrc;
    private LmsIntegration _integration;
    protected SnapshotPersister _activePersister;
    private ConfigurationManager _cfgMgr;
    private StatusCode _sCode;
    protected BbList _list;
    protected Reader _in;
    private Operation _operation;
    private BitSet _bSet;
    private static final int PERSON = 0;
    private static final int COURSE = 1;
    private static final int STAFF = 2;
    private static final int ENROLLMENT = 3;
    private static final int ORG_MEM = 4;
    private static final int CRS_CATEGORY = 5;
    private static final int ORG_CATEGORY = 6;
    private static final int CRS_CAT_MEM = 7;
    private static final int ORG_CAT_MEM = 8;
    private static final int PORTAL_ROLE_MEM = 9;
    private static final int OBSERVER_ASSOCIATION = 10;
    private static final int COURSE_COURSE = 11;
    private static final String BB_DEFAULT_DATASOURCE = "SYSTEM";
    private LogService _logService;

    protected Authority(Properties settings, SnapshotPersister persist, IParser parser, Reader in, Writer errorLog, Operation operation) throws InitializationException {
        settings.putAll((Map<?, ?>)System.getProperties());
        this._bSet = new BitSet(10);
        this._sCode = StatusCode.INITIALIZING;
        this._logStream = errorLog;
        this._in = in;
        if (settings == null) {
            settings = new Properties();
        }
        this._cfgMgr = ConfigurationManager.getInstance(settings);
        this._lStart = System.currentTimeMillis();
        this._logService = (LogService)BbServiceManager.safeLookupService(LogService.class);
        this._lMaxErrorCount = this._cfgMgr.getNumericSetting("max.error.count");
        this._activePersister = persist;
        this._parser = parser;
        DataSourceLoader dLoader = null;
        try {
            String dKey = this._cfgMgr.getSetting("data.source.key");
            dLoader = (DataSourceLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("DataSourceLoader");
            if (dKey != null && dKey.length() > 0) {
                this._dataSrc = dLoader.loadByBatchUid(dKey);
            }
            if ((dKey = this._cfgMgr.getSetting("membership.datasource.key")) != null && dKey.length() > 0) {
                this._membershipDataSrc = dLoader.loadByBatchUid(dKey);
            }
        }
        catch (Exception exc) {
            if (operation != Operation.CLONE) {
                this._sCode = StatusCode.ABORTING;
                throw new InitializationException(this._cfgMgr.getLocaleExceptionMessage("controller.init.failure"), (Throwable)exc);
            }
            try {
                this._dataSrc = dLoader.loadByBatchUid(BB_DEFAULT_DATASOURCE);
            }
            catch (Exception nest) {
                this._sCode = StatusCode.ABORTING;
                throw new InitializationException(this._cfgMgr.getLocaleExceptionMessage("controller.init.failure"), (Throwable)nest);
            }
        }
        this._list = new BbList();
        this._operation = operation;
        _threadContext.attachThreadContext((Object)settings);
        this._strSessionId = UuidFactory.createUuid();
    }

    public static Properties getSettings() {
        Properties props = (Properties)_threadContext.getThreadContext();
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    protected Authority(Properties settings, SnapshotPersister persist, IParser parser, Reader in, Operation operation) {
        if (settings == null) {
            settings = new Properties();
        }
        settings.putAll((Map<?, ?>)System.getProperties());
        this._bSet = new BitSet(5);
        this._sCode = StatusCode.INITIALIZING;
        this._logStream = null;
        this._in = in;
        this._cfgMgr = ConfigurationManager.getInstance(settings);
        this._lStart = System.currentTimeMillis();
        this._logService = (LogService)BbServiceManager.safeLookupService(LogService.class);
        this._lMaxErrorCount = this._cfgMgr.getNumericSetting("max.error.count");
        this._activePersister = persist;
        this._parser = parser;
        this._list = new BbList();
        this._operation = operation;
        this._strSessionId = UuidFactory.createUuid();
    }

    public ConfigurationManager getConfigurationManager() {
        return this._cfgMgr;
    }

    public Operation getOperation() {
        return this._operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws SnapshotException, PersistenceException {
        this._sCode = StatusCode.OPERATING;
        try {
            if (this._activePersister != null && this.getOperation() == Operation.SNAPSHOT) {
                this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("snapshot.session.initialization.start"));
                this._activePersister.createSession(this._dataSrc.getBatchUid(), this._strSessionId);
                this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("snapshot.session.initialization.end"));
            }
            this._parser.init(this, this._in);
            this._parser.execute();
        }
        finally {
            this.releaseResources();
        }
        this._sCode = StatusCode.EXITED;
    }

    public void setStatus(StatusCode sCode) {
        this._sCode = sCode;
    }

    public StatusCode getStatus() {
        return this._sCode;
    }

    public void incrementSuccessCount(int val) {
        this._lSuccessCount += (long)val;
    }

    public void writeToErrorStream(String text) {
        try {
            this._logStream.write(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stdOutWriteMessage(String msg) {
        this.flushMessageBuffer(msg.length() < this._stdOutMessage.length());
        this._stdOutMessage = msg;
        System.out.print(this._stdOutMessage);
    }

    public void stdOutLogCount(boolean bIncrementCount) {
        String val;
        if (!bIncrementCount) {
            ++this._lCount;
        }
        if (!((val = String.valueOf(this._lCount)).equals("1") || val.endsWith("0") || bIncrementCount)) {
            return;
        }
        this.stdOutWriteMessage(val + " " + this._cfgMgr.getLocaleExceptionMessage("status.entity.processed"));
    }

    public void logWarning(String msg) {
        ++this._lWarningCount;
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.WARNING.getLevelAsInt()) {
            return;
        }
        if (this._cfgMgr.getSetting("log.stdout").equalsIgnoreCase("y")) {
            this.stdOutLogWarning(msg, null);
        }
        this._logService.logWarning(this._cfgMgr.getLocaleExceptionMessage("warning.log.header") + ": " + msg);
    }

    public void logWarning(String msg, Exception exc) {
        ++this._lWarningCount;
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.WARNING.getLevelAsInt()) {
            return;
        }
        if (this._cfgMgr.getSetting("log.stdout").equalsIgnoreCase("y")) {
            this.stdOutLogWarning(msg, exc);
        }
        this._logService.logWarning(this._cfgMgr.getLocaleExceptionMessage("warning.log.header"), (Throwable)exc);
    }

    public void logError(BbObject obj, String msg, Exception e) throws SnapshotException {
        this.logError(msg, e);
    }

    public void logError(String msg, Exception e) throws SnapshotException {
        this.incrementErrorCount(1);
        StringBuffer sb = new StringBuffer(msg);
        sb.append(this._cfgMgr.getSetting("error.delimeter"));
        if (e != null) {
            sb.append(e.getMessage());
        }
        try {
            sb.append(MsgConstants.MSG_CRLF);
            this.writeToErrorStream(sb.toString());
        }
        catch (Exception exc) {
            // empty catch block
        }
        if (this._logService.getVerbosityLevel().getLevelAsInt() < LogService.Verbosity.ERROR.getLevelAsInt()) {
            return;
        }
        if (this._cfgMgr.getSetting("log.stdout").equalsIgnoreCase("y")) {
            this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("entity.processing.failure") + ": " + msg + MsgConstants.MSG_CRLF);
        }
        this._logService.logError(msg, (Throwable)e);
    }

    public String getSessionId() {
        return this._strSessionId;
    }

    public DataSource getDataSource() {
        return this._dataSrc;
    }

    public void setDataSource(DataSource dataSrc) {
        this._dataSrc = dataSrc;
    }

    public LmsIntegration getIntegration() {
        return this._integration;
    }

    public void setIntegration(LmsIntegration integration) {
        this._integration = integration;
    }

    public void releaseResources() {
        if (this.getOperation() != Operation.SNAPSHOT) {
            return;
        }
        this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("snapshot.session.finalization.start"));
        if (this._activePersister != null) {
            this.closeSession(this._activePersister);
        } else {
            for (int pos = 0; pos < this._bSet.length(); ++pos) {
                if (!this._bSet.get(pos)) continue;
                this.closeSession(pos);
            }
        }
        this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("snapshot.session.finalization.end"));
    }

    private void closeSession(int pos) {
        try {
            this.closeSession(this.getPersister(pos));
        }
        catch (PersistenceException pe) {
            Object[] args = new Object[]{this.getSessionId()};
            this.logWarning(MessageFormat.format(this.getConfigurationManager().getLocaleExceptionMessage("snapshot.persister.stop"), args), (Exception)((Object)pe));
        }
    }

    private void closeSession(SnapshotPersister persister) {
        try {
            persister.closeSession(this.getSessionId());
        }
        catch (PersistenceException pe) {
            Object[] args = new Object[]{this.getSessionId()};
            this.logWarning(MessageFormat.format(this.getConfigurationManager().getLocaleExceptionMessage("snapshot.persister.stop"), args), (Exception)((Object)pe));
        }
    }

    private Results delegatePersistence() throws PersistenceException, ConnectionNotAvailableException {
        SnapshotPersister myPersister = this._activePersister;
        if (myPersister == null) {
            myPersister = this.getActivePersister();
        }
        Results myResults = null;
        if (this._operation == Operation.SNAPSHOT || this._operation == Operation.MANUAL || this._operation == Operation.CLONE) {
            myResults = myPersister instanceof CourseSitePersister ? Authority.delegateAdminCoursePersistence(this._list, (CourseSitePersister)myPersister, this.getSessionId(), this._membershipDataSrc) : (myPersister instanceof OrganizationPersister ? Authority.delegateOrganizationPersistence(this._list, (OrganizationPersister)myPersister, this.getSessionId(), this._membershipDataSrc) : myPersister.save(this._list, this.getSessionId()));
        } else if (this._operation == Operation.REMOVE) {
            myResults = myPersister.remove(this._list);
        }
        return myResults;
    }

    public static Results delegateAdminCoursePersistence(BbList list, CourseSitePersister persist, String session, DataSource membershipDataSrc) throws PersistenceException {
        BbList cloneList = Authority.cloneCheck(list);
        Results results = persist.save(list, session);
        if (!cloneList.isEmpty() && !(persist instanceof CourseSiteRemotePersister)) {
            Results cloneResults = Authority.doClone(cloneList, membershipDataSrc);
            ConversionUtility.appendResults(cloneResults, results);
        }
        return results;
    }

    public static Results delegateOrganizationPersistence(BbList list, OrganizationPersister persist, String session, DataSource membershipDataSrc) throws PersistenceException {
        BbList cloneList = Authority.cloneCheck(list);
        Results results = persist.save(list, session);
        if (!cloneList.isEmpty() && !(persist instanceof OrganizationRemotePersister)) {
            Results cloneResults = Authority.doClone(cloneList, membershipDataSrc);
            ConversionUtility.appendResults(cloneResults, results);
        }
        return results;
    }

    private static BbList cloneCheck(BbList list) throws PersistenceException {
        Iterator iter = list.iterator();
        BbList aList = new BbList();
        while (iter.hasNext()) {
            AdminCourse course = (AdminCourse)iter.next();
            if (!Authority._cloneCheck(course)) continue;
            aList.add((Object)course);
        }
        return aList;
    }

    private static Results doClone(BbList list, DataSource membershipDataSrc) throws PersistenceException {
        CloneConfig cfg = ConfigurationManager.getCloneConfiguration(Authority.getSettings());
        String dKey = Authority.getSettings().getProperty("membership.datasource.key", "");
        if (membershipDataSrc == null && dKey.length() > 0) {
            DataSourceLoader l = (DataSourceLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("DataSourceLoader");
            membershipDataSrc = l.loadByBatchUid(dKey);
        }
        if (membershipDataSrc != null) {
            cfg.setMembershipDataSourceId(membershipDataSrc.getId());
        }
        Iterator iter = list.iterator();
        RemoteResults results = new RemoteResults();
        while (iter.hasNext()) {
            AdminCourse course = (AdminCourse)iter.next();
            try {
                Authority._doClone(course, cfg);
            }
            catch (PersistenceException pe) {
                results.addError((BbObject)course, pe);
            }
        }
        return results;
    }

    private static void _doClone(AdminCourse crs, CloneConfig cfg) throws PersistenceException {
        CourseSitePersister cPersister = (CourseSitePersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseSitePersister");
        try {
            cPersister.clone(crs.getTemplateBatchUid(), crs.getBatchUid(), cfg);
        }
        catch (ValidationException ve) {
            throw new PersistenceException((Throwable)ve);
        }
        catch (ConstraintViolationException cve) {
            throw new PersistenceException((Throwable)cve);
        }
    }

    private static boolean _cloneCheck(AdminCourse crs) throws PersistenceException {
        boolean exists;
        block3: {
            if (crs.getTemplateBatchUid() == null || crs.getTemplateBatchUid().length() == 0) {
                return false;
            }
            CourseSiteLoader loader = (CourseSiteLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("CourseSiteLoader");
            exists = false;
            try {
                loader.load(crs.getBatchUid());
                exists = true;
            }
            catch (PersistenceException pe) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                pe.printStackTrace(pw);
                String msg = sw.getBuffer().toString();
                if (msg.indexOf("KeyNotFoundException") != -1) break block3;
                throw pe;
            }
        }
        return !exists || crs.getBbAttributes().getBbAttribute("TemplateBatchUid").getIsDirty();
    }

    private SnapshotPersister getActivePersister() throws PersistenceException {
        SnapshotPersister persister = null;
        Object obj = this._list.get(0);
        int entity = 0;
        if (obj instanceof Person) {
            entity = 0;
        } else if (obj instanceof CourseSite) {
            entity = 1;
        } else if (obj instanceof Organization) {
            entity = 1;
        } else if (obj instanceof StaffAssignment) {
            entity = 2;
        } else if (obj instanceof Enrollment) {
            entity = 3;
        } else if (obj instanceof OrganizationMembership) {
            entity = 4;
        } else if (obj instanceof AdminCourseCourse) {
            entity = 11;
        } else if (obj instanceof CourseCategory) {
            entity = 5;
        } else if (obj instanceof OrganizationCategory) {
            entity = 6;
        } else if (obj instanceof CourseCategoryMembership) {
            entity = 7;
        } else if (obj instanceof OrganizationCategoryMembership) {
            entity = 8;
        } else if (obj instanceof PortalRoleMembership) {
            entity = 9;
        } else if (obj instanceof ObserverAssociation) {
            entity = 10;
        }
        persister = this.getPersister(entity);
        if (!this._bSet.get(entity)) {
            this.initPersistence(persister);
            this._bSet.set(entity);
        }
        return persister;
    }

    private SnapshotPersister getPersister(int entityBit) throws PersistenceException {
        SnapshotPersister persister = null;
        switch (entityBit) {
            case 0: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("PersonPersister");
                break;
            }
            case 1: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseSitePersister");
                break;
            }
            case 2: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("StaffAssignmentPersister");
                break;
            }
            case 3: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("EnrollmentPersister");
                break;
            }
            case 4: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("OrganizationMembershipPersister");
                break;
            }
            case 11: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("AdminCourseCoursePersister");
                break;
            }
            case 5: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseCategoryPersister");
                break;
            }
            case 6: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("OrganizationCategoryPersister");
                break;
            }
            case 7: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("CourseCategoryMembershipPersister");
                break;
            }
            case 8: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("OrganizationCategoryMembershipPersister");
                break;
            }
            case 9: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("PortalRoleMembershipPersister");
                break;
            }
            case 10: {
                persister = (SnapshotPersister)BbServiceManager.getPersistenceService().getDbPersistenceManager().getPersister("ObserverAssociationPersister");
            }
        }
        return this.decoratePersister(persister);
    }

    private SnapshotPersister decoratePersister(SnapshotPersister persister) {
        if (this._integration != null) {
            if (persister instanceof PersonPersister) {
                return new PersonLmsIntegrationPersister(this._integration, (PersonPersister)persister, this);
            }
            if (persister instanceof CourseSitePersister) {
                return new CourseLmsIntegrationPersister(this._integration, (CourseSitePersister)persister, this);
            }
            if (persister instanceof EnrollmentDbPersister || persister instanceof StaffAssignmentDbPersister) {
                return new MembershipLmsIntegrationPersister(this._integration, persister, this);
            }
            if (persister instanceof AdminCourseCourseDbPersister) {
                return new CourseCourseLmsIntegrationPersister(this._integration, persister, this);
            }
        }
        return persister;
    }

    private void initPersistence(SnapshotPersister persister) throws PersistenceException {
        if (this.getOperation() == Operation.SNAPSHOT) {
            persister.createSession(this._dataSrc.getBatchUid(), this._strSessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SnapshotException {
        Results myResults = null;
        if (this._list.size() == 0) {
            return;
        }
        try {
            myResults = this.delegatePersistence();
            this.logErrorsFromCommit(myResults);
        }
        catch (PersistenceException pe) {
            for (BbObject obj : this._list) {
                this.logError(obj, obj.getBbAttributes().getSafeString("embed"), (Exception)((Object)pe));
            }
        }
        catch (ConnectionNotAvailableException dna) {
            for (BbObject obj : this._list) {
                this.logError(obj.getBbAttributes().getSafeString("embed"), (Exception)((Object)dna));
            }
        }
        finally {
            this._list.clear();
        }
    }

    private void logErrorsFromCommit(Results results) throws SnapshotException {
        this.incrementSuccessCount(this._list.size() - results.getErrorCount());
        if (results.getErrorCount() == 0) {
            return;
        }
        ArrayList list = results.getList();
        for (Results.Error err : list) {
            String embeddedText = err.getEmbeddedText();
            this.logError(err.getObject(), embeddedText, err.getException());
        }
    }

    public void queue(IAdminObject eObject) {
        this._list.add((Object)eObject);
    }

    protected boolean maxErrorExceeded() {
        boolean bVal = false;
        if (this._lMaxErrorCount >= 0L && this._lErrorCount > this._lMaxErrorCount) {
            bVal = true;
        }
        return bVal;
    }

    private void incrementErrorCount(int val) throws SnapshotException {
        this._lErrorCount += (long)val;
        if (this.maxErrorExceeded()) {
            throw new SnapshotException(this.getConfigurationManager().getLocaleExceptionMessage("parser.maxerr.exceeded"));
        }
    }

    private void stdOutLogWarning(String msg, Exception ve) {
        if (ve != null) {
            msg = msg + " : " + ve.getMessage();
        }
        this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("warning.report.msg") + " { " + msg + " }" + MsgConstants.MSG_CRLF);
    }

    private void flushMessageBuffer(boolean bEmptyFirst) {
        if (this._stdOutMessage.endsWith(MsgConstants.MSG_CRLF)) {
            return;
        }
        StringBuffer sb_back = new StringBuffer();
        StringBuffer sb_space = new StringBuffer();
        StringBuffer sb_clear = new StringBuffer();
        for (long cnt = 0L; cnt < (long)this._stdOutMessage.length(); ++cnt) {
            sb_back.append("\b");
            if (!bEmptyFirst) continue;
            sb_space.append(" ");
        }
        sb_clear.append(sb_back.toString());
        if (bEmptyFirst) {
            sb_clear.append(sb_space.toString());
            sb_clear.append(sb_back.toString());
        }
        System.out.print(sb_clear.toString());
    }

    private String formatNumber(long val, int numPlaces) {
        String ret = String.valueOf(val);
        for (int cnt = ret.length(); cnt < numPlaces; ++cnt) {
            ret = "0" + ret;
        }
        return ret;
    }

    protected String getInterval(long lDifference) {
        MessageFormat mf = new MessageFormat("{0}:{1}:{2}.{3}");
        String sMilli = "";
        String sSec = "";
        String sMin = "";
        String sHours = "";
        long held = lDifference;
        long hours = held / 3600000L;
        if (hours > 0L) {
            held -= hours * 60L * 60L * 1000L;
        }
        sHours = this.formatNumber(hours, 2);
        long min = held / 60000L;
        if (min > 0L) {
            held -= min * 60L * 1000L;
        }
        sMin = this.formatNumber(min, 2);
        long sec = held / 1000L;
        if (sec > 0L) {
            held -= sec * 1000L;
        }
        sSec = this.formatNumber(sec, 2);
        long milli = held;
        sMilli = this.formatNumber(milli, 3);
        Object[] messageArgs = new Object[]{sHours, sMin, sSec, sMilli};
        return mf.format(messageArgs);
    }

    protected void writeStdOutReport(String msg) {
        this.stdOutWriteMessage(this._cfgMgr.getLocaleExceptionMessage("status.report.msg") + " " + msg + MsgConstants.MSG_CRLF);
        this._logService.logInfo(msg);
    }

    public static final class Operation
    extends BbEnum {
        public static final Operation SNAPSHOT = new Operation("SNAPSHOT");
        public static final Operation MANUAL = new Operation("MANUAL");
        public static final Operation REMOVE = new Operation("REMOVE");
        public static final Operation CLONE = new Operation("CLONE");
        static final long serialVersionUID = 1L;

        private Operation(String enumFieldName) {
            super(enumFieldName);
        }
    }
}

