/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.config;

import blackboard.admin.persist.category.OrganizationCategoryLoader;
import blackboard.admin.persist.category.impl.OrganizationCategoryRemoteLoader;
import blackboard.admin.persist.course.CloneConfig;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.platform.BbServiceManager;
import blackboard.platform.intl.BbResourceBundle;
import blackboard.xml.XmlUtil;
import java.util.Properties;

public class ConfigurationManager {
    Properties _settings = null;
    BbResourceBundle _resBundle = null;
    static final String RESOURCE_BUNDLE = "snapshot";

    public static ConfigurationManager getInstance(Properties props) {
        return new ConfigurationManager(props);
    }

    public CloneConfig getConfiguration() {
        return ConfigurationManager.getCloneConfiguration(this._settings);
    }

    public static CloneConfig getCloneConfiguration(Properties props) {
        CloneConfig cfg = new CloneConfig();
        if (ConversionUtility.getBoolean(props.getProperty("announcements.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.ANNOUNCEMENT);
        }
        if (ConversionUtility.getBoolean(props.getProperty("assessment.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.ASSESSMENT);
        }
        if (ConversionUtility.getBoolean(props.getProperty("assessment.cartridge.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.ASSESSEMENT_CARTRIDGE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("availability.rule.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.AVAILABILITY_RULE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("calendar.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.CALENDAR);
        }
        if (ConversionUtility.getBoolean(props.getProperty("categories.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.CATEGORY_MEMBERSHIP);
        }
        if (ConversionUtility.getBoolean(props.getProperty("chat.archive.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.CHAT_ARCHIVE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("chat.session.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.CHAT_SESSION);
        }
        if (ConversionUtility.getBoolean(props.getProperty("course.content.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.CONTENT);
        }
        if (ConversionUtility.getBoolean(props.getProperty("course.content.cartridge.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.COURSE_CARTRIDGE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("course.statistics.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.COURSE_STATISTICS);
        }
        if (ConversionUtility.getBoolean(props.getProperty("discussion.board.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.DISCUSSION_BOARD);
        }
        if (ConversionUtility.getBoolean(props.getProperty("discussion.board.archive.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.DISCUSSION_BOARD_ARCHIVE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("discussion.board.cartridge.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.DISCUSSION_CARTRIDGE);
        }
        if (ConversionUtility.getBoolean(props.getProperty("drop.box.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.DROP_BOX);
        }
        if (ConversionUtility.getBoolean(props.getProperty("glossary.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.GLOSSARY);
        }
        if (ConversionUtility.getBoolean(props.getProperty("gradebook.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.GRADEBOOK);
        }
        if (ConversionUtility.getBoolean(props.getProperty("grades.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.GRADES);
        }
        if (ConversionUtility.getBoolean(props.getProperty("groups.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.GROUP);
        }
        if (ConversionUtility.getBoolean(props.getProperty("membership.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.MEMBERSHIP);
        }
        if (ConversionUtility.getBoolean(props.getProperty("membership.exact.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.MEMBERSHIP_EXACT);
        }
        if (ConversionUtility.getBoolean(props.getProperty("course.settings.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.SETTING);
        }
        if (ConversionUtility.getBoolean(props.getProperty("staff.information.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.STAFF_INFORMATION);
        }
        if (ConversionUtility.getBoolean(props.getProperty("tasks.copy", "Y"))) {
            cfg.includeArea(CloneConfig.Area.TASK);
        }
        if (!ConversionUtility.getBoolean(props.getProperty("suppress.clone.events", "N"))) {
            cfg.setSuppressEvents(false);
        }
        if (ConversionUtility.getBoolean(props.getProperty("reconcile", "N"))) {
            cfg.setReconcileFlag(Boolean.TRUE);
        }
        cfg.setMaximumTransactionCount(XmlUtil.parseInteger((String)props.getProperty("snapshot.batch.size")));
        return cfg;
    }

    private ConfigurationManager(Properties props) {
        this._settings = props == null || props.isEmpty() ? new Properties() : (Properties)props.clone();
        this._resBundle = BbServiceManager.getBundleManager().getBundle(RESOURCE_BUNDLE);
    }

    public String getSetting(String key) {
        return this._settings.getProperty(key, "");
    }

    public int getNumericSetting(String key) {
        String tmp = this._settings.getProperty(key, "-1");
        return Integer.parseInt(tmp);
    }

    public void setSetting(String key, String value) {
        this._settings.setProperty(key, value);
    }

    public boolean isSOAPEnabled() {
        try {
            if (OrganizationCategoryLoader.Default.getInstance() instanceof OrganizationCategoryRemoteLoader) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getLocaleExceptionMessage(String arg) {
        return this._resBundle.getString(arg);
    }

    public static String getGlobalLocaleExceptionMessage(String arg) {
        BbResourceBundle bundle = BbServiceManager.getBundleManager().getBundle(RESOURCE_BUNDLE);
        return bundle.getString(arg);
    }

    public char getDelimeter() {
        return this._settings.getProperty("data.delimeter", " ").charAt(0);
    }

    public String getEscapeSequence() {
        return this._settings.getProperty("escape.character", "");
    }
}

