/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.SnapshotPersister;
import blackboard.admin.snapshot.persist.impl.SessionProcedureQuery;
import blackboard.admin.snapshot.persist.impl.SnapshotProcedureQuery;
import blackboard.admin.snapshot.persist.impl.SnapshotRemoveProcedureQuery;
import blackboard.base.AppVersion;
import blackboard.base.BbList;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.ConstraintViolationException;
import blackboard.persist.BbPersistenceManager;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.NewBaseDbPersister;
import blackboard.persist.impl.Query;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.platform.BbServiceManager;
import blackboard.platform.LicenseManager;
import blackboard.util.ExceptionUtil;
import blackboard.util.UuidFactory;

public abstract class SnapshotDbPersister
extends NewBaseDbPersister
implements SnapshotPersister {
    protected LicenseManager _lMgr;

    public void init(BbPersistenceManager pm, AppVersion appVersion) {
        super.init(pm, appVersion);
        this._lMgr = BbServiceManager.getLicenseManager();
        this.checkApiLicensing();
    }

    protected void checkApiLicensing() {
        this._lMgr.runtimeAssertIsLicensed("integration.apis");
    }

    protected String _createSession(String dataSourceBatchUid, String tableName) throws PersistenceException {
        String sessionId = UuidFactory.createUuid();
        this._createSession(dataSourceBatchUid, tableName, sessionId);
        return sessionId;
    }

    protected void _createSession(String dataSourceBatchUid, String tableName, String sessionId) throws PersistenceException {
        DataSourceLoader dLoader = (DataSourceLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("DataSourceLoader");
        DataSource dSource = dLoader.loadByBatchUid(dataSourceBatchUid);
        SessionProcedureQuery sQuery = new SessionProcedureQuery(tableName, dSource.getId(), sessionId);
        super.runQuery((Query)sQuery, null);
    }

    protected void closeSession(String strSessionId, String tableName) throws PersistenceException, KeyNotFoundException {
        SessionProcedureQuery sQuery = new SessionProcedureQuery(tableName, strSessionId);
        super.runQuery((Query)sQuery, null);
    }

    protected void save(DbObjectMap map, IAdminObject obj, String strSessionId) throws PersistenceException, KeyNotFoundException, ValidationException {
        obj.validate();
        SnapshotProcedureQuery sQuery = new SnapshotProcedureQuery(map, (BbObject)obj, strSessionId);
        super.runQuery((Query)sQuery, null);
    }

    protected Results save(DbObjectMap map, BbList objList, String strSessionId) throws PersistenceException {
        SnapshotProcedureQuery sQuery = new SnapshotProcedureQuery(map, null, strSessionId);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        try {
            return sQuery.executeBatchQuery(objList);
        }
        catch (ConnectionNotAvailableException cna) {
            throw new PersistenceException((Throwable)cna);
        }
    }

    protected Results remove(DbObjectMap map, BbList objList) throws PersistenceException {
        SnapshotRemoveProcedureQuery sQuery = new SnapshotRemoveProcedureQuery(map, null);
        sQuery.init(this._bbDatabase, this._pm.getContainer());
        try {
            return sQuery.executeBatchQuery(objList);
        }
        catch (ConnectionNotAvailableException cna) {
            throw new PersistenceException((Throwable)cna);
        }
    }

    protected void _checkForConstraintViolation(PersistenceException exc, String[] constraints) throws PersistenceException, ConstraintViolationException {
        if (ExceptionUtil.isSqlConstraintViolation((Throwable)exc, (String[])constraints)) {
            throw new ConstraintViolationException((Throwable)exc);
        }
        throw exc;
    }
}

