/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist.impl;

import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.base.BbList;
import blackboard.data.BbAttribute;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.db.DbUtil;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.persist.impl.mapping.IDbLobMapping;
import blackboard.platform.BbServiceManager;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SnapshotProcedureQuery
extends StoredProcedureQuery {
    private static String BATCH_UID = "BatchUid";
    private static String REPLACEMENT_BATCH_UID = "ReplacementBatchUid";
    private DbObjectMap _dbBbObjMap = null;
    private BbObject _bbObj = null;
    private final String SESSION = "p_session_id";
    private String _strSessionId;

    public SnapshotProcedureQuery(DbObjectMap map, BbObject obj, String sessionId) {
        super("process_" + map.getAliasTableName() + "_integration");
        this._strSessionId = sessionId;
        List list = map.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        String[] aColumns = null;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (use == DbMapping.Use.NONE) continue;
            aColumns = mapping2.getColumns();
            for (int j = 0; j < aColumns.length; ++j) {
                if (use == DbMapping.Use.INPUT) {
                    String mapName = aColumns[j];
                    if (mapName.equals("data_src_pk1")) {
                        mapName = "p_data_src_pk1";
                    }
                    if (mapName.startsWith("p_")) {
                        this.addInputParameter(mapName);
                        continue;
                    }
                    this.addInputParameter("p_" + mapName);
                    this.addInputParameter("f_" + mapName);
                    continue;
                }
                if (use == DbMapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    if (aColumns[j].startsWith("p_")) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    this.addOutputParameter("p_" + aColumns[j]);
                    continue;
                }
                throw new RuntimeException(BbServiceManager.getBundleManager().getBundle("snapshot").getString("db.mapping.invalid") + use.toString());
            }
        }
        this.addInputParameter("p_session_id");
        this._dbBbObjMap = map;
        this._bbObj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            BbDatabase bbDatabase = BbServiceManager.getJdbcService().getDefaultDatabase();
            if (bbDatabase != null) {
                this._bUseResultSet = new Boolean(bbDatabase.isSqlServer());
            } else {
                throw new RuntimeException(BbServiceManager.getBundleManager().getBundle("snapshot").getString("db.no.output.type"));
            }
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        BbAttributes attribs = this._bbObj.getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        int nStartPos = 0;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            boolean bClob = mapping2 instanceof IDbLobMapping;
            String mapName = mapping2.getColumns()[0];
            if (mapName.equals("data_src_pk1")) {
                mapName = "p_data_src_pk1";
            }
            nStartPos = this.getColumnPosition(mapName);
            if (use == DbMapping.Use.INPUT) {
                if (mapName.startsWith("p_")) {
                    mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, nStartPos, attribs.getBbAttribute(mapping2.getName()).getValue());
                    continue;
                }
                if (mapName.equals("row_status")) {
                    boolean bDirty = attribs.getBbAttribute(mapping2.getName()).getIsDirty();
                    if (bDirty) {
                        mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), attribs.getBbAttribute(mapping2.getName()).getValue());
                    } else {
                        stmt.setNull(this.getColumnPosition("p_" + mapName), 4);
                    }
                    DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping2.getName()).getIsDirty()));
                    continue;
                }
                if (bClob) {
                    DbUtil.setNString((PreparedStatement)stmt, (int)this.getColumnPosition("p_" + mapName), (String)attribs.getString(mapping2.getName()), (boolean)this._bbDatabase.isOracle());
                } else {
                    mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, this.getColumnPosition("p_" + mapName), attribs.getBbAttribute(mapping2.getName()).getValue());
                }
                DbUtil.setInteger((PreparedStatement)stmt, (int)this.getColumnPosition("f_" + mapName), (int)ConversionUtility.booleanToInt(attribs.getBbAttribute(mapping2.getName()).getIsDirty()));
                continue;
            }
            if (use != DbMapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping2.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping2.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
        nStartPos = this.getColumnPosition("p_session_id");
        DbUtil.setString((PreparedStatement)stmt, (int)nStartPos, (String)this._strSessionId);
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            String mapName = mapping2.getColumns()[0];
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            obj = mapping2.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            obj = mapping2.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public Results executeBatchQuery(BbList list) throws PersistenceException, ConnectionNotAvailableException {
        Connection con = null;
        try {
            con = (Connection)AccessController.doPrivileged(new DbConnectivityPrivilege(this.getBbDatabase()));
        }
        catch (PrivilegedActionException pae) {
            this.castException(pae);
        }
        RemoteResults myResults = new RemoteResults(list.size());
        try {
            con.setAutoCommit(false);
            this._stmt = this.prepareStatement(con);
            for (BbObject this._bbObj : list) {
                try {
                    this._bbObj.validate();
                    this.doExecute(con);
                    this.resolveReplacementBatchUid(this._bbObj);
                }
                catch (Exception exc) {
                    myResults.addError(this._bbObj, new PersistenceException((Throwable)exc));
                }
            }
            con.commit();
        }
        catch (SQLException sql) {
            throw new PersistenceException((Throwable)sql);
        }
        finally {
            this.close();
            this.getBbDatabase().getConnectionManager().releaseConnection(con);
            con = null;
        }
        return myResults;
    }

    private void resolveReplacementBatchUid(BbObject obj) {
        BbAttribute att = obj.getBbAttributes().getBbAttribute(REPLACEMENT_BATCH_UID);
        if (att == null) {
            return;
        }
        if (!att.getIsDirty()) {
            return;
        }
        obj.getBbAttributes().setString(BATCH_UID, (String)att.getValue());
    }

    private void castException(PrivilegedActionException pae) throws PersistenceException, ConnectionNotAvailableException {
        Exception pException = pae.getException();
        if (pException instanceof KeyNotFoundException) {
            throw (KeyNotFoundException)((Object)pException);
        }
        if (pException instanceof SQLException) {
            throw new PersistenceException((Throwable)pException);
        }
        if (pException instanceof ConnectionNotAvailableException) {
            throw (ConnectionNotAvailableException)((Object)pException);
        }
        throw new PersistenceException((Throwable)pae);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbConnectivityPrivilege
    implements PrivilegedExceptionAction<Object> {
        private BbDatabase _bbd;

        private DbConnectivityPrivilege(BbDatabase bbd) {
            this._bbd = bbd;
        }

        @Override
        public Object run() throws Exception {
            return this._bbd.getConnectionManager().getConnection();
        }
    }
}

