/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.persist.impl;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.persist.impl.RemoteResults;
import blackboard.base.BbList;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.db.BbDatabase;
import blackboard.db.ConnectionNotAvailableException;
import blackboard.persist.Id;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.Bb5Util;
import blackboard.persist.impl.StoredProcedureQuery;
import blackboard.persist.impl.mapping.DbMapping;
import blackboard.persist.impl.mapping.DbObjectMap;
import blackboard.platform.BbServiceManager;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SnapshotRemoveProcedureQuery
extends StoredProcedureQuery {
    private DbObjectMap _dbBbObjMap = null;
    private BbObject _bbObj = null;
    private final String DATA_SRC = "p_data_src_pk1";

    public SnapshotRemoveProcedureQuery(DbObjectMap map, BbObject obj) {
        super("delete_" + map.getAliasTableName() + "_snap_proc");
        List list = map.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        String[] aColumns = null;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            if (use == DbMapping.Use.NONE) continue;
            aColumns = mapping2.getColumns();
            for (int j = 0; j < aColumns.length; ++j) {
                if (use == DbMapping.Use.INPUT) {
                    this.addInputParameter(aColumns[j]);
                    continue;
                }
                if (use == DbMapping.Use.OUTPUT) {
                    if (this.getUseResultSet()) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    if (aColumns[j].startsWith("p_")) {
                        this.addOutputParameter(aColumns[j]);
                        continue;
                    }
                    this.addOutputParameter("p_" + aColumns[j]);
                    continue;
                }
                throw new RuntimeException(BbServiceManager.getBundleManager().getBundle("snapshot").getString("db.mapping.invalid") + use.toString());
            }
        }
        this.addInputParameter("p_data_src_pk1");
        this._dbBbObjMap = map;
        this._bbObj = obj;
    }

    public boolean getUseResultSet() {
        if (this._bUseResultSet == null) {
            BbDatabase bbDatabase = BbServiceManager.getJdbcService().getDefaultDatabase();
            if (bbDatabase != null) {
                this._bUseResultSet = new Boolean(bbDatabase.isSqlServer());
            } else {
                throw new RuntimeException(BbServiceManager.getBundleManager().getBundle("snapshot").getString("db.no.output"));
            }
        }
        return this._bUseResultSet;
    }

    protected void marshallParams(CallableStatement stmt) throws SQLException, SQLException, PersistenceException {
        BbAttributes attribs = this._bbObj.getBbAttributes();
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        DbMapping.Use use = null;
        int nStartPos = 0;
        for (DbMapping mapping2 : list) {
            use = mapping2.getInsertUse();
            String mapName = mapping2.getColumns()[0];
            nStartPos = this.getColumnPosition(mapName);
            if (use == DbMapping.Use.INPUT) {
                mapping2.marshall(this.getContainer(), (PreparedStatement)stmt, nStartPos, attribs.getBbAttribute(mapping2.getName()).getValue());
                continue;
            }
            if (use != DbMapping.Use.OUTPUT || this.getUseResultSet()) continue;
            if (mapName.startsWith("p_")) {
                mapping2.registerOutParameter(stmt, nStartPos);
                continue;
            }
            mapping2.registerOutParameter(stmt, this.getColumnPosition("p_" + mapName));
        }
        Bb5Util.setId((PreparedStatement)stmt, (int)this.getColumnPosition("p_data_src_pk1"), (Id)((IAdminObject)this._bbObj).getDataSourceId());
    }

    public void processResults(CallableStatement stmt) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            String mapName = mapping2.getColumns()[0];
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            if (!mapName.startsWith("p_")) {
                mapName = "p_" + mapName;
            }
            obj = mapping2.unmarshall(this.getContainer(), stmt, this.getColumnPosition(mapName));
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public void processResults(ResultSet rst) throws SQLException, PersistenceException {
        List list = this._dbBbObjMap.getMappingList();
        DbMapping mapping2 = null;
        Object obj = null;
        for (DbMapping mapping2 : list) {
            if (mapping2.getInsertUse() != DbMapping.Use.OUTPUT) continue;
            obj = mapping2.unmarshall(this.getContainer(), rst, null);
            this._dbBbObjMap.setTargetValue((Object)this._bbObj, mapping2.getName(), obj);
        }
    }

    public Results executeBatchQuery(BbList list) throws PersistenceException, ConnectionNotAvailableException {
        Connection con = this.getBbDatabase().getConnectionManager().getConnection();
        RemoteResults myResults = new RemoteResults(list.size());
        try {
            this._stmt = this.prepareStatement(con);
            for (BbObject this._bbObj : list) {
                try {
                    this.doExecute(con);
                }
                catch (Exception exc) {
                    myResults.addError(this._bbObj, new PersistenceException((Throwable)exc));
                }
            }
            con.commit();
        }
        catch (SQLException sql) {
            throw new PersistenceException((Throwable)sql);
        }
        finally {
            this.close();
            this.getBbDatabase().getConnectionManager().releaseConnection(con);
            con = null;
        }
        return myResults;
    }
}

