/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.config.MsgConstants;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbObject;
import blackboard.data.ValidationException;
import blackboard.platform.BbServiceManager;
import blackboard.platform.StatusCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class Parser
implements IParser {
    protected Authority _authority;
    protected Map<String, String> _fieldMapping = new HashMap<String, String>();
    protected LinkedList<String> _posMapping;
    protected LinkedList<String> _legacyPosMapping;
    protected BitSet _ovrMask;
    protected ConversionUtility _cvUtility;
    protected Reader _in;
    private final int HEADER = 0;
    private final int FOOTER = 1;
    private int _iBatchSize = 0;

    protected Parser() {
    }

    public void init(Authority authority, Reader in) {
        this._authority = authority;
        this._in = new BufferedReader(in);
        this._cvUtility = new ConversionUtility(this._authority.getConfigurationManager());
    }

    protected void checkApiLicensing() {
        if (this._authority.getOperation() != Authority.Operation.CLONE) {
            BbServiceManager.getLicenseManager().runtimeAssertIsLicensed("integration.apis");
        }
    }

    public void execute() throws SnapshotException {
        this.checkApiLicensing();
        LineNumberReader src = new LineNumberReader(this._in);
        String tmpLine = null;
        boolean bHeaderHasBeenRead = false;
        int maxBatchSize = this._authority.getConfigurationManager().getNumericSetting("snapshot.batch.size");
        int waitLength = this._authority.getConfigurationManager().getNumericSetting("wait.length");
        IAdminObject obj = null;
        try {
            this.parameterMappingInitialization();
            this.controlMaskInitialization();
        }
        catch (Exception e) {
            throw new SnapshotException(this._authority.getConfigurationManager().getLocaleExceptionMessage("parser.init.failure"), e);
        }
        try {
            while ((tmpLine = src.readLine()) != null && this._authority.getStatus() != StatusCode.ABORTING) {
                if (tmpLine.length() == 0) continue;
                int lReserved = this.isLineReserved(tmpLine);
                if (lReserved > 0) {
                    if (lReserved == 0) {
                        continue;
                    }
                    break;
                }
                try {
                    if (!bHeaderHasBeenRead) {
                        if (!this.validateHeaderForRequiredFields(tmpLine.toLowerCase())) {
                            throw new SnapshotException(this._authority.getConfigurationManager().getLocaleExceptionMessage("parser.header.required"));
                        }
                        this.reviewDynamicHeader(tmpLine);
                        this._authority.writeToErrorStream(tmpLine + MsgConstants.MSG_CRLF);
                        bHeaderHasBeenRead = true;
                        continue;
                    }
                    this._authority.stdOutLogCount(false);
                    obj = this.unmarshallObject(tmpLine);
                    ((BbObject)obj).getBbAttributes().setString("embed", tmpLine);
                    this.queue(obj);
                    ++this._iBatchSize;
                    if (this._iBatchSize > maxBatchSize) {
                        this._authority.commit();
                        this._iBatchSize = 0;
                    }
                }
                catch (ValidationException ve) {
                    this._authority.logError(tmpLine, (Exception)((Object)ve));
                }
                catch (IllegalArgumentException iae) {
                    this._authority.logError(tmpLine, iae);
                }
                if (waitLength <= 0) continue;
                Thread.yield();
                try {
                    Thread.sleep(waitLength * 1000);
                }
                catch (InterruptedException ie) {}
            }
        }
        catch (IOException io) {
            throw new SnapshotException(this._authority.getConfigurationManager().getLocaleExceptionMessage("stream.err.io"), io);
        }
        finally {
            try {
                this._authority.commit();
            }
            catch (SnapshotException se) {
                this._authority.logError(this._authority.getConfigurationManager().getLocaleExceptionMessage("db.general.failure"), (Exception)((Object)se));
            }
            this._authority.stdOutLogCount(true);
        }
    }

    public LinkedList getLegacyPositionMapping() {
        return this._legacyPosMapping;
    }

    public LinkedList getPositionMapping() {
        return this._posMapping;
    }

    public IAdminObject unmarshallObject(String lineSrc) throws ValidationException {
        IAdminObject objToReturn = this.getObjectInstance();
        objToReturn.getBbAttributes().setId("DataSourceId", this._authority.getDataSource().getId());
        String delim = String.valueOf(this._authority.getConfigurationManager().getDelimeter());
        String escap = this._authority.getConfigurationManager().getEscapeSequence();
        String errorDelim = this._authority.getConfigurationManager().getSetting("error.delimeter");
        boolean bAttributeToggle = false;
        boolean bEscapeToggle = false;
        StringTokenizer tkn = new StringTokenizer(lineSrc, delim, true);
        int relativePos = 0;
        String tmp = "";
        while (tkn.hasMoreElements()) {
            int absolutePos;
            String buffer = (String)tkn.nextElement();
            if (bEscapeToggle) {
                bEscapeToggle = false;
                tmp = tmp + buffer;
            } else {
                tmp = buffer;
            }
            if (tmp.endsWith(escap)) {
                tmp = tmp.substring(0, tmp.length() - 1) + delim;
                bEscapeToggle = true;
                if (!tkn.hasMoreElements()) continue;
                tkn.nextElement();
                continue;
            }
            if (tmp.equals(delim)) {
                if (!bAttributeToggle) {
                    ++relativePos;
                }
                bAttributeToggle = false;
                continue;
            }
            if (tmp.indexOf(errorDelim) == 0) continue;
            bAttributeToggle = true;
            String mapKey = "";
            try {
                absolutePos = this._legacyPosMapping.indexOf(this._fieldMapping.get(String.valueOf(relativePos)));
                mapKey = this._legacyPosMapping.get(absolutePos);
            }
            catch (Exception e) {
                absolutePos = -1;
            }
            if (absolutePos == -1) {
                try {
                    absolutePos = this._posMapping.indexOf(this._fieldMapping.get(String.valueOf(relativePos)));
                    mapKey = this._posMapping.get(absolutePos);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            boolean bFlagNotDirty = !(absolutePos >= 0 && !this.getOverrideMask().get(absolutePos) || this._authority.getOperation() == Authority.Operation.CLONE && mapKey.indexOf("template") > -1);
            if (tmp.length() > 0) {
                this.handleAttributeMapping(objToReturn, absolutePos, tmp, !bFlagNotDirty);
            }
            ++relativePos;
        }
        return objToReturn;
    }

    public String getSetting(int pos) {
        String[] bbDataColumnList = this.getBbListing();
        if (pos < 0 || pos > bbDataColumnList.length) {
            return null;
        }
        return bbDataColumnList[pos];
    }

    public BitSet getOverrideMask() {
        return this._ovrMask;
    }

    public void queue(IAdminObject eObject) {
        this._authority.queue(eObject);
    }

    protected boolean isTagEmpty(String val) {
        return val == null || val.length() == 0;
    }

    protected abstract IAdminObject getObjectInstance();

    protected abstract void handleAttributeMapping(IAdminObject var1, int var2, String var3, boolean var4) throws ValidationException;

    protected abstract boolean validateHeaderForRequiredFields(String var1);

    protected abstract String[] getBbListing();

    protected abstract boolean validateHeaderLabel(String var1);

    protected abstract void parameterMappingInitialization() throws SnapshotException;

    protected abstract void controlMaskInitialization() throws SnapshotException;

    private void reviewDynamicHeader(String lineSrc) throws ValidationException {
        StringTokenizer tkn = new StringTokenizer(lineSrc, String.valueOf(this._authority.getConfigurationManager().getSetting("data.delimeter")), false);
        int pos = 0;
        ValidationException ve = new ValidationException();
        while (tkn.hasMoreElements()) {
            String tmp = (String)tkn.nextElement();
            tmp = tmp.toLowerCase().trim();
            this._fieldMapping.put(String.valueOf(pos), tmp);
            if (this._authority.getConfigurationManager().getSetting("header.validation").equalsIgnoreCase("y") && !this.validateHeaderLabel(tmp)) {
                ve.addWarning(tmp, this._authority.getConfigurationManager().getLocaleExceptionMessage("parser.header.label"));
            }
            ++pos;
        }
        if (ve.getWarnings().size() > 0) {
            this._authority.logWarning(ve.getLocalizedMessage(), (Exception)((Object)ve));
        }
    }

    private int isLineReserved(String val) {
        if (val.indexOf("***FileHeader") != -1) {
            return 0;
        }
        if (val.indexOf("***FileFooter") != -1) {
            return 1;
        }
        return -1;
    }
}

