/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.authority.XmlAuthority;
import blackboard.admin.snapshot.serialize.IParser;
import blackboard.admin.snapshot.serialize.IXmlHandler;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryMembershipXmlHandler;
import blackboard.admin.snapshot.serialize.category.CategoryXmlHandler;
import blackboard.admin.snapshot.serialize.course.CourseXmlHandler;
import blackboard.admin.snapshot.serialize.course.MembershipXmlHandler;
import blackboard.admin.snapshot.serialize.properties.PropertiesXmlHandler;
import blackboard.admin.snapshot.serialize.role.PortalRoleMembershipXmlHandler;
import blackboard.admin.snapshot.serialize.user.ObserverAssociationXmlHandler;
import blackboard.admin.snapshot.serialize.user.PersonXmlHandler;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.platform.BbServiceManager;
import blackboard.platform.StatusCode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlParser
extends DefaultHandler
implements IParser {
    private Authority _authority;
    private Reader _in;
    protected BitSet _ovrMask;
    protected Map<String, IXmlHandler> _handlerList;
    protected IXmlHandler _activeHandler;
    private int _iBatchSize = 0;
    private int _iMaxBatchSize = -1;
    private int _iWaitLength = -1;
    private StringBuffer _sb = new StringBuffer();
    protected ConversionUtility _cvUtility;

    public XmlParser() {
        this._handlerList = new Hashtable<String, IXmlHandler>();
    }

    private static final void setDefaultHandlers(Map<String, IXmlHandler> handlerList, Authority authority) {
        XmlHandler handler = null;
        handler = new PropertiesXmlHandler();
        handler.init(authority);
        handlerList.put("properties", handler);
        handler = new PersonXmlHandler();
        handler.init(authority);
        handlerList.put("person", handler);
        handler = new CourseXmlHandler();
        handler.init(authority);
        handlerList.put("group", handler);
        handler = new MembershipXmlHandler();
        handler.init(authority);
        handlerList.put("membership", handler);
        handler = new CategoryXmlHandler();
        handler.init(authority);
        handlerList.put("category", handler);
        handler = new CategoryMembershipXmlHandler();
        handler.init(authority);
        handlerList.put("category_membership", handler);
        handlerList.put("category_member", handler);
        handler = new PortalRoleMembershipXmlHandler();
        handler.init(authority);
        handlerList.put("portal_role_membership", handler);
        handler = new ObserverAssociationXmlHandler();
        handler.init(authority);
        handlerList.put("observer_membership", handler);
        handlerList.put("observer_user", handler);
    }

    public IXmlHandler getActiveHandler(String key) {
        if (key != null && this._handlerList.containsKey(key)) {
            try {
                this._activeHandler = this._handlerList.get(key);
            }
            catch (ClassCastException cce) {
                this._activeHandler = null;
            }
        }
        return this._activeHandler;
    }

    @Override
    public void init(Authority authority, Reader in) {
        this._authority = authority;
        this._in = new BufferedReader(in);
        this._cvUtility = new ConversionUtility(this._authority.getConfigurationManager());
        XmlParser.setDefaultHandlers(this._handlerList, authority);
        if (this._authority instanceof XmlAuthority) {
            ((XmlAuthority)((Object)this._authority)).setCustomHandlers(this._handlerList);
        }
        this._iMaxBatchSize = this._authority.getConfigurationManager().getNumericSetting("snapshot.batch.size");
        this._iWaitLength = this._authority.getConfigurationManager().getNumericSetting("wait.length");
    }

    protected void checkApiLicensing() {
        BbServiceManager.getLicenseManager().runtimeAssertIsLicensed("integration.apis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws SnapshotException {
        this.checkApiLicensing();
        SAXParser parser = new SAXParser();
        InputSource src = new InputSource(this._in);
        this._authority.writeToErrorStream("<enterprise>");
        try {
            parser.setContentHandler((ContentHandler)this);
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.parse(src);
        }
        catch (SAXException sxe) {
            this._sb.append("</enterprise>");
            throw new SnapshotException(this._authority.getConfigurationManager().getLocaleExceptionMessage("parser.general.failure"), sxe);
        }
        catch (IOException exc) {
            this._sb.append("</enterprise>");
            throw new SnapshotException(this._authority.getConfigurationManager().getLocaleExceptionMessage("stream.err.io"), exc);
        }
        catch (Exception pce) {
            this._sb.append("</enterprise>");
            if (this._authority.getStatus() != StatusCode.ABORTING) {
                throw new SnapshotException(pce.getLocalizedMessage());
            }
        }
        finally {
            try {
                this._authority.commit();
            }
            catch (SnapshotException se) {
                this._authority.logError(this._authority.getConfigurationManager().getLocaleExceptionMessage("db.general.failure"), (Exception)((Object)se));
            }
            this._authority.stdOutLogCount(true);
            this._authority.writeToErrorStream(this._sb.toString());
        }
    }

    @Override
    public BitSet getOverrideMask() {
        return this._ovrMask;
    }

    private void checkForCommit(String name) {
        if (this._handlerList.containsKey(name) && this._handlerList.get(name) != this.getActiveHandler(null)) {
            this.delegateCommit();
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) {
        name = name.toLowerCase();
        this.checkForCommit(name);
        IXmlHandler aHandler = this.getActiveHandler(name);
        if (aHandler == null) {
            return;
        }
        if (name.equals("membership") || name.equals("category_membership")) {
            StringBuffer sb = new StringBuffer();
            this._startElementBuffer(name, atts, sb);
            this._authority.writeToErrorStream(sb.toString());
        } else if (name.equals("member") || name.equals("category_member")) {
            this._authority.writeToErrorStream(this._sb.toString());
            this._sb = new StringBuffer();
            this._startElement(name, atts);
        } else {
            this._startElement(name, atts);
        }
        aHandler.startElement(uri, localName, name, atts);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length == 0 || new String(ch, start, length).trim().length() == 0) {
            return;
        }
        IXmlHandler aHandler = this.getActiveHandler(null);
        if (aHandler == null) {
            return;
        }
        this._characters(ch, start, length);
        aHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String local, String name) {
        IXmlHandler aHandler = this.getActiveHandler(name = name.toLowerCase());
        if (aHandler == null) {
            return;
        }
        if (name.equals("member") || name.equals("category_membership")) {
            this.delegateCommit();
            StringBuffer sb = new StringBuffer();
            this._endElementBuffer(name, sb);
            this._authority.writeToErrorStream(sb.toString());
        } else {
            this._endElement(name);
        }
        this.queue(aHandler.endElement(uri, local, name));
    }

    @Override
    public void queue(IAdminObject eObject) {
        if (this._authority.getStatus() == StatusCode.ABORTING) {
            throw new RuntimeException("");
        }
        if (eObject == null) {
            return;
        }
        this.getActiveHandler(null).release();
        if (this._authority.getDataSource() != null) {
            eObject.getBbAttributes().setId("DataSourceId", this._authority.getDataSource().getId());
        }
        if (eObject.getBbAttributes().getBbAttribute("embed") == null) {
            eObject.getBbAttributes().setString("embed", this._sb.toString());
        }
        this._sb = new StringBuffer();
        this._authority.stdOutLogCount(false);
        this._authority.queue(eObject);
        ++this._iBatchSize;
        if (this._iBatchSize > this._iMaxBatchSize) {
            this.delegateCommit();
        }
        if (this._iWaitLength > 0) {
            Thread.yield();
            try {
                Thread.sleep(this._iWaitLength * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void delegateCommit() {
        try {
            this._authority.commit();
        }
        catch (SnapshotException se) {
            throw new RuntimeException(se.getLocalizedMessage());
        }
        catch (RuntimeException re) {
            throw re;
        }
        this._iBatchSize = 0;
    }

    private void _startElement(String name, Attributes attrs) {
        this._startElementBuffer(name, attrs, this._sb);
    }

    private void _startElementBuffer(String name, Attributes attrs, StringBuffer sb) {
        sb.append("<");
        sb.append(name);
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i = 0; i < len; ++i) {
                sb.append(" ");
                sb.append(attrs.getLocalName(i));
                sb.append("=\"");
                sb.append(this._normalize(attrs.getValue(i)));
                sb.append("\"");
            }
        }
        sb.append(">");
    }

    private void _endElement(String name) {
        this._endElementBuffer(name, this._sb);
    }

    private void _endElementBuffer(String name, StringBuffer sb) {
        sb.append("</");
        sb.append(name);
        sb.append(">");
    }

    private void _characters(char[] ch, int start, int length) {
        this._sb.append(this._normalize(new String(ch, start, length)));
    }

    private String _normalize(String s) {
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(";");
                    continue block7;
                }
                default: {
                    str.append(String.valueOf(ch));
                }
            }
        }
        return str.toString();
    }
}

