/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.category;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.category.AdminCategory;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CategoryDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "category.bb.controlled.fields";
    static String[] _dataColumnList = new String[]{"external_category_key", "row_status", "available_ind", "title", "frontpage_ind", "new_data_source_key", "parent_category_key", "new_external_category_key", "description", "restrict_ind"};
    static String[] _requiredFieldList = new String[]{"external_category_key"};

    protected String[] getBbListing() {
        return _dataColumnList;
    }

    protected boolean validateHeaderForRequiredFields(String header) {
        for (int cnt = 0; cnt < _requiredFieldList.length; ++cnt) {
            int pos = header.indexOf(_requiredFieldList[cnt]);
            int mrk = pos + _requiredFieldList[cnt].length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimeter()) continue;
            return true;
        }
        return false;
    }

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (int val = 0; val < _dataColumnList.length; ++val) {
            if (!_dataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        AdminCategory objToReturn = (AdminCategory)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                objToReturn.setBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 1: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setFrontPageInd(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("FrontPageInd").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setTitle(TextFormat.trimString((String)tmp, (int)255));
                attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setParentBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("ParentBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setReplacementBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setDescription(TextFormat.trimString((String)tmp, (int)1000));
                attribs.getBbAttribute("Description").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsRestricted(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsRestricted").setIsDirty(bFlagNotDirty);
            }
        }
    }

    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {}
        }
    }

    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        for (int cnt = 0; cnt < _dataColumnList.length; ++cnt) {
            this._posMapping.addLast(_dataColumnList[cnt]);
        }
        this._ovrMask = new BitSet(_dataColumnList.length);
    }
}

