/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.category;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CategoryMembershipDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "categorymembership.bb.controlled.fields";
    static String[] _bbCrsDataColumnList = new String[]{"external_course_key", "external_category_key", "row_status", "available_ind", "new_data_source_key"};
    static String[] _bbOrgDataColumnList = new String[]{"external_organization_key", "external_category_key", "row_status", "available_ind", "new_data_source_key"};
    static String[] _crsRequiredFieldList = new String[]{"external_course_key", "external_category_key"};
    static String[] _orgRequiredFieldList = new String[]{"external_organization_key", "external_category_key"};

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        String[] dataList = this.getBbListing();
        for (int val = 0; val < dataList.length; ++val) {
            if (!dataList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {}
        }
    }

    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        String[] dataList = this.getBbListing();
        for (int cnt = 0; cnt < dataList.length; ++cnt) {
            this._posMapping.addLast(dataList[cnt]);
        }
        this._ovrMask = new BitSet(dataList.length);
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        IAdminObject objToReturn = obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                attribs.setString("GroupBatchUid", TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 1: {
                objToReturn.getBbAttributes().setString("CategoryBatchUid", TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.getBbAttributes().setBoolean("IsAvailable", ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
            }
        }
    }
}

