/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import blackboard.xml.XmlUtil;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class CourseDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "group.bb.controlled.fields";
    static String[] _eeDataColumnList = new String[]{"abbreviated_title", "course_section_key", "title", "course_description", "start_date", "end_date", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "new_course_section_key", "template_key", "", "", ""};
    static String[] _bbCrsDataColumnList = new String[]{"course_id", "external_course_key", "course_name", "description", "start_date", "end_date", "classification_key", "new_data_source_key", "row_status", "enroll_option", "available_ind", "catalog_ind", "desc_page", "duration", "lockout_ind", "pace", "service_level", "abs_limit", "soft_limit", "upload_limit", "enroll_start", "enroll_end", "days_of_use", "institution_name", "fee", "allow_guest_ind", "enroll_access_code", "new_external_course_key", "template_course_key", "allow_observer_ind", "locale", "locale_enforced"};
    static String[] _bbOrgDataColumnList = new String[]{"organization_id", "external_organization_key", "organization_name", "description", "start_date", "end_date", "classification_key", "new_data_source_key", "row_status", "enroll_option", "available_ind", "catalog_ind", "desc_page", "duration", "lockout_ind", "pace", "service_level", "abs_limit", "soft_limit", "upload_limit", "enroll_start", "enroll_end", "days_of_use", "institution_name", "fee", "allow_guest_ind", "enroll_access_code", "new_external_organization_key", "template_organization_key", "allow_observer_ind", "locale", "locale_enforced"};
    static String[] _crsRequiredFieldList = new String[]{"external_course_key", "course_section_key"};
    static String[] _orgRequiredFieldList = new String[]{"external_organization_key", "course_section_key"};

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (int val = 0; val < _eeDataColumnList.length; ++val) {
            if (!_eeDataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        if (bStatus) {
            return bStatus;
        }
        String[] list = this.getBbListing();
        for (int val = 0; val < list.length; ++val) {
            if (!list[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        AdminCourse objToReturn = (AdminCourse)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                objToReturn.setCourseId(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("CourseId").setIsDirty(bFlagNotDirty);
                break;
            }
            case 1: {
                objToReturn.setBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 2: {
                objToReturn.setTitle(TextFormat.trimString((String)tmp, (int)255));
                attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setDescription(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("Description").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                objToReturn.setStartDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("StartDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setEndDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("EndDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setClassificationBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("ClassificationBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setEnrollmentType(this._cvUtility.stringToEnrollment(tmp));
                attribs.getBbAttribute("EnrollmentType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 10: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 11: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowInCatalog(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("ShowInCatalog").setIsDirty(bFlagNotDirty);
                break;
            }
            case 12: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setHasDescriptionPage(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("HasDescriptionPage").setIsDirty(bFlagNotDirty);
                break;
            }
            case 13: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setDurationType(this._cvUtility.stringToDuration(tmp));
                attribs.getBbAttribute("DurationType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 14: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsLockedOut(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsLockedOut").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setPaceType(this._cvUtility.stringToPace(tmp));
                attribs.getBbAttribute("PaceType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setServiceLevelType(this._cvUtility.stringToServiceLevel(tmp));
                attribs.getBbAttribute("ServiceLevelType").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAbsoluteLimit(XmlUtil.parseLong((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("AbsoluteLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setSoftLimit(XmlUtil.parseLong((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("SoftLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setUploadLimit(XmlUtil.parseLong((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("UploadLimit").setIsDirty(bFlagNotDirty);
                break;
            }
            case 20: {
                objToReturn.setEnrollmentStartDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("EnrollmentStartDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 21: {
                objToReturn.setEnrollmentEndDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("EnrollmentEndDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 22: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setNumDaysOfUse(XmlUtil.parseInteger((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("NumDaysOfUse").setIsDirty(bFlagNotDirty);
                break;
            }
            case 23: {
                objToReturn.setInstitutionName(TextFormat.trimString((String)tmp, (int)255));
                attribs.getBbAttribute("InstitutionName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 24: {
                objToReturn.setFee(XmlUtil.parseFloat((String)TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("Fee").setIsDirty(bFlagNotDirty);
                break;
            }
            case 25: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAllowGuests(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("AllowGuests").setIsDirty(bFlagNotDirty);
                break;
            }
            case 26: {
                objToReturn.setEnrollmentAccessCode(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("EnrollmentAccessCode").setIsDirty(bFlagNotDirty);
                break;
            }
            case 27: {
                objToReturn.setReplacementBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 28: {
                objToReturn.setTemplateBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("TemplateBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 29: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setAllowObservers(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("AllowObservers").setIsDirty(bFlagNotDirty);
                break;
            }
            case 30: {
                objToReturn.setLocale(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("Locale").setIsDirty(bFlagNotDirty);
                break;
            }
            case 31: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsLocaleEnforced(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsLocaleEnforced").setIsDirty(bFlagNotDirty);
            }
        }
    }

    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io1) {
                try {
                    this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
                }
                catch (IndexOutOfBoundsException io2) {}
            }
        }
    }

    protected void parameterMappingInitialization() {
        this._legacyPosMapping = new LinkedList();
        for (int cnt = 0; cnt < _eeDataColumnList.length; ++cnt) {
            this._legacyPosMapping.addLast(_eeDataColumnList[cnt]);
        }
        this._posMapping = new LinkedList();
        String[] dataList = this.getBbListing();
        for (int cnt = 0; cnt < dataList.length; ++cnt) {
            this._posMapping.addLast(dataList[cnt]);
        }
        this._ovrMask = new BitSet(dataList.length);
    }
}

