/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.AdminCourse;
import blackboard.admin.data.course.AdminCourseXmlDef;
import blackboard.admin.data.course.CourseSite;
import blackboard.admin.data.course.Organization;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.course.CourseDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.BbEnum;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.course.ButtonStyle;
import blackboard.data.course.Classification;
import blackboard.data.course.Course;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class CourseXmlHandler
extends XmlHandler
implements AdminCourseXmlDef {
    public static final String XML_REGISTRY = "group";
    static final String CONTROLLED_SETTINGS = "group.bb.controlled.fields";
    private AdminCourse _obj;
    private Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private BbAttributes _bbAttribs;
    private DataType _dataType;
    private StringBuffer _xPath = new StringBuffer("");
    private NodeHandler _activeNodeHandler;
    private Map<String, NodeHandler> _nodeHandlers = new HashMap<String, NodeHandler>();

    public void init(Authority authority) {
        super.init(authority);
        try {
            this._dataType = new DataType(Class.forName(authority.getConfigurationManager().getSetting("DATA_TYPE_TOGGLE")));
        }
        catch (Exception exc) {
            this._dataType = CourseSite.DATA_TYPE;
        }
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        this.initDelimitedXmlMapping();
        this.initNodeHandlers();
        if (tmp == null || authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            if (authority.getOperation() == Authority.Operation.CLONE && txt.indexOf("template") > -1) continue;
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._eeDataColumnList);
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._bbCrsDataColumnList);
        this.handleDelimitedArrayXmlMapping(CourseDelimitedParser._bbOrgDataColumnList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block30: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("short", "ignore");
                    continue block30;
                }
                case 2: {
                    this._ovrMap.put("long", "ignore");
                    continue block30;
                }
                case 3: {
                    this._ovrMap.put("full", "ignore");
                    continue block30;
                }
                case 4: {
                    this._ovrMap.put("begin", "ignore");
                    continue block30;
                }
                case 5: {
                    this._ovrMap.put("end", "ignore");
                    continue block30;
                }
                case 6: {
                    this._ovrMap.put("x_bb_classificationkey", "ignore");
                    continue block30;
                }
                case 27: {
                    this._ovrMap.put("x_bb_replacementkey", "ignore");
                    continue block30;
                }
                case 8: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block30;
                }
                case 9: {
                    this._ovrMap.put("x_bb_enrollment_type", "ignore");
                    continue block30;
                }
                case 10: {
                    this._ovrMap.put("x_bb_available", "ignore");
                    continue block30;
                }
                case 11: {
                    this._ovrMap.put("x_bb_catalog", "ignore");
                    continue block30;
                }
                case 13: {
                    this._ovrMap.put("x_bb_duration", "ignore");
                    continue block30;
                }
                case 14: {
                    this._ovrMap.put("x_bb_lockout_indicator", "ignore");
                    continue block30;
                }
                case 15: {
                    this._ovrMap.put("x_bb_pace", "ignore");
                    continue block30;
                }
                case 16: {
                    this._ovrMap.put("typevalue", "ignore");
                    continue block30;
                }
                case 17: {
                    this._ovrMap.put("x_bb_absolute_limit", "ignore");
                    continue block30;
                }
                case 18: {
                    this._ovrMap.put("x_bb_soft_limit", "ignore");
                    continue block30;
                }
                case 19: {
                    this._ovrMap.put("x_bb_upload_limit", "ignore");
                    continue block30;
                }
                case 20: {
                    this._ovrMap.put("x_bb_enroll_start", "ignore");
                    continue block30;
                }
                case 21: {
                    this._ovrMap.put("x_bb_enroll_end", "ignore");
                    continue block30;
                }
                case 22: {
                    this._ovrMap.put("x_bb_days_of_use", "ignore");
                    continue block30;
                }
                case 23: {
                    this._ovrMap.put("x_bb_institution_name", "ignore");
                    continue block30;
                }
                case 24: {
                    this._ovrMap.put("x_bb_fee", "ignore");
                    continue block30;
                }
                case 25: {
                    this._ovrMap.put("x_bb_allow_guests", "ignore");
                    continue block30;
                }
                case 26: {
                    this._ovrMap.put("x_bb_enrollment_access_code", "ignore");
                    continue block30;
                }
                case 7: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                    continue block30;
                }
                case 28: {
                    this._ovrMap.put("x_bb_templatekey", "ignore");
                    continue block30;
                }
                case 29: {
                    this._ovrMap.put("x_bb_allow_observers", "ignore");
                }
            }
        }
    }

    private void initNodeHandlers() {
        this._nodeHandlers.put("/sourcedid", new SourcedIdHandler());
        this._nodeHandlers.put("/grouptype", new GroupTypeHandler());
        this._nodeHandlers.put("/description", new DescriptionHandler());
        this._nodeHandlers.put("/timeframe", new TimeFrameHandler());
        this._nodeHandlers.put("/extension", new ExtensionHandler());
    }

    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._obj = this._dataType.equals((Object)Organization.DATA_TYPE) ? new Organization() : new CourseSite();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
        this._xPath = this._xPath.append("/").append(name);
        if (this._activeNodeHandler == null) {
            this._activeNodeHandler = this._nodeHandlers.get(this._xPath.toString());
        }
    }

    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeNodeHandler != null) {
            this._activeNodeHandler.handleCharacters(value, bDirtyFlag);
        }
    }

    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (this._activeNodeHandler != null && this._xPath.toString().equalsIgnoreCase(this._activeNodeHandler.getPath())) {
            this._activeNodeHandler = null;
        }
        if (this._xPath.length() > 0) {
            this._xPath = this._xPath.delete(this._xPath.lastIndexOf("/"), this._xPath.length());
        }
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            return this._obj;
        }
        return null;
    }

    public void release() {
        this._obj = null;
    }

    private class ExtensionHandler
    implements NodeHandler {
        public static final String PATH = "/extension";

        private ExtensionHandler() {
        }

        public String getPath() {
            return PATH;
        }

        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_replacementkey")) {
                CourseXmlHandler.this._obj.setReplacementBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_templatekey")) {
                CourseXmlHandler.this._obj.setTemplateBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("TemplateBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
                CourseXmlHandler.this._obj.setDataSourceBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
                CourseXmlHandler.this._obj.setRowStatus(CourseXmlHandler.this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_available")) {
                CourseXmlHandler.this._obj.setIsAvailable(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_catalog")) {
                CourseXmlHandler.this._obj.setShowInCatalog(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ShowInCatalog").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_description_page")) {
                CourseXmlHandler.this._obj.setHasDescriptionPage(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("HasDescriptionPage").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_allow_guests")) {
                CourseXmlHandler.this._obj.setAllowGuests(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("AllowGuests").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_allow_observers")) {
                CourseXmlHandler.this._obj.setAllowObservers(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("AllowObservers").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_pace")) {
                CourseXmlHandler.this._obj.setPaceType(CourseXmlHandler.this._cvUtility.intToPace(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("PaceType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_institution_name")) {
                CourseXmlHandler.this._obj.setInstitutionName(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("InstitutionName").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_classificationkey")) {
                CourseXmlHandler.this._obj.setClassificationBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ClassificationBatchUid").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_fee")) {
                CourseXmlHandler.this._obj.setFee(XmlUtil.parseFloat((String)value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Fee").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_locale")) {
                CourseXmlHandler.this._obj.setLocale(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Locale").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_locale_enforced_indicator")) {
                CourseXmlHandler.this._obj.setIsLocaleEnforced(ConversionUtility.getBoolean(value));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("IsLocaleEnforced").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
                CourseXmlHandler.this._obj.getBbAttributes().setString("embed", value);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
                try {
                    CourseXmlHandler.this._bbAttribs.setId("DataSourceId", BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
                }
                catch (Exception exc) {
                    CourseXmlHandler.this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
                }
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
                try {
                    CourseXmlHandler.this._obj.setId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(CourseXmlHandler.this._obj.getDataType(), value));
                }
                catch (Exception exc) {}
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_buttonstyles_id")) {
                try {
                    CourseXmlHandler.this._obj.setButtonStyleId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(ButtonStyle.DATA_TYPE, value));
                }
                catch (Exception exc) {}
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_internal_classification_id")) {
                try {
                    CourseXmlHandler.this._obj.setClassificationId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(Classification.DATA_TYPE, value));
                }
                catch (Exception exc) {}
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_enrollment_type")) {
                CourseXmlHandler.this._obj.setEnrollmentType(CourseXmlHandler.this._cvUtility.intToEnrollment(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EnrollmentType").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_navstyle")) {
                try {
                    CourseXmlHandler.this._obj.setNavStyle(CourseXmlHandler.this._cvUtility.stringToNavStyle(value));
                }
                catch (ValidationException ve) {
                    CourseXmlHandler.this._obj.setNavStyle(Course.NavStyle.DEFAULT);
                }
                CourseXmlHandler.this._bbAttribs.getBbAttribute("NavStyle").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("x_bb_duration")) {
                CourseXmlHandler.this._obj.setDurationType(CourseXmlHandler.this._cvUtility.intToDuration(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("DurationType").setIsDirty(bFlagDirty);
            }
        }
    }

    private class TimeFrameHandler
    implements NodeHandler {
        public static final String PATH = "/timeframe";

        private TimeFrameHandler() {
        }

        public String getPath() {
            return PATH;
        }

        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("begin")) {
                CourseXmlHandler.this._obj.setStartDate(TimeFormat.stringToCalendar(value, "yyyy-MM-dd"));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("StartDate").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("end")) {
                CourseXmlHandler.this._obj.setEndDate(TimeFormat.stringToCalendar(value, "yyyy-MM-dd"));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("EndDate").setIsDirty(bFlagDirty);
            }
        }
    }

    private class DescriptionHandler
    implements NodeHandler {
        public static final String PATH = "/description";

        private DescriptionHandler() {
        }

        public String getPath() {
            return PATH;
        }

        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("short")) {
                CourseXmlHandler.this._obj.setCourseId(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("CourseId").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("long")) {
                CourseXmlHandler.this._obj.setTitle(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Title").setIsDirty(bFlagDirty);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("full")) {
                CourseXmlHandler.this._obj.setDescription(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("Description").setIsDirty(bFlagDirty);
            }
        }
    }

    private class GroupTypeHandler
    implements NodeHandler {
        public static final String PATH = "/grouptype";

        private GroupTypeHandler() {
        }

        public String getPath() {
            return PATH;
        }

        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("typevalue")) {
                CourseXmlHandler.this._obj.getBbAttributes().setBbEnum("ServiceLevelType", (BbEnum)CourseXmlHandler.this._cvUtility.intToServiceLevel(XmlUtil.parseInteger((String)value)));
                CourseXmlHandler.this._bbAttribs.getBbAttribute("ServiceLevelType").setIsDirty(bFlagDirty);
            }
        }
    }

    private class SourcedIdHandler
    implements NodeHandler {
        public static final String PATH = "/sourcedid";

        private SourcedIdHandler() {
        }

        public String getPath() {
            return PATH;
        }

        public void handleCharacters(String value, boolean bFlagDirty) {
            if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("id")) {
                CourseXmlHandler.this._obj.setBatchUid(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("BatchUid").setIsDirty(bFlagDirty);
                CourseXmlHandler.this._bbAttribs.setString("sourcedid_id", value);
            } else if (CourseXmlHandler.this._activeElement.equalsIgnoreCase("source")) {
                CourseXmlHandler.this._obj.setSourcedidSource(value);
                CourseXmlHandler.this._bbAttribs.getBbAttribute("source").setIsDirty(bFlagDirty);
            }
        }
    }

    private static interface NodeHandler {
        public String getPath();

        public void handleCharacters(String var1, boolean var2);
    }
}

