/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.course;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.course.Membership;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.BbLink;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class MembershipDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "membership.bb.controlled.fields";
    static String[] _eeDataColumnList = new String[]{"course_section_key", "campus_user_key", "course_role"};
    static String[] _bbCrsDataColumnList = new String[]{"external_course_key", "external_person_key", "role", "row_status", "available_ind", "link_name_1", "link_url_1", "link_desc_1", "link_name_2", "link_url_2", "link_desc_2", "link_name_3", "link_url_3", "link_desc_3", "intro", "pinfo", "new_data_source_key", "note", "cartridge_ind", "last_access_date"};
    static String[] _bbOrgDataColumnList = new String[]{"external_organization_key", "external_person_key", "role", "row_status", "available_ind", "link_name_1", "link_url_1", "link_desc_1", "link_name_2", "link_url_2", "link_desc_2", "link_name_3", "link_url_3", "link_desc_3", "intro", "pinfo", "new_data_source_key", "note", "cartridge_ind", "last_access_date"};
    static String[] _legacyRequiredFieldList = new String[]{"course_section_key", "campus_user_key"};
    static String[] _crsRequiredFieldList = new String[]{"external_course_key", "external_person_key"};
    static String[] _orgRequiredFieldList = new String[]{"external_organization_key", "external_person_key"};

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (int val = 0; val < _eeDataColumnList.length; ++val) {
            if (!_eeDataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        if (bStatus) {
            return bStatus;
        }
        String[] dataList = this.getBbListing();
        for (int val = 0; val < dataList.length; ++val) {
            if (!dataList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io1) {
                try {
                    this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
                }
                catch (IndexOutOfBoundsException io2) {}
            }
        }
    }

    protected void parameterMappingInitialization() {
        this._legacyPosMapping = new LinkedList();
        for (int cnt = 0; cnt < _eeDataColumnList.length; ++cnt) {
            this._legacyPosMapping.addLast(_eeDataColumnList[cnt]);
        }
        this._posMapping = new LinkedList();
        String[] dataList = this.getBbListing();
        for (int cnt = 0; cnt < dataList.length; ++cnt) {
            this._posMapping.addLast(dataList[cnt]);
        }
        this._ovrMask = new BitSet(dataList.length);
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        Membership objToReturn = (Membership)obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 1: {
                objToReturn.setPersonBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 0: {
                objToReturn.getBbAttributes().setString("GroupBatchUid", TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRole(this._cvUtility.stringToCourseRole(tmp));
                attribs.getBbAttribute("Role").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setLinkName1(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Name", 1, bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setLinkUrl1(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Url", 1, bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setLinkDescription1(TextFormat.trimString((String)tmp, (int)255));
                this.resetLinkAttribute(objToReturn, "Description", 1, bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setLinkName2(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Name", 2, bFlagNotDirty);
                break;
            }
            case 9: {
                objToReturn.setLinkUrl2(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Url", 2, bFlagNotDirty);
                break;
            }
            case 10: {
                objToReturn.setLinkDescription2(TextFormat.trimString((String)tmp, (int)255));
                this.resetLinkAttribute(objToReturn, "Description", 2, bFlagNotDirty);
                break;
            }
            case 11: {
                objToReturn.setLinkName3(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Name", 3, bFlagNotDirty);
                break;
            }
            case 12: {
                objToReturn.setLinkUrl3(TextFormat.trimString((String)tmp, (int)100));
                this.resetLinkAttribute(objToReturn, "Url", 3, bFlagNotDirty);
                break;
            }
            case 13: {
                objToReturn.setLinkDescription3(TextFormat.trimString((String)tmp, (int)255));
                this.resetLinkAttribute(objToReturn, "Description", 3, bFlagNotDirty);
                break;
            }
            case 14: {
                objToReturn.setIntroduction(TextFormat.trimString((String)tmp, (int)4000));
                attribs.getBbAttribute("Introduction").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                objToReturn.setPersonalInfo(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("PersonalInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                objToReturn.setNotes(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("Notes").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setHasCartridgeAccess(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("HasCartridgeAccess").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setLastAccessDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                attribs.getBbAttribute("LastAccessDate").setIsDirty(bFlagNotDirty);
            }
        }
    }

    private void resetLinkAttribute(Membership objToReturn, String name, int pos, boolean bFlagNotDirty) {
        BbLink link = objToReturn.getBbLinkAtPos(pos);
        BbAttributes attribs = link.getBbAttributes();
        attribs.getBbAttribute(name).setIsDirty(bFlagNotDirty);
    }
}

