/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.properties;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.properties.PropertiesXmlDef;
import blackboard.admin.persist.datasource.DataSourceLoader;
import blackboard.admin.persist.integration.LmsIntegrationLoader;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.persist.PersistenceException;
import blackboard.platform.BbServiceManager;
import blackboard.platform.StatusCode;
import blackboard.platform.integration.LmsIntegration;
import blackboard.platform.integration.service.DataSourceManagerFactory;
import org.xml.sax.Attributes;

public class PropertiesXmlHandler
extends XmlHandler
implements PropertiesXmlDef {
    public static final String INTEGRATION_ID = "integrationId";
    public static final String XML_REGISTRY = "properties";
    private String _activeElement;
    private Attributes _activeAttributes;

    public void init(Authority authority) {
        super.init(authority);
    }

    public void startElement(String uri, String localName, String name, Attributes atts) {
        this._activeElement = name.toLowerCase();
        this._activeAttributes = atts;
    }

    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        return null;
    }

    public void release() {
    }

    public void characters(char[] ch, int start, int length) {
        String value;
        if (this._activeElement == null) {
            return;
        }
        if (this._activeElement.equalsIgnoreCase(INTEGRATION_ID) && (value = super.updateCharacterBuffer(ch, start, length).trim()) != null && !value.equals("")) {
            LmsIntegration integration = null;
            try {
                integration = LmsIntegrationLoader.Default.getInstance().getIntegrationByGlcId(value);
                this._authority.setIntegration(integration);
            }
            catch (PersistenceException e) {
                this._authority.setStatus(StatusCode.ABORTING);
                try {
                    this._authority.logError("Integration not found in LMS_INTEGRATION table. Provided glcid = " + value + "; ", (Exception)((Object)e));
                }
                catch (SnapshotException se) {
                    // empty catch block
                }
            }
            try {
                String dataSourceBatchUid = (String)DataSourceManagerFactory.getInstance().getDataSourceData(integration.getDataSourceId()).get("batchUid");
                DataSourceLoader dLoader = (DataSourceLoader)BbServiceManager.getPersistenceService().getDbPersistenceManager().getLoader("DataSourceLoader");
                DataSource dataSrc = dLoader.loadByBatchUid(dataSourceBatchUid);
                this._authority.setDataSource(dataSrc);
            }
            catch (PersistenceException e) {
                this._authority.setStatus(StatusCode.ABORTING);
                try {
                    this._authority.logError("Datasource not found for integration glcid = " + value + "; ", (Exception)((Object)e));
                }
                catch (SnapshotException se) {
                    // empty catch block
                }
            }
        }
    }
}

