/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.role;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PortalRoleMembershipDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "portalrolemembership.bb.controlled.fields";
    static String[] _bbDataColumnList = new String[]{"role_id", "external_person_key", "row_status", "new_data_source_key"};
    static String[] _requiredFieldList = new String[]{"role_id", "external_person_key"};

    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    protected boolean validateHeaderForRequiredFields(String header) {
        for (int cnt = 0; cnt < _requiredFieldList.length; ++cnt) {
            int pos = header.indexOf(_requiredFieldList[cnt]);
            int mrk = pos + _requiredFieldList[cnt].length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimeter()) continue;
            return true;
        }
        return false;
    }

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        for (int val = 0; val < _bbDataColumnList.length; ++val) {
            if (!_bbDataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected IAdminObject getObjectInstance() {
        return new PortalRoleMembership();
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        PortalRoleMembership objToReturn = (PortalRoleMembership)obj;
        BbAttributes _attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 1: {
                objToReturn.setPersonBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("PersonBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 0: {
                objToReturn.setPortalRoleBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("PortalRoleBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                _attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
            }
        }
    }

    protected void controlMaskInitialization() throws SnapshotException {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {}
        }
    }

    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        for (int cnt = 0; cnt < _bbDataColumnList.length; ++cnt) {
            this._posMapping.addLast(_bbDataColumnList[cnt]);
        }
        this._ovrMask = new BitSet(_bbDataColumnList.length);
    }
}

