/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.role;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.role.PortalRoleMembership;
import blackboard.admin.data.role.PortalRoleMembershipXmlDef;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.role.PortalRoleMembershipDelimitedParser;
import blackboard.data.BbAttributes;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class PortalRoleMembershipXmlHandler
extends XmlHandler
implements PortalRoleMembershipXmlDef {
    public static final String XML_REGISTRY_1 = "portal_role_membership";
    static final String CONTROLLED_SETTINGS = "portalrolemembership.bb.controlled.fields";
    private PortalRoleMembership _obj;
    private Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private Attributes _activeAttributes;
    private BbAttributes _bbAttribs;

    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(PortalRoleMembershipDelimitedParser._bbDataColumnList);
        this.handleDelimitedArrayXmlMapping(PortalRoleMembershipDelimitedParser._requiredFieldList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block6: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("role", "ignore");
                    continue block6;
                }
                case 1: {
                    this._ovrMap.put("sourcedid", "ignore");
                    continue block6;
                }
                case 2: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block6;
                }
                case 3: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                }
            }
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) {
        boolean bDirtyFlag;
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            this._obj = new PortalRoleMembership();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
        this._activeAttributes = atts;
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey("role");
        if (this.unMarshallPortalRoleNode(bDirtyFlag)) {
            return;
        }
    }

    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this.unMarshallPersonSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            return this._obj;
        }
        return null;
    }

    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallPersonSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            boolean bDirtyFlag = !this._ovrMap.containsKey("sourcedid");
            this._obj.setPersonBatchUid(value);
            this._bbAttribs.getBbAttribute("PersonBatchUid").setIsDirty(bFlagDirty && bDirtyFlag);
            return true;
        }
        return false;
    }

    protected boolean unMarshallPortalRoleNode(boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("role")) {
            String value = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"roletype", (String)"");
            if (value.length() > 0) {
                boolean bDirtyFlag = !this._ovrMap.containsKey("role");
                this._obj.setPortalRoleBatchUid(value);
                this._bbAttribs.getBbAttribute("PortalRoleBatchUid").setIsDirty(bFlagDirty && bDirtyFlag);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.setRowStatus(this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.setDataSourceBatchUid(value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._obj.setDataSourceId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
                this._bbAttribs.getBbAttribute("DataSourceId").setIsDirty(bFlagDirty);
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

