/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.util.TextFormat;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class ObserverAssociationDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "observerassociation.bb.controlled.fields";
    static String[] _bbDataColumnList = new String[]{"external_observer_key", "external_user_key", "row_status", "new_data_source_key"};
    static String[] _requiredFieldList = new String[]{"external_observer_key", "external_user_key"};

    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    protected IAdminObject getObjectInstance() {
        return new ObserverAssociation();
    }

    protected boolean validateHeaderForRequiredFields(String header) {
        for (int cnt = 0; cnt < _requiredFieldList.length; ++cnt) {
            int pos = header.indexOf(_requiredFieldList[cnt]);
            int mrk = pos + _requiredFieldList[cnt].length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimeter()) continue;
            return true;
        }
        return false;
    }

    protected boolean validateHeaderLabel(String line) {
        boolean bStatus = false;
        String[] dataList = this.getBbListing();
        for (int val = 0; val < dataList.length; ++val) {
            if (!dataList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected void controlMaskInitialization() {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {}
        }
    }

    protected void parameterMappingInitialization() {
        this._posMapping = new LinkedList();
        String[] dataList = this.getBbListing();
        for (int cnt = 0; cnt < dataList.length; ++cnt) {
            this._posMapping.addLast(dataList[cnt]);
        }
        this._ovrMask = new BitSet(dataList.length);
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        IAdminObject objToReturn = obj;
        BbAttributes attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                attribs.setString("ObserverBatchUid", TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 1: {
                objToReturn.getBbAttributes().setString("UserBatchUid", TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 2: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
            }
        }
    }
}

