/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.user.ObserverAssociation;
import blackboard.admin.data.user.ObserverAssociationXmlDef;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.user.ObserverAssociationDelimitedParser;
import blackboard.base.BbEnum;
import blackboard.data.BbAttributes;
import blackboard.data.BbObject;
import blackboard.persist.DataType;
import blackboard.persist.Id;
import blackboard.platform.BbServiceManager;
import blackboard.xml.XmlUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class ObserverAssociationXmlHandler
extends XmlHandler
implements ObserverAssociationXmlDef {
    public static final String XML_REGISTRY_1 = "observer_membership";
    public static final String XML_REGISTRY_2 = "observer_user";
    static final String CONTROLLED_SETTINGS = "observerassociation.bb.controlled.fields";
    private BbObject _obj;
    private Map<String, String> _ovrMap = new HashMap<String, String>();
    private String _activeElement;
    private String _activeEntityElement;
    private BbAttributes _bbAttribs;
    private String _observerBatchUid;

    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(ObserverAssociationDelimitedParser._requiredFieldList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block5: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("id", "ignore");
                    continue block5;
                }
                case 2: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block5;
                }
                case 3: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                }
            }
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) {
        if (name.equalsIgnoreCase(XML_REGISTRY_1)) {
            this._activeEntityElement = name;
            return;
        }
        if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            this._obj = new ObserverAssociation();
            this._bbAttribs = this._obj.getBbAttributes();
            this._activeEntityElement = name;
            this._bbAttribs.setString("ObserverBatchUid", this._observerBatchUid);
            if (this._observerBatchUid != null) {
                this._bbAttribs.getBbAttribute("ObserverBatchUid").setIsDirty(true);
            }
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.getBbAttributes().setBbEnum("RecStatus", (BbEnum)((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class)));
            return;
        }
        this._activeElement = name.toLowerCase();
    }

    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this._activeEntityElement.equalsIgnoreCase(XML_REGISTRY_1)) {
            this.unMarshallMembershipSourceIdNode(value, bDirtyFlag);
            return;
        }
        if (this.unMarshallMemberSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase(XML_REGISTRY_2)) {
            return (IAdminObject)this._obj;
        }
        return null;
    }

    public void release() {
        this._obj = null;
    }

    protected boolean unMarshallMembershipSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._observerBatchUid = value;
            return true;
        }
        return false;
    }

    protected boolean unMarshallMemberSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.getBbAttributes().setString("UserBatchUid", value);
            this._bbAttribs.getBbAttribute("UserBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.getBbAttributes().setBbEnum("RowStatus", (BbEnum)this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.getBbAttributes().setString("DataSourceBatchUid", value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
            }
            catch (Exception exc) {
                // empty catch block
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_user_id")) {
            DataType dType = Person.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("UsersId", BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(dType, value));
            }
            catch (Exception exc) {
                // empty catch block
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_observer_id")) {
            DataType dType = Person.DATA_TYPE;
            try {
                this._obj.getBbAttributes().setId("ObserverId", BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(dType, value));
            }
            catch (Exception exc) {
                // empty catch block
            }
            return true;
        }
        return false;
    }
}

