/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.user.Person;
import blackboard.admin.snapshot.SnapshotException;
import blackboard.admin.snapshot.serialize.Parser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.user.User;
import blackboard.util.StringUtil;
import blackboard.util.TextFormat;
import com.blackboard.cas.security.crypto.CardNumberCipher;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class PersonDelimitedParser
extends Parser {
    static final String CONTROLLED_SETTINGS = "person.bb.controlled.fields";
    static String[] _eeDataColumnList = new String[]{"campus_role", "campus_user_key", "username", "user_password", "title", "first_name", "middle_name", "last_name", "home_phone", "home_fax", "mobile_phone", "is_phone_avail", "user_email", "is_email_avail", "birthday", "address_line_1", "address_line_2", "city", "state_province", "zip_postal_code", "country", "is_home_avail", "company", "company_department", "job_title", "work_phone", "work_fax", "is_work_avail", "is_public", "person_id", "institution_role", "", "", "", "", "", "", "", "", "", "new_campus_user_key", "", ""};
    static String[] _bbDataColumnList = new String[]{"system_role", "external_person_key", "user_id", "passwd", "title", "firstname", "middlename", "lastname", "h_phone_1", "h_fax", "m_phone", "phone_ind", "email", "email_ind", "birthdate", "street_1", "street_2", "city", "state", "zip_code", "country", "address_ind", "company", "department", "job_title", "b_phone_1", "b_fax", "work_ind", "public_ind", "student_id", "institution_role", "row_status", "gender", "b_phone_2", "h_phone_2", "webpage", "educ_level", "available_ind", "new_data_source_key", "settings", "new_external_person_key", "locale", "card_number"};
    static String[] _requiredFieldList = new String[]{"external_person_key", "campus_user_key"};

    protected String[] getBbListing() {
        return _bbDataColumnList;
    }

    protected boolean validateHeaderForRequiredFields(String header) {
        for (int cnt = 0; cnt < _requiredFieldList.length; ++cnt) {
            int pos = header.indexOf(_requiredFieldList[cnt]);
            int mrk = pos + _requiredFieldList[cnt].length();
            if (pos <= -1 || mrk != header.length() && header.charAt(mrk) != this._authority.getConfigurationManager().getDelimeter()) continue;
            return true;
        }
        return false;
    }

    protected boolean validateHeaderLabel(String line) {
        int val;
        boolean bStatus = false;
        for (val = 0; val < _eeDataColumnList.length; ++val) {
            if (!_eeDataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        if (bStatus) {
            return bStatus;
        }
        for (val = 0; val < _bbDataColumnList.length; ++val) {
            if (!_bbDataColumnList[val].equals(line)) continue;
            bStatus = true;
            break;
        }
        return bStatus;
    }

    protected IAdminObject getObjectInstance() {
        return new Person();
    }

    protected void handleAttributeMapping(IAdminObject obj, int absolutePos, String tmp, boolean bFlagNotDirty) throws ValidationException {
        Person objToReturn = (Person)obj;
        BbAttributes _attribs = objToReturn.getBbAttributes();
        switch (absolutePos) {
            case 0: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                User.SystemRole role = this._cvUtility.stringToSystemRole(tmp);
                if (role != null) {
                    objToReturn.setSystemRole(role);
                } else {
                    objToReturn.setSystemRoleIdentifier(tmp);
                }
                _attribs.getBbAttribute("SystemRole").setIsDirty(bFlagNotDirty);
                break;
            }
            case 1: {
                objToReturn.setBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                break;
            }
            case 2: {
                objToReturn.setUserName(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("UserName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 3: {
                tmp = TextFormat.trimString((String)tmp, (int)-1);
                boolean bEncrypt = ConversionUtility.getBoolean(this._authority.getConfigurationManager().getSetting("encrypt.password"));
                if (bEncrypt) {
                    tmp = ConversionUtility.getHashValue(tmp);
                }
                objToReturn.setPassword(tmp);
                _attribs.getBbAttribute("Password").setIsDirty(bFlagNotDirty);
                break;
            }
            case 4: {
                objToReturn.setTitle(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Title").setIsDirty(bFlagNotDirty);
                break;
            }
            case 5: {
                objToReturn.setGivenName(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("GivenName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 6: {
                objToReturn.setMiddleName(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("MiddleName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 7: {
                objToReturn.setFamilyName(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("FamilyName").setIsDirty(bFlagNotDirty);
                break;
            }
            case 8: {
                objToReturn.setHomePhone1(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("HomePhone1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 9: {
                objToReturn.setHomeFax(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("HomeFax").setIsDirty(bFlagNotDirty);
                break;
            }
            case 10: {
                objToReturn.setMobilePhone(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("MobilePhone").setIsDirty(bFlagNotDirty);
                break;
            }
            case 11: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowAddContactInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowAddContactInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 12: {
                objToReturn.setEmailAddress(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Email").setIsDirty(bFlagNotDirty);
                break;
            }
            case 13: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowEmailInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowEmailInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 14: {
                objToReturn.setBirthDate(this._cvUtility.stringToCalendar(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("BirthDate").setIsDirty(bFlagNotDirty);
                break;
            }
            case 15: {
                objToReturn.setStreet1(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Street1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 16: {
                objToReturn.setStreet2(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Street2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 17: {
                objToReturn.setCity(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("City").setIsDirty(bFlagNotDirty);
                break;
            }
            case 18: {
                objToReturn.setState(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("State").setIsDirty(bFlagNotDirty);
                break;
            }
            case 19: {
                objToReturn.setZipCode(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("ZipCode").setIsDirty(bFlagNotDirty);
                break;
            }
            case 20: {
                objToReturn.setCountry(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("Country").setIsDirty(bFlagNotDirty);
                break;
            }
            case 21: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowAddressInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowAddressInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 22: {
                objToReturn.setCompany(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Company").setIsDirty(bFlagNotDirty);
                break;
            }
            case 23: {
                objToReturn.setDepartment(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("Department").setIsDirty(bFlagNotDirty);
                break;
            }
            case 24: {
                objToReturn.setJobTitle(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("JobTitle").setIsDirty(bFlagNotDirty);
                break;
            }
            case 25: {
                objToReturn.setBusinessPhone1(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("BusinessPhone1").setIsDirty(bFlagNotDirty);
                break;
            }
            case 26: {
                objToReturn.setBusinessFax(TextFormat.trimString((String)tmp, (int)50));
                _attribs.getBbAttribute("BusinessFax").setIsDirty(bFlagNotDirty);
                break;
            }
            case 27: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setShowWorkInfo(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("ShowWorkInfo").setIsDirty(bFlagNotDirty);
                break;
            }
            case 28: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsInfoPublic(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("IsInfoPublic").setIsDirty(bFlagNotDirty);
                break;
            }
            case 29: {
                objToReturn.setStudentId(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("StudentId").setIsDirty(bFlagNotDirty);
                break;
            }
            case 30: {
                if (this._authority.getConfigurationManager().isSOAPEnabled()) {
                    objToReturn.getBbAttributes().setString("StringPortalRole", tmp);
                    break;
                }
                objToReturn.setPortalRole(this._cvUtility.stringToInstitutionRole(tmp));
                _attribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagNotDirty);
                _attribs.getBbAttribute("PortalRole").setIsDirty(bFlagNotDirty);
                break;
            }
            case 31: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setRowStatus(this._cvUtility.stringToRowStatus(tmp));
                _attribs.getBbAttribute("RowStatus").setIsDirty(bFlagNotDirty);
                break;
            }
            case 32: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setGender(this._cvUtility.stringToGender(tmp));
                _attribs.getBbAttribute("Gender").setIsDirty(bFlagNotDirty);
                break;
            }
            case 33: {
                objToReturn.setBusinessPhone2(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("BusinessPhone2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 34: {
                objToReturn.setHomePhone2(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("HomePhone2").setIsDirty(bFlagNotDirty);
                break;
            }
            case 35: {
                objToReturn.setWebPage(TextFormat.trimString((String)tmp, (int)100));
                _attribs.getBbAttribute("WebPage").setIsDirty(bFlagNotDirty);
                break;
            }
            case 36: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setEducationLevel(this._cvUtility.stringToEducationLevel(tmp));
                _attribs.getBbAttribute("EducationLevel").setIsDirty(bFlagNotDirty);
                break;
            }
            case 37: {
                if (this.isTagEmpty(tmp)) {
                    return;
                }
                objToReturn.setIsAvailable(ConversionUtility.getBoolean(TextFormat.trimString((String)tmp, (int)-1)));
                _attribs.getBbAttribute("IsAvailable").setIsDirty(bFlagNotDirty);
                break;
            }
            case 38: {
                objToReturn.setDataSourceBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 39: {
                objToReturn.setSettings(TextFormat.trimString((String)tmp, (int)2000));
                _attribs.getBbAttribute("Settings").setIsDirty(bFlagNotDirty);
                break;
            }
            case 40: {
                objToReturn.setReplacementBatchUid(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagNotDirty);
                break;
            }
            case 41: {
                objToReturn.setLocale(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("Locale").setIsDirty(bFlagNotDirty);
                break;
            }
            case 42: {
                boolean bEncryptCard = ConversionUtility.getBoolean(this._authority.getConfigurationManager().getSetting("encrypt.card.number"));
                if (bEncryptCard && StringUtil.notEmpty((String)tmp) && !this._authority.getConfigurationManager().isSOAPEnabled()) {
                    try {
                        tmp = CardNumberCipher.getDefaultInstance().getEncryptedKey(tmp);
                    }
                    catch (Exception exc) {
                        this._authority.logWarning("", exc);
                        break;
                    }
                }
                objToReturn.setCardNumber(TextFormat.trimString((String)tmp, (int)-1));
                _attribs.getBbAttribute("CardNumber").setIsDirty(bFlagNotDirty);
            }
        }
    }

    protected void controlMaskInitialization() throws SnapshotException {
        String tmp = this._authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        if (tmp == null || this._authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            try {
                this._ovrMask.set(this.getLegacyPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException ioe) {
                // empty catch block
            }
            try {
                this._ovrMask.set(this.getPositionMapping().indexOf(txt.toLowerCase().trim()));
            }
            catch (IndexOutOfBoundsException io2) {}
        }
    }

    protected void parameterMappingInitialization() {
        int cnt;
        this._legacyPosMapping = new LinkedList();
        for (cnt = 0; cnt < _eeDataColumnList.length; ++cnt) {
            this._legacyPosMapping.addLast(_eeDataColumnList[cnt]);
        }
        this._posMapping = new LinkedList();
        for (cnt = 0; cnt < _bbDataColumnList.length; ++cnt) {
            this._posMapping.addLast(_bbDataColumnList[cnt]);
        }
        this._ovrMask = new BitSet(_bbDataColumnList.length);
    }
}

