/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.serialize.user;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.data.datasource.DataSource;
import blackboard.admin.data.user.Person;
import blackboard.admin.data.user.PersonXmlDef;
import blackboard.admin.snapshot.authority.Authority;
import blackboard.admin.snapshot.serialize.XmlHandler;
import blackboard.admin.snapshot.serialize.user.PersonDelimitedParser;
import blackboard.admin.snapshot.util.ConversionUtility;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.data.BbAttributes;
import blackboard.data.ValidationException;
import blackboard.data.role.PortalRole;
import blackboard.data.user.User;
import blackboard.persist.Id;
import blackboard.persist.role.PortalRoleDbLoader;
import blackboard.platform.BbServiceManager;
import blackboard.util.StringUtil;
import blackboard.xml.XmlUtil;
import com.blackboard.cas.security.crypto.CardNumberCipher;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;

public class PersonXmlHandler
extends XmlHandler
implements PersonXmlDef {
    public static final String XML_REGISTRY = "person";
    static final String CONTROLLED_SETTINGS = "person.bb.controlled.fields";
    private Person _obj;
    private Map<String, String> _ovrMap = new HashMap<String, String>();
    private Map<String, String> _encounteredElements = new HashMap<String, String>();
    private String _activeElement;
    private Attributes _activeAttributes;
    private BbAttributes _bbAttribs;
    private boolean _bEncrypt;

    public void init(Authority authority) {
        super.init(authority);
        String tmp = authority.getConfigurationManager().getSetting(CONTROLLED_SETTINGS);
        this._bEncrypt = ConversionUtility.getBoolean(authority.getConfigurationManager().getSetting("encrypt.password"));
        if (tmp == null || authority.getConfigurationManager().isSOAPEnabled()) {
            return;
        }
        StringTokenizer tkn = new StringTokenizer(tmp, ",");
        while (tkn.hasMoreElements()) {
            String txt = (String)tkn.nextElement();
            this._ovrMap.put(txt.toLowerCase(), "ignore");
        }
        this.initDelimitedXmlMapping();
    }

    private void initDelimitedXmlMapping() {
        this.handleDelimitedArrayXmlMapping(PersonDelimitedParser._bbDataColumnList);
        this.handleDelimitedArrayXmlMapping(PersonDelimitedParser._eeDataColumnList);
    }

    private void handleDelimitedArrayXmlMapping(String[] elementList) {
        block44: for (int cnt = 0; cnt < elementList.length; ++cnt) {
            String value = elementList[cnt];
            if (value == null || value.length() == 0 || !this._ovrMap.containsKey(value.toLowerCase())) continue;
            switch (cnt) {
                case 0: {
                    this._ovrMap.put("systemrole", "ignore");
                    continue block44;
                }
                case 1: {
                    this._ovrMap.put("id", "ignore");
                    continue block44;
                }
                case 2: {
                    this._ovrMap.put("userid", "ignore");
                    continue block44;
                }
                case 3: {
                    this._ovrMap.put("password", "ignore");
                    continue block44;
                }
                case 4: {
                    this._ovrMap.put("prefix", "ignore");
                    continue block44;
                }
                case 5: {
                    this._ovrMap.put("given", "ignore");
                    continue block44;
                }
                case 6: {
                    this._ovrMap.put("other", "ignore");
                    continue block44;
                }
                case 7: {
                    this._ovrMap.put("family", "ignore");
                    continue block44;
                }
                case 8: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 9: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 10: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 11: {
                    this._ovrMap.put("x_bb_contact_indicator", "ignore");
                    continue block44;
                }
                case 12: {
                    this._ovrMap.put("email", "ignore");
                    continue block44;
                }
                case 13: {
                    this._ovrMap.put("x_bb_email_indicator", "ignore");
                    continue block44;
                }
                case 14: {
                    this._ovrMap.put("bday", "ignore");
                    continue block44;
                }
                case 15: {
                    this._ovrMap.put("street", "ignore");
                    continue block44;
                }
                case 16: {
                    this._ovrMap.put("street", "ignore");
                    continue block44;
                }
                case 17: {
                    this._ovrMap.put("locality", "ignore");
                    continue block44;
                }
                case 18: {
                    this._ovrMap.put("region", "ignore");
                    continue block44;
                }
                case 19: {
                    this._ovrMap.put("pcode", "ignore");
                    continue block44;
                }
                case 20: {
                    this._ovrMap.put("country", "ignore");
                    continue block44;
                }
                case 21: {
                    this._ovrMap.put("x_bb_address_indicator", "ignore");
                    continue block44;
                }
                case 22: {
                    this._ovrMap.put("x_bb_company", "ignore");
                    continue block44;
                }
                case 23: {
                    this._ovrMap.put("x_bb_company_department", "ignore");
                    continue block44;
                }
                case 24: {
                    this._ovrMap.put("x_bb_job_title", "ignore");
                    continue block44;
                }
                case 25: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 26: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 27: {
                    this._ovrMap.put("x_bb_work_indicator", "ignore");
                    continue block44;
                }
                case 28: {
                    this._ovrMap.put("x_bb_public_indicator", "ignore");
                    continue block44;
                }
                case 29: {
                    this._ovrMap.put("x_bb_studentid", "ignore");
                    continue block44;
                }
                case 30: {
                    this._ovrMap.put("institutionrole", "ignore");
                    continue block44;
                }
                case 31: {
                    this._ovrMap.put("x_bb_row_status", "ignore");
                    continue block44;
                }
                case 32: {
                    this._ovrMap.put("gender", "ignore");
                    continue block44;
                }
                case 33: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 34: {
                    this._ovrMap.put("tel", "ignore");
                    continue block44;
                }
                case 35: {
                    this._ovrMap.put("x_bb_webpage", "ignore");
                    continue block44;
                }
                case 36: {
                    this._ovrMap.put("x_bb_education_level", "ignore");
                    continue block44;
                }
                case 37: {
                    this._ovrMap.put("x_bb_available", "ignore");
                    continue block44;
                }
                case 38: {
                    this._ovrMap.put("x_bb_datasource_key", "ignore");
                    continue block44;
                }
                case 39: {
                    this._ovrMap.put("x_bb_settings", "ignore");
                    continue block44;
                }
                case 40: {
                    this._ovrMap.put("x_bb_replacementkey", "ignore");
                    continue block44;
                }
                case 42: {
                    this._ovrMap.put("x_bb_card_number", "ignore");
                }
            }
        }
    }

    public void startElement(String uri, String localName, String name, Attributes atts) {
        boolean bDirtyFlag;
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            this._obj = new Person();
            this._bbAttribs = this._obj.getBbAttributes();
            String recStatus = XmlUtil.getAttributeValue((Attributes)atts, (String)"recstatus", (String)"4");
            this._obj.setRecStatus((IAdminObject.RecStatus)IAdminObject.RecStatus.fromFieldName((String)recStatus, IAdminObject.RecStatus.class));
            return;
        }
        this._activeElement = name.toLowerCase();
        this._activeAttributes = atts;
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey("systemrole");
        if (this.unMarshallSystemRoleNode(bDirtyFlag)) {
            return;
        }
        if (this.unMarshallInstitutionRoleNode(bDirtyFlag)) {
            return;
        }
        boolean bl2 = bDirtyFlag = !this._ovrMap.containsKey("password");
        if (this.unMarshallUserIdAttributes(bDirtyFlag)) {
            return;
        }
    }

    public void characters(char[] ch, int start, int length) {
        boolean bDirtyFlag;
        if (this._activeElement == null) {
            return;
        }
        String value = super.updateCharacterBuffer(ch, start, length).trim();
        boolean bl = bDirtyFlag = !this._ovrMap.containsKey(this._activeElement);
        if (this.unMarshallSourceIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallUserIdNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallNameNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallDemographicsNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallEmailNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallTelephoneNodes(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallAddressNode(value, bDirtyFlag)) {
            return;
        }
        if (this.unMarshallExtensionNode(value, bDirtyFlag)) {
            return;
        }
    }

    public IAdminObject endElement(String uri, String local, String name) {
        super.endElement(uri, local, name);
        if (name.equalsIgnoreCase("adr")) {
            this._encounteredElements.put(name, "1");
        }
        if (name.equalsIgnoreCase(XML_REGISTRY)) {
            return this._obj;
        }
        return null;
    }

    public void release() {
        this._obj = null;
        this._encounteredElements.clear();
    }

    protected boolean unMarshallSourceIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("id")) {
            this._obj.setBatchUid(value);
            this._bbAttribs.getBbAttribute("BatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("source")) {
            this._obj.setSourcedidSource(value);
            this._bbAttribs.getBbAttribute("source").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallUserIdNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("userid")) {
            if (value != null && value.length() > 0) {
                this._obj.setUserName(value);
                this._bbAttribs.getBbAttribute("UserName").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallUserIdAttributes(boolean bDirtyFlag) {
        if (this._activeElement.equalsIgnoreCase("userid")) {
            String pwd = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"password", (String)"");
            if (pwd.length() > 0) {
                String encrypt = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"pwencryptiontype", (String)"");
                if (encrypt.equalsIgnoreCase("clear")) {
                    pwd = ConversionUtility.getHashValue(pwd);
                }
                this._obj.setPassword(pwd);
                this._bbAttribs.getBbAttribute("Password").setIsDirty(bDirtyFlag);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallNameNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("family")) {
            this._obj.setFamilyName(value);
            this._bbAttribs.getBbAttribute("FamilyName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("given")) {
            this._obj.setGivenName(value);
            this._bbAttribs.getBbAttribute("GivenName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("other")) {
            this._obj.setMiddleName(value);
            this._bbAttribs.getBbAttribute("MiddleName").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("prefix")) {
            this._obj.setTitle(value);
            this._bbAttribs.getBbAttribute("Title").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallDemographicsNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("gender")) {
            this._obj.setGender(this._cvUtility.intToGender(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("Gender").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("bday")) {
            this._obj.setBirthDate(TimeFormat.stringToCalendar(value, "yyyy-MM-dd"));
            this._bbAttribs.getBbAttribute("BirthDate").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallEmailNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("email")) {
            this._obj.setEmailAddress(value);
            this._bbAttribs.getBbAttribute("Email").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    protected boolean unMarshallTelephoneNodes(String value, boolean bFlagDirty) {
        if (!this._activeElement.equalsIgnoreCase("tel")) {
            return false;
        }
        if (this._activeAttributes == null || this._activeAttributes.getLength() == 0) {
            return true;
        }
        this.unMarshallTelephoneNode(value, XmlUtil.parseInteger((String)this._activeAttributes.getValue(0)), bFlagDirty);
        return true;
    }

    protected boolean unMarshallSystemRoleNode(boolean bFlagDirty) {
        String value = null;
        if (this._obj == null) {
            return false;
        }
        if (this._activeElement.equalsIgnoreCase("systemrole")) {
            value = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"systemroletype", (String)"");
            if (value.length() > 0) {
                try {
                    User.SystemRole role = this._cvUtility.stringToSystemRole(value);
                    if (role != null) {
                        this._obj.setSystemRole(role);
                    } else {
                        this._obj.setSystemRoleIdentifier(value);
                    }
                }
                catch (ValidationException ve) {
                    this._obj.setSystemRole(User.SystemRole.DEFAULT);
                }
                this._bbAttribs.getBbAttribute("SystemRole").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallInstitutionRoleNode(boolean bFlagDirty) {
        if (this._obj == null) {
            return false;
        }
        if (this._activeElement.equalsIgnoreCase("institutionrole")) {
            String value = XmlUtil.getAttributeValue((Attributes)this._activeAttributes, (String)"primaryrole", (String)"");
            this.updateInstitutionRole(value);
            this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
            this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            return true;
        }
        return false;
    }

    private void updateInstitutionRole(String szRole) {
        if (this._obj == null || StringUtil.isEmpty((String)szRole)) {
            return;
        }
        PortalRole role = null;
        if (this._authority.getConfigurationManager().isSOAPEnabled()) {
            this._obj.getBbAttributes().setString("StringPortalRole", szRole);
            return;
        }
        try {
            role = this._cvUtility.stringToInstitutionRole(szRole);
        }
        catch (ValidationException ve) {
            try {
                role = PortalRoleDbLoader.Default.getInstance().loadDefault();
            }
            catch (Exception e) {
                this._authority.logWarning("", e);
            }
        }
        this._obj.setPortalRole(role);
    }

    private void unMarshallTelephoneNode(String value, int att, boolean bFlagDirty) {
        switch (att) {
            case 0: {
                this._obj.setHomePhone1(value);
                this._bbAttribs.getBbAttribute("HomePhone1").setIsDirty(bFlagDirty);
                break;
            }
            case 1: {
                this._obj.setHomeFax(value);
                this._bbAttribs.getBbAttribute("HomeFax").setIsDirty(bFlagDirty);
                break;
            }
            case 2: {
                this._obj.setBusinessPhone1(value);
                this._bbAttribs.getBbAttribute("BusinessPhone1").setIsDirty(bFlagDirty);
                break;
            }
            case 3: {
                this._obj.setBusinessFax(value);
                this._bbAttribs.getBbAttribute("BusinessFax").setIsDirty(bFlagDirty);
                break;
            }
            case 4: {
                this._obj.setMobilePhone(value);
                this._bbAttribs.getBbAttribute("MobilePhone").setIsDirty(bFlagDirty);
                break;
            }
            case 5: {
                this._obj.setHomePhone2(value);
                this._bbAttribs.getBbAttribute("HomePhone2").setIsDirty(bFlagDirty);
                break;
            }
            case 6: {
                this._obj.setBusinessPhone2(value);
                this._bbAttribs.getBbAttribute("BusinessPhone2").setIsDirty(bFlagDirty);
            }
        }
    }

    protected boolean unMarshallAddressNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("street")) {
            String streets = this._encounteredElements.get("street");
            int numStreets = 1;
            if (streets != null) {
                numStreets = Integer.parseInt(streets);
            }
            if (numStreets == 1) {
                this._obj.setStreet1(value);
                this._bbAttribs.getBbAttribute("Street1").setIsDirty(bFlagDirty);
            } else if (numStreets == 2) {
                this._obj.setStreet2(value);
                this._bbAttribs.getBbAttribute("Street2").setIsDirty(bFlagDirty);
            }
            this._encounteredElements.put("street", String.valueOf(++numStreets));
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("locality")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setCity(value);
                this._bbAttribs.getBbAttribute("City").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("region")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setState(value);
                this._bbAttribs.getBbAttribute("State").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("pcode")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setZipCode(value);
                this._bbAttribs.getBbAttribute("ZipCode").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("country")) {
            if (!this._encounteredElements.containsKey("adr")) {
                this._obj.setCountry(value);
                this._bbAttribs.getBbAttribute("Country").setIsDirty(bFlagDirty);
            }
            return true;
        }
        return false;
    }

    protected boolean unMarshallExtensionNode(String value, boolean bFlagDirty) {
        if (this._activeElement.equalsIgnoreCase("x_bb_address_indicator")) {
            this._obj.setShowAddressInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowAddressInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_available")) {
            this._obj.setIsAvailable(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsAvailable").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_company")) {
            this._obj.setCompany(value);
            this._bbAttribs.getBbAttribute("Company").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_contact_indicator")) {
            this._obj.setShowAddContactInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowAddContactInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_company_department")) {
            this._obj.setDepartment(value);
            this._bbAttribs.getBbAttribute("Department").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_datasource_key")) {
            this._obj.setDataSourceBatchUid(value);
            this._bbAttribs.getBbAttribute("DataSourceBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_education_level")) {
            try {
                this._obj.setEducationLevel(this._cvUtility.stringToEducationLevel(value));
            }
            catch (ValidationException ve) {
                this._obj.setEducationLevel(User.EducationLevel.DEFAULT);
            }
            this._bbAttribs.getBbAttribute("EducationLevel").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_email_indicator")) {
            this._obj.setShowEmailInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowEmailInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_institution_role")) {
            String szRole = this._cvUtility.intToInstitutionRoleSz(XmlUtil.parseInteger((String)value));
            this.updateInstitutionRole(szRole);
            this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
            this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_job_title")) {
            this._obj.setJobTitle(value);
            this._bbAttribs.getBbAttribute("JobTitle").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_password")) {
            if (this._bEncrypt) {
                value = ConversionUtility.getHashValue(value);
            }
            this._obj.setPassword(value);
            this._bbAttribs.getBbAttribute("Password").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_public_indicator")) {
            this._obj.setIsInfoPublic(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("IsInfoPublic").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_replacementkey")) {
            this._obj.setReplacementBatchUid(value);
            this._bbAttribs.getBbAttribute("ReplacementBatchUid").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_row_status")) {
            this._obj.setRowStatus(this._cvUtility.intToRowStatus(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("RowStatus").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_settings")) {
            this._obj.setSettings(value);
            this._bbAttribs.getBbAttribute("Settings").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_systemrole")) {
            this._obj.setSystemRole(this._cvUtility.intToSystemRole(XmlUtil.parseInteger((String)value)));
            this._bbAttribs.getBbAttribute("SystemRole").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_studentid")) {
            this._obj.setStudentId(value);
            this._bbAttribs.getBbAttribute("StudentId").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_webpage")) {
            this._obj.setWebPage(value);
            this._bbAttribs.getBbAttribute("WebPage").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_embedded_source")) {
            this._obj.getBbAttributes().setString("embed", value);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_portalrole")) {
            if (this._authority.getConfigurationManager().isSOAPEnabled()) {
                this._obj.getBbAttributes().setString("StringPortalRole", value);
            } else {
                this.updateInstitutionRole(value);
                this._bbAttribs.getBbAttribute("PortalRoleId").setIsDirty(bFlagDirty);
                this._bbAttribs.getBbAttribute("PortalRole").setIsDirty(bFlagDirty);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_work_indicator")) {
            this._obj.setShowWorkInfo(ConversionUtility.getBoolean(value));
            this._bbAttribs.getBbAttribute("ShowWorkInfo").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_locale")) {
            this._obj.setLocale(value);
            this._bbAttribs.getBbAttribute("Locale").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_card_number")) {
            boolean bEncryptCard = ConversionUtility.getBoolean(this._authority.getConfigurationManager().getSetting("encrypt.card.number"));
            if (bEncryptCard && StringUtil.notEmpty((String)value) && !this._authority.getConfigurationManager().isSOAPEnabled()) {
                try {
                    value = CardNumberCipher.getDefaultInstance().getEncryptedKey(value);
                }
                catch (Exception exc) {
                    this._authority.logWarning("", exc);
                    return true;
                }
            }
            this._obj.setCardNumber(value);
            this._bbAttribs.getBbAttribute("CardNumber").setIsDirty(bFlagDirty);
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_data_source_id")) {
            try {
                this._bbAttribs.setId("DataSourceId", BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(DataSource.DATA_TYPE, value));
            }
            catch (Exception exc) {
                this._bbAttribs.setId("DataSourceId", Id.UNSET_ID);
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_internal_id")) {
            try {
                this._obj.setId(BbServiceManager.getPersistenceService().getDbPersistenceManager().generateId(this._obj.getDataType(), value));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        if (this._activeElement.equalsIgnoreCase("x_bb_lmsintegration_role")) {
            this._bbAttribs.setString("LmsIntegrationRole", this._cvUtility.intToSystemRole(XmlUtil.parseInteger((String)value)).getIdentifier());
            return true;
        }
        return false;
    }
}

