/*
 * Decompiled with CFR 0.152.
 */
package blackboard.admin.snapshot.util;

import blackboard.admin.data.IAdminObject;
import blackboard.admin.persist.impl.mapping.AdminObjectDbMap;
import blackboard.admin.snapshot.config.ConfigurationManager;
import blackboard.admin.snapshot.persist.Results;
import blackboard.admin.snapshot.util.TimeFormat;
import blackboard.base.BbEnum;
import blackboard.data.ValidationException;
import blackboard.data.ValidationWarning;
import blackboard.data.course.Course;
import blackboard.data.course.CourseMembership;
import blackboard.data.role.PortalRole;
import blackboard.data.user.User;
import blackboard.persist.Id;
import blackboard.persist.KeyNotFoundException;
import blackboard.persist.PersistenceException;
import blackboard.persist.impl.mapping.DbBbEnumMapping;
import blackboard.persist.role.PortalRoleDbLoader;
import blackboard.platform.security.SecurityUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConversionUtility {
    public static final int ENUM_SYSTEM_ADMINISTRATOR = 0;
    public static final int ENUM_SYSTEM_SUPPORT = 1;
    public static final int ENUM_COURSE_CREATOR = 2;
    public static final int ENUM_ACCOUNT_ADMINISTRATOR = 3;
    public static final int ENUM_NONE = 4;
    public static final int ENUM_COURSE_SUPPORT = 5;
    public static final int ENUM_USER = 6;
    public static final int ENUM_SYSTEM_OBSERVER = 7;
    public static final int ENUM_SYSTEM_GUEST = 8;
    public static final int ENUM_INTEGRATION = 9;
    public static final int ENUM_PORTAL = 10;
    public static final int ENUM_ECOMMERCE_ADMIN = 11;
    public static final int ENUM_CARD_OFFICE_ADMIN = 12;
    public static final int ENUM_STORE_ADMIN = 13;
    public static final int ENUM_LMS_INTEGRATION_ADMIN = 14;
    public static final int ENUM_STUDENT = 0;
    public static final int ENUM_FACULTY = 1;
    public static final int ENUM_STAFF = 2;
    public static final int ENUM_ALUMNI = 3;
    public static final int ENUM_PROSPECTIVE_STUDENT = 4;
    public static final int ENUM_INST_GUEST = 5;
    public static final int ENUM_OTHER = 6;
    public static final int ENUM_INST_OBSERVER = 7;
    public static final int ENUM_ROLE_9 = 9;
    public static final int ENUM_ROLE_10 = 10;
    public static final int ENUM_ROLE_11 = 11;
    public static final int ENUM_ROLE_12 = 12;
    public static final int ENUM_ROLE_13 = 13;
    public static final int ENUM_ROLE_14 = 14;
    public static final int ENUM_ROLE_15 = 15;
    public static final int ENUM_ROLE_16 = 16;
    public static final int ENUM_ROLE_17 = 17;
    public static final int ENUM_ROLE_18 = 18;
    public static final int ENUM_ROLE_19 = 19;
    public static final int ENUM_ROLE_20 = 20;
    public static final int ENUM_NOT_DISCLOSED = 0;
    public static final int ENUM_FEMALE = 1;
    public static final int ENUM_MALE = 2;
    public static final int ENUM_CONTINUOUS = 0;
    public static final int ENUM_DATE_RANGE = 1;
    public static final int ENUM_FIXED_NUM_DAYS = 2;
    public static final int ENUM_INSTRUCTOR_LED = 0;
    public static final int ENUM_SELF_PACED = 1;
    public static final int ENUM_INSTRUCTOR_LED_ENROLLMENT = 0;
    public static final int ENUM_SELF_ENROLLMENT = 1;
    public static final int ENUM_EMAIL_ENROLLMENT = 2;
    public static final int ENUM_FULL = 0;
    public static final int ENUM_COMMUNITY = 1;
    public static final int ENUM_REGISTERED = 2;
    public static final int ENUM_TEST_DRIVE = 3;
    public static final int ENUM_NONE_CODE = 0;
    public static final int ENUM_STUDENT_CODE = 1;
    public static final int ENUM_INSTRUCTOR_CODE = 2;
    public static final int ENUM_COURSE_BUILDER_CODE = 3;
    public static final int ENUM_TEACHING_ASSISTANT_CODE = 6;
    public static final int ENUM_GRADER_CODE = 8;
    public static final int ENUM_GUEST_CODE = 9;
    private Map<String, Course.ServiceLevel> serviceLevelMapping;
    private Map<String, Course.Duration> durationMapping;
    private Map<String, Course.Pace> paceMapping;
    private Map<String, Course.Enrollment> enrollmentMapping;
    private Map<String, CourseMembership.Role> courseRoleMapping;
    private Map<String, User.SystemRole> systemRoleMapping;
    private Map<User.SystemRole, String> systemRoleSZMapping;
    private Map<String, User.Gender> genderMapping;
    private Map<String, User.EducationLevel> educationLevelMapping;
    private Map<User.EducationLevel, String> educationLevelSZMapping;
    private Map<String, User.InstRole> institutionRoleMapping;
    private Map<String, Course.NavStyle> navStyleMapping;
    private Map<String, IAdminObject.RowStatus> rowStatusMapping;
    public static final String HASH_ALGORITHM = "MD5";
    private ConfigurationManager _cfgMgr;

    public ConversionUtility(ConfigurationManager cfgMgr) {
        this._cfgMgr = cfgMgr;
        this.loadDefaultValues();
    }

    public ConversionUtility() {
        this._cfgMgr = ConfigurationManager.getInstance(new Properties());
        this.loadDefaultValues();
    }

    public static boolean getBoolean(String val) {
        return val != null && val.length() != 0 && !val.equalsIgnoreCase("0") && !val.equalsIgnoreCase("N") && !val.equalsIgnoreCase("false");
    }

    public static String booleanToYN(boolean val) {
        if (val) {
            return "y";
        }
        return "n";
    }

    public static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public final int integerToInt(Integer val) {
        if (val == null) {
            return 0;
        }
        return val;
    }

    public User.SystemRole intToSystemRole(int nType) {
        switch (nType) {
            case 3: {
                return User.SystemRole.ACCOUNT_ADMIN;
            }
            case 2: {
                return User.SystemRole.COURSE_CREATOR;
            }
            case 5: {
                return User.SystemRole.COURSE_SUPPORT;
            }
            case 8: {
                return User.SystemRole.GUEST;
            }
            case 9: {
                return User.SystemRole.INTEGRATION;
            }
            case 4: {
                return User.SystemRole.NONE;
            }
            case 7: {
                return User.SystemRole.OBSERVER;
            }
            case 10: {
                return User.SystemRole.PORTAL;
            }
            case 0: {
                return User.SystemRole.SYSTEM_ADMIN;
            }
            case 1: {
                return User.SystemRole.SYSTEM_SUPPORT;
            }
            case 6: {
                return User.SystemRole.USER;
            }
            case 11: {
                return User.SystemRole.ECOMMERCE_ADMIN;
            }
            case 12: {
                return User.SystemRole.CARD_OFFICE_ADMIN;
            }
            case 13: {
                return User.SystemRole.STORE_ADMIN;
            }
            case 14: {
                return User.SystemRole.LMS_INTEGRATION_ADMIN;
            }
        }
        return User.SystemRole.DEFAULT;
    }

    public String intToInstitutionRoleSz(int nType) {
        switch (nType) {
            case 3: {
                return "ALUMNI";
            }
            case 1: {
                return "FACULTY";
            }
            case 5: {
                return "GUEST";
            }
            case 6: {
                return "OTHER";
            }
            case 4: {
                return "PROSPECTIVE_STUDENT";
            }
            case 2: {
                return "STAFF";
            }
            case 0: {
                return "STUDENT";
            }
            case 7: {
                return "OBSERVER";
            }
            case 9: {
                return "ROLE_9";
            }
            case 10: {
                return "ROLE_10";
            }
            case 11: {
                return "ROLE_11";
            }
            case 12: {
                return "ROLE_12";
            }
            case 13: {
                return "ROLE_13";
            }
            case 14: {
                return "ROLE_14";
            }
            case 15: {
                return "ROLE_15";
            }
            case 16: {
                return "ROLE_16";
            }
            case 17: {
                return "ROLE_17";
            }
            case 18: {
                return "ROLE_18";
            }
            case 19: {
                return "ROLE_19";
            }
            case 20: {
                return "ROLE_20";
            }
        }
        return "STUDENT";
    }

    public User.Gender intToGender(int nType) {
        switch (nType) {
            case 1: {
                return User.Gender.FEMALE;
            }
            case 2: {
                return User.Gender.MALE;
            }
            case 0: {
                return User.Gender.UNKNOWN;
            }
        }
        return User.Gender.DEFAULT;
    }

    public User.Gender stringToGender(String key) throws ValidationException {
        User.Gender val = this.genderMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "Gender";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = User.Gender.DEFAULT;
        }
        return val;
    }

    public static int genderToInt(User.Gender gender) {
        if (gender == User.Gender.FEMALE) {
            return 1;
        }
        if (gender == User.Gender.MALE) {
            return 2;
        }
        return 0;
    }

    public Course.Duration intToDuration(int nType) {
        switch (nType) {
            case 0: {
                return Course.Duration.CONTINUOUS;
            }
            case 1: {
                return Course.Duration.DATE_RANGE;
            }
            case 2: {
                return Course.Duration.FIXED_NUM_DAYS;
            }
        }
        return Course.Duration.DEFAULT;
    }

    public Course.Pace intToPace(int nType) {
        switch (nType) {
            case 0: {
                return Course.Pace.INSTRUCTOR_LED;
            }
            case 1: {
                return Course.Pace.SELF_PACED;
            }
        }
        return Course.Pace.DEFAULT;
    }

    public static int paceToInt(Course.Pace val) {
        if (val == Course.Pace.INSTRUCTOR_LED) {
            return 0;
        }
        if (val == Course.Pace.SELF_PACED) {
            return 1;
        }
        return 0;
    }

    public static int durationToInt(Course.Duration val) {
        if (val == Course.Duration.CONTINUOUS) {
            return 0;
        }
        if (val == Course.Duration.DATE_RANGE) {
            return 1;
        }
        if (val == Course.Duration.FIXED_NUM_DAYS) {
            return 2;
        }
        return 0;
    }

    public static int enrollmentTypeToInt(Course.Enrollment val) {
        if (val == Course.Enrollment.INSTRUCTOR_LED) {
            return 0;
        }
        if (val == Course.Enrollment.SELF_ENROLLMENT) {
            return 1;
        }
        if (val == Course.Enrollment.EMAIL_ENROLLMENT) {
            return 2;
        }
        return 0;
    }

    public Course.Enrollment intToEnrollment(int nType) {
        switch (nType) {
            case 0: {
                return Course.Enrollment.INSTRUCTOR_LED;
            }
            case 1: {
                return Course.Enrollment.SELF_ENROLLMENT;
            }
            case 2: {
                return Course.Enrollment.EMAIL_ENROLLMENT;
            }
        }
        return Course.Enrollment.DEFAULT;
    }

    public Course.ServiceLevel intToServiceLevel(int nType) {
        switch (nType) {
            case 1: {
                return Course.ServiceLevel.COMMUNITY;
            }
            case 0: {
                return Course.ServiceLevel.FULL;
            }
            case 2: {
                return Course.ServiceLevel.REGISTERED;
            }
            case 3: {
                return Course.ServiceLevel.TEST_DRIVE;
            }
        }
        return Course.ServiceLevel.DEFAULT;
    }

    public static int serviceLevelToInt(Course.ServiceLevel val) {
        if (val == Course.ServiceLevel.COMMUNITY) {
            return 1;
        }
        if (val == Course.ServiceLevel.FULL) {
            return 0;
        }
        if (val == Course.ServiceLevel.REGISTERED) {
            return 2;
        }
        if (val == Course.ServiceLevel.TEST_DRIVE) {
            return 3;
        }
        return 0;
    }

    public CourseMembership.Role intToCourseMembershipRole(int nType) {
        switch (nType) {
            case 2: {
                return CourseMembership.Role.INSTRUCTOR;
            }
            case 6: {
                return CourseMembership.Role.TEACHING_ASSISTANT;
            }
            case 3: {
                return CourseMembership.Role.COURSE_BUILDER;
            }
            case 8: {
                return CourseMembership.Role.GRADER;
            }
            case 1: {
                return CourseMembership.Role.STUDENT;
            }
            case 9: {
                return CourseMembership.Role.GUEST;
            }
            case 0: {
                return CourseMembership.Role.NONE;
            }
        }
        return CourseMembership.Role.DEFAULT;
    }

    public static int courseMembershipRoleToInt(CourseMembership.Role val) {
        if (val == CourseMembership.Role.INSTRUCTOR) {
            return 2;
        }
        if (val == CourseMembership.Role.TEACHING_ASSISTANT) {
            return 6;
        }
        if (val == CourseMembership.Role.COURSE_BUILDER) {
            return 3;
        }
        if (val == CourseMembership.Role.GRADER) {
            return 8;
        }
        if (val == CourseMembership.Role.STUDENT) {
            return 1;
        }
        if (val == CourseMembership.Role.GUEST) {
            return 9;
        }
        if (val == CourseMembership.Role.NONE) {
            return 0;
        }
        return 0;
    }

    public User.SystemRole stringToSystemRole(String key) throws ValidationException {
        return this.systemRoleMapping.get(this.prepKey(key));
    }

    public String systemRoleToString(User.SystemRole role) {
        String val = this.systemRoleSZMapping.get(role);
        if (val == null) {
            val = role.getIdentifier();
        }
        return val;
    }

    public User.EducationLevel stringToEducationLevel(String key) throws ValidationException {
        User.EducationLevel val = this.educationLevelMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "EducationLevel";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = User.EducationLevel.DEFAULT;
        }
        return val;
    }

    public String educationLevelToString(User.EducationLevel val) {
        String key = this.educationLevelSZMapping.get(val);
        if (key == null) {
            key = "";
        }
        return key;
    }

    public PortalRole stringToInstitutionRole(String key) throws ValidationException {
        PortalRole portalRole = null;
        key = this.prepKey(key);
        try {
            portalRole = PortalRoleDbLoader.Default.getInstance().loadByRoleId(key);
        }
        catch (KeyNotFoundException knfe) {
            User.InstRole val = this.institutionRoleMapping.get(key);
            try {
                portalRole = PortalRoleDbLoader.Default.getInstance().loadByRoleId(val.toFieldName());
            }
            catch (Exception e) {}
        }
        catch (PersistenceException pe) {
            // empty catch block
        }
        if (portalRole == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "PortalRoleId";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            try {
                portalRole = PortalRoleDbLoader.Default.getInstance().loadDefault();
            }
            catch (Exception e) {
                throw new ValidationException(ConfigurationManager.getGlobalLocaleExceptionMessage("db.load_default_portal_role.failure"));
            }
        }
        return portalRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String institutionRoleToString(Id portalRoleId) {
        String val = null;
        try {
            PortalRole portalRole = PortalRoleDbLoader.Default.getInstance().loadById(portalRoleId);
            val = portalRole.getRoleID();
        }
        catch (KeyNotFoundException knfe) {
            val = null;
        }
        catch (PersistenceException pe) {
            val = null;
        }
        finally {
            try {
                PortalRole defaultRole = PortalRoleDbLoader.Default.getInstance().loadDefault();
                val = defaultRole.getRoleID();
            }
            catch (Exception e) {
                val = null;
            }
        }
        return val;
    }

    private void registerUserMappingTables() {
        this.systemRoleMapping = new HashMap<String, User.SystemRole>();
        this.systemRoleSZMapping = new HashMap<User.SystemRole, String>();
        this.genderMapping = new HashMap<String, User.Gender>();
        this.educationLevelMapping = new HashMap<String, User.EducationLevel>();
        this.educationLevelSZMapping = new HashMap<User.EducationLevel, String>();
        this.institutionRoleMapping = new HashMap<String, User.InstRole>();
        this.systemRoleMapping.put("account_admin", User.SystemRole.ACCOUNT_ADMIN);
        this.systemRoleMapping.put("accountadmin", User.SystemRole.ACCOUNT_ADMIN);
        this.systemRoleMapping.put("user_admin", User.SystemRole.ACCOUNT_ADMIN);
        this.systemRoleMapping.put("course_creator", User.SystemRole.COURSE_CREATOR);
        this.systemRoleMapping.put("creator", User.SystemRole.COURSE_CREATOR);
        this.systemRoleMapping.put("course_support", User.SystemRole.COURSE_SUPPORT);
        this.systemRoleMapping.put("support", User.SystemRole.COURSE_SUPPORT);
        this.systemRoleMapping.put("guest", User.SystemRole.GUEST);
        this.systemRoleMapping.put("integration", User.SystemRole.INTEGRATION);
        this.systemRoleMapping.put("none", User.SystemRole.NONE);
        this.systemRoleMapping.put("observer", User.SystemRole.OBSERVER);
        this.systemRoleMapping.put("portal_admin", User.SystemRole.PORTAL);
        this.systemRoleMapping.put("portal", User.SystemRole.PORTAL);
        this.systemRoleMapping.put("sys_admin", User.SystemRole.SYSTEM_ADMIN);
        this.systemRoleMapping.put("sysadmin", User.SystemRole.SYSTEM_ADMIN);
        this.systemRoleMapping.put("system_admin", User.SystemRole.SYSTEM_ADMIN);
        this.systemRoleMapping.put("system_support", User.SystemRole.SYSTEM_SUPPORT);
        this.systemRoleMapping.put("syssupport", User.SystemRole.SYSTEM_SUPPORT);
        this.systemRoleMapping.put("user", User.SystemRole.USER);
        this.systemRoleMapping.put("ecommerce_admin", User.SystemRole.ECOMMERCE_ADMIN);
        this.systemRoleMapping.put("card_office_admin", User.SystemRole.CARD_OFFICE_ADMIN);
        this.systemRoleMapping.put("store_admin", User.SystemRole.STORE_ADMIN);
        this.systemRoleSZMapping.put(User.SystemRole.ACCOUNT_ADMIN, "accountadmin");
        this.systemRoleSZMapping.put(User.SystemRole.COURSE_SUPPORT, "course_support");
        this.systemRoleSZMapping.put(User.SystemRole.COURSE_CREATOR, "creator");
        this.systemRoleSZMapping.put(User.SystemRole.GUEST, "guest");
        this.systemRoleSZMapping.put(User.SystemRole.INTEGRATION, "integration");
        this.systemRoleSZMapping.put(User.SystemRole.NONE, "none");
        this.systemRoleSZMapping.put(User.SystemRole.OBSERVER, "observer");
        this.systemRoleSZMapping.put(User.SystemRole.PORTAL, "portal");
        this.systemRoleSZMapping.put(User.SystemRole.SYSTEM_ADMIN, "sysadmin");
        this.systemRoleSZMapping.put(User.SystemRole.SYSTEM_SUPPORT, "syssupport");
        this.systemRoleSZMapping.put(User.SystemRole.USER, "user");
        this.systemRoleSZMapping.put(User.SystemRole.ECOMMERCE_ADMIN, "ecommerce_admin");
        this.systemRoleSZMapping.put(User.SystemRole.CARD_OFFICE_ADMIN, "card_office_admin");
        this.systemRoleSZMapping.put(User.SystemRole.STORE_ADMIN, "store_admin");
        this.genderMapping.put("male", User.Gender.MALE);
        this.genderMapping.put("m", User.Gender.MALE);
        this.genderMapping.put("female", User.Gender.FEMALE);
        this.genderMapping.put("f", User.Gender.FEMALE);
        this.genderMapping.put("not disclosed", User.Gender.UNKNOWN);
        this.genderMapping.put("u", User.Gender.UNKNOWN);
        this.educationLevelMapping.put("k-8", User.EducationLevel.K_8);
        this.educationLevelMapping.put("high school", User.EducationLevel.HIGH_SCHOOL);
        this.educationLevelMapping.put("freshman", User.EducationLevel.FRESHMAN);
        this.educationLevelMapping.put("sophomore", User.EducationLevel.SOPHOMORE);
        this.educationLevelMapping.put("junior", User.EducationLevel.JUNIOR);
        this.educationLevelMapping.put("senior", User.EducationLevel.SENIOR);
        this.educationLevelMapping.put("graduate school", User.EducationLevel.GRADUATE_SCHOOL);
        this.educationLevelMapping.put("post-graduate school", User.EducationLevel.POST_GRADUATE_SCHOOL);
        this.educationLevelSZMapping.put(User.EducationLevel.K_8, "k-8");
        this.educationLevelSZMapping.put(User.EducationLevel.HIGH_SCHOOL, "high school");
        this.educationLevelSZMapping.put(User.EducationLevel.FRESHMAN, "freshman");
        this.educationLevelSZMapping.put(User.EducationLevel.SOPHOMORE, "sophomore");
        this.educationLevelSZMapping.put(User.EducationLevel.JUNIOR, "junior");
        this.educationLevelSZMapping.put(User.EducationLevel.SENIOR, "senior");
        this.educationLevelSZMapping.put(User.EducationLevel.GRADUATE_SCHOOL, "graduate school");
        this.educationLevelSZMapping.put(User.EducationLevel.POST_GRADUATE_SCHOOL, "post-graduate school");
        this.institutionRoleMapping.put("prospectivestudent", User.InstRole.PROSPECTIVE_STUDENT);
        this.institutionRoleMapping.put("prospective student", User.InstRole.PROSPECTIVE_STUDENT);
    }

    private void registerMembershipMappingTables() {
        this.courseRoleMapping = new HashMap<String, CourseMembership.Role>();
        this.courseRoleMapping.put("instructor", CourseMembership.Role.INSTRUCTOR);
        this.courseRoleMapping.put("teaching_assistant", CourseMembership.Role.TEACHING_ASSISTANT);
        this.courseRoleMapping.put("course_builder", CourseMembership.Role.COURSE_BUILDER);
        this.courseRoleMapping.put("grader", CourseMembership.Role.GRADER);
        this.courseRoleMapping.put("student", CourseMembership.Role.STUDENT);
        this.courseRoleMapping.put("guest", CourseMembership.Role.GUEST);
        this.courseRoleMapping.put("none", CourseMembership.Role.NONE);
    }

    public CourseMembership.Role stringToCourseRole(String key) throws ValidationException {
        CourseMembership.Role val = this.courseRoleMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "Role";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = CourseMembership.Role.DEFAULT;
        }
        return val;
    }

    public IAdminObject.RowStatus intToRowStatus(int val) {
        DbBbEnumMapping enumMapping = (DbBbEnumMapping)AdminObjectDbMap.MAP.getMapping("RowStatus");
        return (IAdminObject.RowStatus)enumMapping.stringToEnum(String.valueOf(val));
    }

    public static int rowStatusToInt(IAdminObject.RowStatus val) {
        DbBbEnumMapping enumMapping = (DbBbEnumMapping)AdminObjectDbMap.MAP.getMapping("RowStatus");
        return Integer.parseInt(enumMapping.enumToString((BbEnum)val));
    }

    public IAdminObject.RowStatus stringToRowStatus(String key) throws ValidationException {
        IAdminObject.RowStatus val = this.rowStatusMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "RowStatus";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = IAdminObject.RowStatus.DEFAULT;
        }
        return val;
    }

    private void registerRowStatusMappingTables() {
        this.rowStatusMapping = new HashMap<String, IAdminObject.RowStatus>();
        this.rowStatusMapping.put("enabled", IAdminObject.RowStatus.ENABLED);
        this.rowStatusMapping.put("disabled", IAdminObject.RowStatus.DISABLED);
        this.rowStatusMapping.put("deleted", IAdminObject.RowStatus.DELETE_PENDING);
        this.rowStatusMapping.put("copy_pending", IAdminObject.RowStatus.COPY_PENDING);
    }

    private void registerCourseMappingTables() {
        this.serviceLevelMapping = new HashMap<String, Course.ServiceLevel>();
        this.paceMapping = new HashMap<String, Course.Pace>();
        this.durationMapping = new HashMap<String, Course.Duration>();
        this.enrollmentMapping = new HashMap<String, Course.Enrollment>();
        this.navStyleMapping = new HashMap<String, Course.NavStyle>();
        this.navStyleMapping.put("text", Course.NavStyle.TEXT);
        this.navStyleMapping.put("button", Course.NavStyle.BUTTON);
        this.serviceLevelMapping.put("community", Course.ServiceLevel.COMMUNITY);
        this.serviceLevelMapping.put("course", Course.ServiceLevel.FULL);
        this.serviceLevelMapping.put("registered", Course.ServiceLevel.REGISTERED);
        this.serviceLevelMapping.put("test drive", Course.ServiceLevel.TEST_DRIVE);
        this.paceMapping.put("self", Course.Pace.SELF_PACED);
        this.paceMapping.put("instructor", Course.Pace.INSTRUCTOR_LED);
        this.durationMapping.put("continuous", Course.Duration.CONTINUOUS);
        this.durationMapping.put("range", Course.Duration.DATE_RANGE);
        this.durationMapping.put("fixed", Course.Duration.FIXED_NUM_DAYS);
        this.enrollmentMapping.put("self", Course.Enrollment.SELF_ENROLLMENT);
        this.enrollmentMapping.put("instructor", Course.Enrollment.INSTRUCTOR_LED);
        this.enrollmentMapping.put("email", Course.Enrollment.EMAIL_ENROLLMENT);
    }

    public Course.ServiceLevel stringToServiceLevel(String key) throws ValidationException {
        Course.ServiceLevel val = this.serviceLevelMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "ServiceLevelType";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = Course.ServiceLevel.DEFAULT;
        }
        return val;
    }

    public Course.Pace stringToPace(String key) throws ValidationException {
        Course.Pace val = this.paceMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "PaceType";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = Course.Pace.DEFAULT;
        }
        return val;
    }

    public Course.Duration stringToDuration(String key) throws ValidationException {
        Course.Duration val = this.durationMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "DurationType";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = Course.Duration.DEFAULT;
        }
        return val;
    }

    public Course.NavStyle stringToNavStyle(String key) throws ValidationException {
        Course.NavStyle val = this.navStyleMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "NavStyle";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = Course.NavStyle.DEFAULT;
        }
        return val;
    }

    private String prepKey(String key) {
        return key.trim().toLowerCase();
    }

    public Course.Enrollment stringToEnrollment(String key) throws ValidationException {
        Course.Enrollment val = this.enrollmentMapping.get(key = this.prepKey(key));
        if (val == null) {
            if (!ConversionUtility.getBoolean(this._cfgMgr.getSetting("parse.allow.default"))) {
                ValidationException ve = new ValidationException();
                String colName = "";
                Object[] args = new Object[]{colName};
                String cstr = ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.constraint");
                MessageFormat mf = new MessageFormat(ConfigurationManager.getGlobalLocaleExceptionMessage("data.validation.field"));
                colName = "EnrollmentType";
                args[0] = colName;
                ve.addWarning(new ValidationWarning(mf.format(args), cstr));
                throw ve;
            }
            val = Course.Enrollment.DEFAULT;
        }
        return val;
    }

    public static synchronized String getHashValue(String input) {
        return SecurityUtil.getHashValue((String)input);
    }

    public static void appendResults(Results src, Results tgt) {
        ArrayList aList = src.getList();
        for (Results.Error error : aList) {
            tgt.addError(error.getObject(), (PersistenceException)((Object)error.getException()));
        }
    }

    public Calendar stringToCalendar(String strCal) {
        Calendar cal = TimeFormat.stringToCalendar(strCal, "yyyyMMdd");
        if (cal == null) {
            cal = TimeFormat.stringToCalendar(strCal, "MM/dd/yyyy");
        }
        return cal;
    }

    private void loadDefaultValues() {
        this.registerCourseMappingTables();
        this.registerMembershipMappingTables();
        this.registerRowStatusMappingTables();
        this.registerUserMappingTables();
    }
}

