/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.cache;

import org.apache.log4j.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.NodeCreated;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeLoaded;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.annotation.NodeVisited;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jgroups.View;
import org.lamsfoundation.lams.cache.CacheManager;

@CacheListener
public class CacheDebugListener {
    protected Logger log = Logger.getLogger(CacheManager.class);
    private String cacheNameString = "Cache unknown: ";

    private void logMessage(String message) {
        this.log.info((Object)(this.cacheNameString + message));
    }

    @CacheStarted
    public void cacheStarted(Cache cache) {
        this.cacheNameString = "Cache " + cache.getVersion() + ": ";
        this.logMessage("started");
    }

    @CacheStopped
    public void cacheStopped(Cache cache) {
        this.logMessage("stopped");
    }

    @NodeCreated
    public void nodeCreated(Fqn fqn) {
        this.logMessage("node created " + fqn);
    }

    @NodeEvicted
    public void nodeEvicted(Fqn fqn) {
        this.logMessage("node evicted " + fqn);
    }

    @NodeLoaded
    public void nodeLoaded(Fqn fqn) {
        this.logMessage("node loaded " + fqn);
    }

    @NodeModified
    public void nodeModified(Fqn fqn) {
        this.logMessage("node modified " + fqn);
    }

    @NodeRemoved
    public void nodeRemoved(Fqn fqn) {
        this.logMessage("node removed " + fqn);
    }

    @NodeVisited
    public void nodeVisited(Fqn fqn) {
        this.logMessage("node visited " + fqn);
    }

    @ViewChanged
    public void viewChange(View new_view) {
        this.logMessage("view changed ");
    }
}

