/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.EventNotificationService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.Emailer;

public class DeliveryMethodMail
extends AbstractDeliveryMethod {
    private static DeliveryMethodMail instance;
    protected static final EmailValidator emailValidator;
    private static final Logger log;

    protected DeliveryMethodMail() {
        super((short)1, "MAIL", "Messages will be send by Mail");
    }

    @Override
    public String send(Integer fromUserId, Integer toUserId, String subject, String message, boolean isHtmlFormat) throws InvalidParameterException {
        if (toUserId == null) {
            log.error((Object)"Target user ID must not be null.");
        }
        try {
            String toEmail;
            User toUser = (User)EventNotificationService.getInstance().getUserManagementService().findById(User.class, toUserId);
            if (toUser == null) {
                log.error((Object)("Target user with ID " + toUserId + " was not found."));
            }
            if (!emailValidator.isValid(toEmail = toUser.getEmail())) {
                return "Target user's e-mail address is invalid.";
            }
            if (fromUserId == null) {
                Emailer.sendFromSupportEmail(subject, toEmail, message, isHtmlFormat);
            } else {
                String fromEmail;
                User fromUser = (User)EventNotificationService.getInstance().getUserManagementService().findById(User.class, toUserId);
                if (fromUser == null) {
                    log.error((Object)("Source user with ID " + toUserId + " was not found."));
                }
                if (!emailValidator.isValid(fromEmail = fromUser.getEmail())) {
                    return "Source user's e-mail address is invalid.";
                }
                Emailer.send(subject, toEmail, fromEmail, message, isHtmlFormat, new Properties());
            }
            return null;
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public static DeliveryMethodMail getInstance() {
        if (instance == null) {
            instance = new DeliveryMethodMail();
        }
        return instance;
    }

    void notifyAdmin(String subject, String body, boolean isHtmlFormat) throws AddressException, UnsupportedEncodingException, MessagingException {
        String adminEmail = Configuration.get(ConfigurationKeys.LAMS_ADMIN_EMAIL);
        if (StringUtils.isEmpty((String)adminEmail)) {
            log.warn((Object)("Could not notify admin as his email is blank. The subject: " + subject + ". The message: " + body));
        } else {
            Emailer.sendFromSupportEmail(subject, adminEmail, body, isHtmlFormat);
        }
    }

    static {
        emailValidator = EmailValidator.getInstance();
        log = Logger.getLogger(DeliveryMethodMail.class);
    }
}

