/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.BranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.BranchCondition;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.Group;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.ISystemToolActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.strategy.SequenceActivityStrategy;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.util.MessageService;

public class SequenceActivity
extends ComplexActivity
implements Serializable,
ISystemToolActivity {
    private static Logger log = Logger.getLogger(SequenceActivity.class);
    private Set branchEntries;
    private SystemTool systemTool;

    public SequenceActivity(Long activityId, Integer id, String description, String title, Integer xcoord, Integer ycoord, Integer orderId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, Activity libraryActivity, Integer parentUIID, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, String languageFile, Boolean stopAfterActivity, Set inputActivities, Set activities, Activity defaultActivity, Set branchEntries, SystemTool systemTool, Set branchActivityEntries) {
        super(activityId, id, description, title, xcoord, ycoord, orderId, defineLater, createDateTime, learningLibrary, parentActivity, libraryActivity, parentUIID, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, languageFile, stopAfterActivity, inputActivities, activities, defaultActivity, branchActivityEntries);
        this.activityStrategy = new SequenceActivityStrategy(this);
        this.branchEntries = branchEntries;
        this.systemTool = systemTool;
    }

    public SequenceActivity() {
        this.activityStrategy = new SequenceActivityStrategy(this);
    }

    public SequenceActivity(Long activityId, Boolean defineLater, Date createDateTime, LearningLibrary learningLibrary, Activity parentActivity, LearningDesign learningDesign, Grouping grouping, Integer activityTypeId, Transition transitionTo, Transition transitionFrom, SortedSet activities) {
        super(activityId, defineLater, createDateTime, learningLibrary, parentActivity, learningDesign, grouping, activityTypeId, transitionTo, transitionFrom, activities);
        this.activityStrategy = new SequenceActivityStrategy(this);
    }

    @Override
    public Activity createCopy(int uiidOffset) {
        SequenceActivity newSequenceActivity = new SequenceActivity();
        this.copyToNewComplexActivity(newSequenceActivity, uiidOffset);
        newSequenceActivity.defaultActivity = this.defaultActivity;
        newSequenceActivity.systemTool = this.systemTool;
        if (this.getBranchEntries() != null && this.getBranchEntries().size() > 0) {
            newSequenceActivity.setBranchEntries(new HashSet());
            for (BranchActivityEntry oldEntry : this.getBranchEntries()) {
                BranchActivityEntry newEntry = new BranchActivityEntry(null, LearningDesign.addOffset(oldEntry.getEntryUIID(), uiidOffset), newSequenceActivity, oldEntry.getBranchingActivity(), oldEntry.getGroup());
                if (oldEntry.getCondition() != null) {
                    BranchCondition newCondition = oldEntry.getCondition().clone(uiidOffset);
                    newEntry.setCondition(newCondition);
                }
                newSequenceActivity.getBranchEntries().add(newEntry);
            }
        }
        return newSequenceActivity;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append("activityId", (Object)this.getActivityId()).toString();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public SystemTool getSystemTool() {
        return this.systemTool;
    }

    @Override
    public void setSystemTool(SystemTool systemTool) {
        this.systemTool = systemTool;
    }

    public Set getBranchEntries() {
        return this.branchEntries;
    }

    public void setBranchEntries(Set branchEntries) {
        this.branchEntries = branchEntries;
    }

    public SortedSet<Group> getGroupsForBranch() {
        Set mappingEntries = this.getBranchEntries();
        TreeSet<Group> sortedGroups = new TreeSet<Group>();
        if (mappingEntries != null) {
            Iterator mappingIter = mappingEntries.iterator();
            while (mappingIter.hasNext()) {
                Group group = ((BranchActivityEntry)mappingIter.next()).getGroup();
                if (group == null) continue;
                sortedGroups.add(group);
            }
        }
        return sortedGroups;
    }

    public Group getSoleGroupForBranch() {
        Iterator iter;
        SortedSet<Group> groups = this.getGroupsForBranch();
        if (groups.size() > 1) {
            log.warn((Object)("Branch " + this + " has more than one group. This is unexpected. Using only the first group."));
        }
        if ((iter = groups.iterator()).hasNext()) {
            return (Group)iter.next();
        }
        return null;
    }

    public Vector validateActivity(MessageService messageService) {
        Vector<ValidationErrorDTO> listOfValidationErrors = new Vector<ValidationErrorDTO>();
        if (this.getActivities() != null && this.getActivities().size() > 0 && this.getDefaultActivity() == null) {
            listOfValidationErrors.add(new ValidationErrorDTO("SFA", messageService.getMessage("validation.error.sequenceActivityMustHaveFirstActivity"), this.getActivityUIID()));
        }
        return listOfValidationErrors;
    }

    public void removeGroupFromBranch(Group group) {
        if (this.getBranchEntries() != null) {
            Iterator iter = this.getBranchEntries().iterator();
            while (iter.hasNext()) {
                BranchActivityEntry object = (BranchActivityEntry)iter.next();
                if (!object.getGroup().equals(group)) continue;
                iter.remove();
            }
        }
    }
}

