/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.FloatingActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.util.MessageService;

public class LearningDesignValidator {
    MessageService messageService;
    LearningDesign learningDesign;
    Vector<ValidationErrorDTO> errors;

    LearningDesignValidator(LearningDesign learningDesign, MessageService messageService) {
        this.messageService = messageService;
        this.learningDesign = learningDesign;
    }

    public Vector<ValidationErrorDTO> validate() {
        this.errors = new Vector();
        if (this.learningDesign.getFirstActivity() == null) {
            this.errors.add(new ValidationErrorDTO("FIA", this.messageService.getMessage("validation.error.first.activity")));
        }
        Set<Activity> topLevelActivities = this.extractFloatingActivities(this.learningDesign.getParentActivities());
        this.validateActivityTransitionRules(topLevelActivities, this.learningDesign.getTransitions());
        for (Activity activity : this.learningDesign.getActivities()) {
            this.checkIfGroupingRequired(activity);
            this.validateGroupingIfGroupingIsApplied(activity);
            this.validateOptionalActivity(activity);
            this.validateOptionsActivityOrderId(activity);
            this.validateFloatingActivity(activity);
            this.validateGroupingActivity(activity);
            Vector<ValidationErrorDTO> activityErrors = activity.validateActivity(this.messageService);
            if (activityErrors == null || activityErrors.isEmpty()) continue;
            this.errors.addAll(activityErrors);
        }
        this.cleanupValidationErrors();
        return this.errors;
    }

    private Set<Activity> extractFloatingActivities(Set<Activity> topLevelActivities) {
        for (Activity activity : topLevelActivities) {
            if (!activity.isFloatingActivity()) continue;
            topLevelActivities.remove(activity);
            return topLevelActivities;
        }
        return topLevelActivities;
    }

    private void cleanupValidationErrors() {
        Iterator<ValidationErrorDTO> it = this.errors.iterator();
        while (it.hasNext()) {
            this.cleanupTransitionErrors(it);
        }
    }

    private void cleanupTransitionErrors(Iterator topIt) {
        ValidationErrorDTO currentError = (ValidationErrorDTO)topIt.next();
        Iterator<ValidationErrorDTO> it = this.errors.iterator();
        while (it.hasNext()) {
            ValidationErrorDTO nextError = it.next();
            if (!currentError.getCode().equals("AT") || !nextError.getCode().equals("IT") && !nextError.getCode().equals("OT1")) continue;
            if (currentError.getUIID().equals(nextError.getUIID())) {
                topIt.remove();
                return;
            }
            if (!currentError.getCode().equals("IT") || !nextError.getCode().equals("AT")) continue;
            if (currentError.getUIID().equals(nextError.getUIID())) {
                it.remove();
                continue;
            }
            if (!currentError.getCode().equals("OT1") || !nextError.getCode().equals("AT") || !currentError.getUIID().equals(nextError.getUIID())) continue;
            it.remove();
        }
    }

    private void validateActivityTransitionRules(Set<Activity> activities, Set<Transition> transitions) {
        this.validateTransitions(transitions);
        ArrayList<Activity> noInputTransition = new ArrayList<Activity>();
        ArrayList<Activity> noOuputTransition = new ArrayList<Activity>();
        int numOfTopLevelActivities = activities.size();
        ArrayList<ComplexActivity> complexActivitiesToProcess = null;
        for (Activity activity : activities) {
            if (activity.isFloatingActivity()) break;
            this.checkActivityForTransition(activity, numOfTopLevelActivities);
            if (activity.getTransitionFrom() == null) {
                noOuputTransition.add(activity);
            }
            if (activity.getTransitionTo() == null) {
                noInputTransition.add(activity);
            }
            complexActivitiesToProcess = this.checkActivityForFurtherProcessing(complexActivitiesToProcess, activity);
        }
        if (numOfTopLevelActivities > 0) {
            if (noInputTransition.size() == 0) {
                this.errors.add(new ValidationErrorDTO("IT", this.messageService.getMessage("validation.error.inputTransitionType2")));
            }
            if (noInputTransition.size() > 1) {
                for (Activity a : noInputTransition) {
                    this.errors.add(new ValidationErrorDTO("IT", this.messageService.getMessage("validation.error.inputTransitionType1"), a.getActivityUIID()));
                }
            }
            if (noOuputTransition.size() == 0) {
                this.errors.add(new ValidationErrorDTO("OT1", this.messageService.getMessage("validation.error.outputTransitionType2")));
            }
            if (noOuputTransition.size() > 1) {
                for (Activity a : noOuputTransition) {
                    this.errors.add(new ValidationErrorDTO("OT1", this.messageService.getMessage("validation.error.outputTransitionType1"), a.getActivityUIID()));
                }
            }
        }
        this.processComplexActivitiesForTransitions(complexActivitiesToProcess);
    }

    private void processComplexActivitiesForTransitions(ArrayList<ComplexActivity> complexActivitiesToProcess) {
        if (complexActivitiesToProcess != null) {
            for (ComplexActivity complex : complexActivitiesToProcess) {
                this.checkTransitionsInComplexActivity(complex);
            }
        }
    }

    private void checkTransitionsInComplexActivity(ComplexActivity complexActivity) {
        ArrayList<ComplexActivity> complexActivitiesToProcess = null;
        if (complexActivity.isBranchingActivity()) {
            for (ComplexActivity sequence : complexActivity.getActivities()) {
                for (Activity activity : sequence.getActivities()) {
                    this.checkActivityForTransition(activity, sequence.getActivities().size());
                    complexActivitiesToProcess = this.checkActivityForFurtherProcessing(complexActivitiesToProcess, activity);
                }
            }
        } else {
            for (Activity activity : complexActivity.getActivities()) {
                complexActivitiesToProcess = this.checkActivityForFurtherProcessing(complexActivitiesToProcess, activity);
            }
        }
        this.processComplexActivitiesForTransitions(complexActivitiesToProcess);
    }

    private ArrayList<ComplexActivity> checkActivityForFurtherProcessing(ArrayList<ComplexActivity> complexActivitiesToProcess, Activity activity) {
        if (activity.isComplexActivity() && !activity.isParallelActivity() && !activity.isFloatingActivity()) {
            if (complexActivitiesToProcess == null) {
                complexActivitiesToProcess = new ArrayList();
            }
            complexActivitiesToProcess.add((ComplexActivity)activity);
        }
        return complexActivitiesToProcess;
    }

    private boolean isFirstActivityInBranch(Activity a) {
        ComplexActivity parentActivity = (ComplexActivity)a.getParentActivity();
        if (parentActivity == null || !parentActivity.isSequenceActivity()) {
            return false;
        }
        return parentActivity.getDefaultActivity() != null && parentActivity.getDefaultActivity().equals(a);
    }

    private void validateTransitions(Set transitions) {
        for (Transition transition : transitions) {
            Activity fromActivity = transition.getFromActivity();
            Activity toActivity = transition.getToActivity();
            if (fromActivity == null) {
                this.errors.add(new ValidationErrorDTO("T", this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
                continue;
            }
            if (toActivity != null) continue;
            this.errors.add(new ValidationErrorDTO("T", this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
        }
    }

    private void checkActivityForTransition(Activity activity, int numOfActivities) {
        Transition inputTransition = activity.getTransitionTo();
        Transition outputTransition = activity.getTransitionFrom();
        if (numOfActivities > 1 && inputTransition == null && outputTransition == null && !this.isFirstActivityInBranch(activity)) {
            this.errors.add(new ValidationErrorDTO("AT", this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
        if (numOfActivities == 1 && (inputTransition != null || outputTransition != null)) {
            this.errors.add(new ValidationErrorDTO("AT", this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
    }

    private void checkIfGroupingRequired(Activity activity) {
        Grouping grouping;
        Integer groupingSupportType = activity.getGroupingSupportType();
        if (groupingSupportType == 3) {
            Grouping grouping2 = activity.getGrouping();
            if (grouping2 == null) {
                this.errors.add(new ValidationErrorDTO("GR", this.messageService.getMessage("validation.error.GroupingRequired"), activity.getActivityUIID()));
            }
        } else if (groupingSupportType == 1 && (grouping = activity.getGrouping()) != null) {
            this.errors.add(new ValidationErrorDTO("GNR", this.messageService.getMessage("validation.error.GroupingNotRequired"), activity.getActivityUIID()));
        }
    }

    private void validateOptionalActivity(Activity parentActivity) {
        OptionsActivity optionsActivity;
        Set childActivities;
        int numOfChildActivities;
        if (parentActivity.isOptionsActivity() && (numOfChildActivities = (childActivities = (optionsActivity = (OptionsActivity)parentActivity).getActivities()).size()) == 0) {
            this.errors.add(new ValidationErrorDTO("OA", this.messageService.getMessage("validation.error.OptionalActivity"), optionsActivity.getActivityUIID()));
        }
    }

    private void validateFloatingActivity(Activity parentActivity) {
        Object[] args = new String[1];
        if (parentActivity.isFloatingActivity()) {
            FloatingActivity floatingActivity = (FloatingActivity)parentActivity;
            Set childActivities = floatingActivity.getActivities();
            int numOfChildActivities = childActivities.size();
            if (numOfChildActivities == 0) {
                this.errors.add(new ValidationErrorDTO("FLA", this.messageService.getMessage("validation.error.FloatingActivity"), floatingActivity.getActivityUIID()));
            }
            if (numOfChildActivities > floatingActivity.getMaxNumberOfActivitiesNotNull()) {
                args[0] = floatingActivity.getMaxNumberOfActivities().toString();
                String errorMsg = this.messageService.getMessage("validation.error.FloatingActivity.maximum", args);
                this.errors.add(new ValidationErrorDTO("FAMX", errorMsg, floatingActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingActivity(Activity activity) {
        if (activity.isGroupingActivity()) {
            int maxNumGroups;
            GroupingActivity groupingActivity = (GroupingActivity)activity;
            Grouping grouping = groupingActivity.getCreateGrouping();
            if (grouping == null) {
                this.errors.add(new ValidationErrorDTO("GM", this.messageService.getMessage("validation.error.grouping.missing"), activity.getActivityUIID()));
            }
            Integer numGroupsInteger = null;
            if (grouping.isRandomGrouping()) {
                RandomGrouping random = (RandomGrouping)grouping;
                numGroupsInteger = random.getNumberOfGroups();
            } else {
                numGroupsInteger = grouping.getMaxNumberOfGroups();
            }
            int n = maxNumGroups = numGroupsInteger == null ? 0 : numGroupsInteger;
            if (maxNumGroups > 0 && grouping.getGroups() != null && grouping.getGroups().size() > maxNumGroups) {
                this.errors.add(new ValidationErrorDTO("GC", this.messageService.getMessage("validation.error.group.count.mismatch"), activity.getActivityUIID()));
            }
        }
    }

    private void validateOptionsActivityOrderId(Activity parentActivity) {
        Integer thisActivityOrderId = null;
        Integer previousActivityOrderId = null;
        boolean validOrderId = true;
        if (parentActivity.isOptionsActivity()) {
            OptionsActivity optionsActivity = (OptionsActivity)parentActivity;
            Set childActivities = optionsActivity.getActivities();
            Iterator i = childActivities.iterator();
            while (i.hasNext() && validOrderId) {
                Activity childActivity = (Activity)i.next();
                thisActivityOrderId = childActivity.getOrderId();
                if (previousActivityOrderId != null) {
                    if (thisActivityOrderId == null) {
                        validOrderId = false;
                    } else if (thisActivityOrderId.longValue() != previousActivityOrderId.longValue() + 1L) {
                        validOrderId = false;
                    }
                } else if (thisActivityOrderId == null || thisActivityOrderId.longValue() != 1L) {
                    validOrderId = false;
                }
                previousActivityOrderId = thisActivityOrderId;
            }
            if (!validOrderId) {
                this.errors.add(new ValidationErrorDTO("OAOI", this.messageService.getMessage("validation.error.OptionalActivityOrderId"), optionsActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingIfGroupingIsApplied(Activity activity) {
        if (activity.getApplyGrouping().booleanValue() && activity.getGrouping() == null) {
            this.errors.add(new ValidationErrorDTO("GS", this.messageService.getMessage("validation.error.GroupingSelected"), activity.getActivityUIID()));
        }
    }
}

