/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.presence.dao.hibernate;

import java.util.Date;
import java.util.List;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.presence.dao.IPresenceChatDAO;
import org.lamsfoundation.lams.presence.model.PresenceChatMessage;
import org.lamsfoundation.lams.presence.model.PresenceChatUser;

public class PresenceChatDAO
extends BaseDAO
implements IPresenceChatDAO {
    private static final String MESSAGE_BY_MESSAGE_ID = "from " + PresenceChatMessage.class.getName() + " msg" + " where msg.uid=?";
    private static final String MESSAGE_BY_CONVERSATION = "from " + PresenceChatMessage.class.getName() + " msg" + " where (msg.from=:from and msg.to=:to) or (msg.from=:to and msg.to=:from) and msg.lessonId=:lessonId order by msg.dateSent asc";
    private static final String MESSAGE_BY_LESSON_ID = "from " + PresenceChatMessage.class.getName() + " msg" + " where msg.lessonId=? and msg.to is null order by msg.dateSent asc";
    private static final String MESSAGE_NEW = "FROM " + PresenceChatMessage.class.getName() + " msg" + " WHERE msg.lessonId=:lessonId AND" + " (msg.uid > :lastMessageUid AND (('NULL'=:to AND msg.to IS NULL) OR (msg.to=:to AND msg.from=:from) OR (msg.to=:from AND msg.from=:to)))" + " OR (msg.dateSent > :lastCheck AND (msg.to IS NULL OR msg.to=:from))" + " ORDER BY msg.dateSent ASC";
    public static final String USER_BY_LESSON_ID_AND_TIME = "from " + PresenceChatUser.class.getName() + " r" + " where r.lessonId=? and r.lastPresence > ?";

    @Override
    public void saveOrUpdate(Object object) {
        this.getHibernateTemplate().saveOrUpdate(object);
        this.getHibernateTemplate().flush();
    }

    @Override
    public PresenceChatMessage getMessageById(Long id) {
        List list = this.getHibernateTemplate().find(MESSAGE_BY_CONVERSATION, new Object[]{id});
        if (!list.isEmpty()) {
            return (PresenceChatMessage)list.get(0);
        }
        return null;
    }

    @Override
    public List<PresenceChatMessage> getMessagesByConversation(Long lessonId, String from, String to) {
        return this.getHibernateTemplate().findByNamedParam(MESSAGE_BY_CONVERSATION, new String[]{"from", "to", "lessonId"}, new Object[]{from, to, lessonId});
    }

    @Override
    public List<PresenceChatMessage> getMessagesByLessonId(Long lessonId) {
        return this.getHibernateTemplate().find(MESSAGE_BY_LESSON_ID, new Object[]{lessonId});
    }

    @Override
    public List<PresenceChatMessage> getNewMessages(Long lessonId, String from, String to, Long lastMessageUid, Date lastCheck) {
        return this.getHibernateTemplate().findByNamedParam(MESSAGE_NEW, new String[]{"lessonId", "from", "to", "lastMessageUid", "lastCheck"}, new Object[]{lessonId, from, to == null ? "NULL" : to, lastMessageUid == null ? 0L : lastMessageUid, lastCheck == null ? new Date(0L) : lastCheck});
    }

    @Override
    public List<PresenceChatUser> getUsersByLessonIdAndLastPresence(Long lessonId, Date oldestLastPresence) {
        return this.getHibernateTemplate().find(USER_BY_LESSON_ID_AND_TIME, new Object[]{lessonId, oldestLastPresence});
    }
}

