/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.service;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.tool.IToolVO;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolSessionDAO;
import org.lamsfoundation.lams.tool.exception.LamsToolServiceException;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileUtilException;

public class LamsToolService
implements ILamsToolService {
    private static Logger log = Logger.getLogger(LamsToolService.class);
    public IToolDAO toolDAO;
    public IToolSessionDAO toolSessionDAO;
    public IToolContentDAO toolContentDAO;

    @Override
    public Set<User> getAllPotentialLearners(long toolSessionId) throws LamsToolServiceException {
        ToolSession session = this.toolSessionDAO.getToolSession(toolSessionId);
        if (session != null) {
            return session.getLearners();
        }
        log.error((Object)("No tool session found for " + toolSessionId + ". No potential learners being returned."));
        return new HashSet<User>();
    }

    @Override
    public IToolVO getToolByID(Long toolId) {
        Tool tool = this.toolDAO.getToolByID(toolId);
        return tool.createBasicToolVO();
    }

    @Override
    public IToolVO getToolBySignature(String toolSignature) {
        Tool tool = this.toolDAO.getToolBySignature(toolSignature);
        return tool.createBasicToolVO();
    }

    @Override
    public Tool getPersistToolBySignature(String toolSignature) {
        return this.toolDAO.getToolBySignature(toolSignature);
    }

    @Override
    public long getToolDefaultContentIdBySignature(String toolSignature) {
        return this.toolDAO.getToolDefaultContentIdBySignature(toolSignature);
    }

    @Override
    public String generateUniqueContentFolder() throws FileUtilException, IOException {
        return FileUtil.generateUniqueContentFolderID();
    }

    @Override
    public String getLearnerContentFolder(Long toolSessionId, Long userId) {
        ToolSession toolSession = this.getToolSession(toolSessionId);
        Long lessonId = toolSession.getLesson().getLessonId();
        String learnerContentFolder = FileUtil.getLearnerContentFolder(lessonId, userId);
        return learnerContentFolder;
    }

    @Override
    public void saveOrUpdateTool(Tool tool) {
        this.toolDAO.saveOrUpdateTool(tool);
    }

    @Override
    public ToolSession getToolSession(Long toolSessionId) {
        return this.toolSessionDAO.getToolSession(toolSessionId);
    }

    @Override
    public Boolean isGroupedActivity(long toolContentID) {
        List activities = this.toolContentDAO.findByProperty(Activity.class, "toolContentId", toolContentID);
        if (activities.size() == 1) {
            Activity activity = (Activity)activities.get(0);
            return activity.getApplyGrouping();
        }
        log.debug((Object)"ToolContent contains multiple activities, can't test whether grouping applies.");
        return null;
    }

    public IToolDAO getToolDAO() {
        return this.toolDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public IToolSessionDAO getToolSessionDAO() {
        return this.toolSessionDAO;
    }

    public void setToolSessionDAO(IToolSessionDAO toolSessionDAO) {
        this.toolSessionDAO = toolSessionDAO;
    }

    public IToolContentDAO getToolContentDAO() {
        return this.toolContentDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }
}

