/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.usermanagement.dao.hibernate;

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lamsfoundation.lams.dao.hibernate.BaseDAO;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.dao.IRoleDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class RoleDAO
extends BaseDAO
implements IRoleDAO {
    private static final String LOAD_USER_BY_ORG_AND_ROLE = "select u from User u, UserOrganisation uo, UserOrganisationRole uor where u.id = :userId and u.id = uo.user.id and uo.organisation = :org and uor.userOrganisation.id = uo.id and uor.role.id = :roleId";
    private static final String COUNT_ROLE = "select count(distinct userOrganisationRole.userOrganisation.user) from " + UserOrganisationRole.class.getName() + " userOrganisationRole" + " where userOrganisationRole.role.roleId = :roleId";
    private static final String COUNT_ROLE_FOR_ORG = "select count(distinct uor.userOrganisation.user) from " + UserOrganisationRole.class.getName() + " uor" + " where uor.role.roleId = :roleId" + " and uor.userOrganisation.organisation.organisationId = :orgId";

    @Override
    public User getUserByOrganisationAndRole(final Integer userId, final Integer roleId, final Organisation organisation) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (User)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(RoleDAO.LOAD_USER_BY_ORG_AND_ROLE).setInteger("userId", userId.intValue()).setEntity("org", (Object)organisation).setInteger("roleId", roleId.intValue()).uniqueResult();
            }
        });
    }

    @Override
    public Integer getCountRoleForSystem(final Integer roleId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(COUNT_ROLE);
                query.setInteger("roleId", roleId.intValue());
                Object value = query.uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }

    @Override
    public Integer getCountRoleForOrg(final Integer roleId, final Integer orgId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (Integer)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query query = session.createQuery(COUNT_ROLE_FOR_ORG);
                query.setInteger("roleId", roleId.intValue());
                query.setInteger("orgId", orgId.intValue());
                Object value = query.uniqueResult();
                return new Integer(((Number)value).intValue());
            }
        });
    }
}

