/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.config.ConfigurationItem;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.config.dao.hibernate.ConfigurationDAO;
import org.lamsfoundation.lams.config.dao.hibernate.RegistrationDAO;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.springframework.beans.factory.InitializingBean;

public class Configuration
implements InitializingBean {
    protected Logger log = Logger.getLogger(Configuration.class);
    public static String CONFIGURATION_HELP_PAGE = "LAMS+Configuration";
    private static Map items = null;
    protected ConfigurationDAO configurationDAO;
    protected static RegistrationDAO registrationDAO;
    protected MessageService messageService;
    public static final int ITEMS_ALL = 1;
    public static final int ITEMS_NON_LDAP = 2;
    public static final int ITEMS_ONLY_LDAP = 3;

    public void setConfigurationDAO(ConfigurationDAO configurationDAO) {
        this.configurationDAO = configurationDAO;
    }

    public void afterPropertiesSet() {
        if (items != null) {
            return;
        }
        Map<String, ConfigurationItem> itemsmap = Collections.synchronizedMap(new LinkedHashMap());
        try {
            List mapitems = this.getAllItems();
            if (mapitems.size() > 0) {
                for (ConfigurationItem item : mapitems) {
                    if (StringUtils.equals((String)item.getKey(), (String)ConfigurationKeys.TRUSTSTORE_PATH)) {
                        this.setSystemProperty(item.getKey(), item.getValue());
                    } else if (StringUtils.equals((String)item.getKey(), (String)ConfigurationKeys.TRUSTSTORE_PASSWORD)) {
                        this.setSystemProperty(item.getKey(), item.getValue());
                    }
                    itemsmap.put(item.getKey(), item);
                }
            }
            items = itemsmap;
        }
        catch (Exception e) {
            this.log.error((Object)"Exception has occurred: ", (Throwable)e);
        }
    }

    public List getAllItems() {
        return this.configurationDAO.getAllItems();
    }

    public static Map getAll() {
        return items;
    }

    public ConfigurationItem getConfigItemByKey(String key) {
        if (items != null && items.get(key) != null && items.get(key) != null) {
            return (ConfigurationItem)items.get(key);
        }
        return null;
    }

    public static String getItemValue(Object obj) {
        ConfigurationItem item = (ConfigurationItem)obj;
        if (item.getValue() != null) {
            return item.getValue().trim();
        }
        return null;
    }

    public static void setItemValue(Object obj, String value) {
        ConfigurationItem item = (ConfigurationItem)obj;
        item.setValue(value);
    }

    public static String get(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return Configuration.getItemValue(items.get(key));
        }
        return null;
    }

    public static int getAsInt(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Integer(Configuration.getItemValue(items.get(key)));
        }
        return -1;
    }

    public static boolean getAsBoolean(String key) {
        if (items != null && items.get(key) != null && Configuration.getItemValue(items.get(key)) != null) {
            return new Boolean(Configuration.getItemValue(items.get(key)));
        }
        return false;
    }

    public static void updateItem(String key, String value) {
        if (value != null) {
            value = value.trim();
        }
        if (items.containsKey(key)) {
            Configuration.setItemValue(items.get(key), value);
        }
    }

    public void persistUpdate() {
        this.setSystemProperty(ConfigurationKeys.TRUSTSTORE_PATH, Configuration.get(ConfigurationKeys.TRUSTSTORE_PATH));
        this.setSystemProperty(ConfigurationKeys.TRUSTSTORE_PASSWORD, Configuration.get(ConfigurationKeys.TRUSTSTORE_PASSWORD));
        this.updatePublicFolderName();
        this.configurationDAO.insertOrUpdateAll(items.values());
    }

    private void updatePublicFolderName() {
        WorkspaceFolder publicFolder = null;
        List list = this.configurationDAO.findByProperty(WorkspaceFolder.class, "workspaceFolderType", WorkspaceFolder.PUBLIC_SEQUENCES);
        if (list != null && list.size() > 0) {
            publicFolder = (WorkspaceFolder)list.get(0);
            String[] langCountry = LanguageUtil.getDefaultLangCountry();
            Locale locale = new Locale(langCountry[0], langCountry[1]);
            publicFolder.setName(this.messageService.getMessageSource().getMessage("public.folder.name", null, locale));
            this.configurationDAO.update(publicFolder);
        }
    }

    public String toString() {
        return "Configuration items:" + (items != null ? items.toString() : "none");
    }

    private void setSystemProperty(String key, String value) {
        if (StringUtils.isBlank((String)key)) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public HashMap<String, ArrayList<ConfigurationItem>> arrangeItems(int filter) {
        List originalList = this.getAllItems();
        HashMap<String, ArrayList<ConfigurationItem>> groupedList = new HashMap<String, ArrayList<ConfigurationItem>>();
        int i = 0;
        while (true) {
            block8: {
                if (i >= originalList.size()) {
                    return groupedList;
                }
                ConfigurationItem item = (ConfigurationItem)originalList.get(i);
                String header = item.getHeaderName();
                switch (filter) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        if (!StringUtils.contains((String)header, (String)"config.header.ldap")) break;
                        break block8;
                    }
                    case 3: {
                        if (!StringUtils.contains((String)header, (String)"config.header.ldap")) break block8;
                    }
                }
                if (!groupedList.containsKey(header)) {
                    groupedList.put(header, new ArrayList());
                }
                ArrayList<ConfigurationItem> currentList = groupedList.get(header);
                currentList.add(item);
                groupedList.put(header, currentList);
            }
            ++i;
        }
    }

    public HashMap<String, ArrayList<ConfigurationItem>> arrangeItems() {
        return this.arrangeItems(1);
    }

    public static void saveOrUpdateRegistration(Registration reg) {
        registrationDAO.saveOrUpdate(reg);
    }

    public static Registration getRegistration() {
        return registrationDAO.get();
    }

    public RegistrationDAO getRegistrationDAO() {
        return registrationDAO;
    }

    public void setRegistrationDAO(RegistrationDAO registrationDAO) {
        Configuration.registrationDAO = registrationDAO;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

