/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.Subscription;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.Emailer;

public class DeliveryMethodMail
extends AbstractDeliveryMethod {
    private static final Logger log = Logger.getLogger(DeliveryMethodMail.class);
    private static DeliveryMethodMail instance = null;
    private static final EmailValidator emailValidator = EmailValidator.getInstance();
    private static IUserManagementService userManagementService = null;

    protected static DeliveryMethodMail getInstance() {
        if (instance == null) {
            instance = new DeliveryMethodMail();
        }
        return instance;
    }

    private DeliveryMethodMail() {
        super((short)1);
    }

    @Override
    protected String send(Integer fromUserId, Integer toUserId, String subject, String message, boolean isHtmlFormat) throws InvalidParameterException {
        try {
            User toUser = (User)userManagementService.findById(User.class, toUserId);
            if (toUser == null) {
                return "Target user with ID " + toUserId + " was not found.";
            }
            String toEmail = toUser.getEmail();
            if (!emailValidator.isValid(toEmail)) {
                return "Target user's e-mail address is invalid.";
            }
            if (fromUserId == null) {
                Emailer.sendFromSupportEmail(subject, toEmail, message, isHtmlFormat);
            } else {
                User fromUser = (User)userManagementService.findById(User.class, fromUserId);
                if (fromUser == null) {
                    return "Source user with ID " + fromUserId + " was not found.";
                }
                String fromEmail = fromUser.getEmail();
                if (!emailValidator.isValid(fromEmail)) {
                    return "Source user's e-mail address is invalid.";
                }
                Emailer.send(subject, toEmail, "", fromEmail, "", message, isHtmlFormat);
            }
            return null;
        }
        catch (Exception e) {
            String error = e.toString();
            this.logError(error);
            return error;
        }
    }

    @Override
    protected boolean lastOperationFailed(Subscription subscription) {
        return subscription.getLastOperationMessage() != null;
    }

    static void setUserManagementService(IUserManagementService userManagementService) {
        DeliveryMethodMail.userManagementService = userManagementService;
    }

    void notifyAdmin(String subject, String body, boolean isHtmlFormat) throws AddressException, UnsupportedEncodingException, MessagingException {
        String adminEmail = Configuration.get(ConfigurationKeys.LAMS_ADMIN_EMAIL);
        if (StringUtils.isBlank((String)adminEmail)) {
            log.warn((Object)("Could not notify admin as his email is blank. The subject: " + subject + ". The message: " + body));
        } else {
            Emailer.sendFromSupportEmail(subject, adminEmail, body, isHtmlFormat);
        }
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

