/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.events;

import java.security.InvalidParameterException;
import org.lamsfoundation.lams.events.AbstractDeliveryMethod;
import org.lamsfoundation.lams.events.Event;
import org.lamsfoundation.lams.events.IEventNotificationService;

public class Subscription {
    private Long uid;
    private Integer userId;
    private Event event;
    private Short deliveryMethodId;
    private String lastOperationMessage;
    private AbstractDeliveryMethod deliveryMethod;

    public Subscription() {
    }

    public Subscription(Integer userId, AbstractDeliveryMethod deliveryMethod) {
        if (deliveryMethod == null) {
            throw new InvalidParameterException("Delivery method can not be null.");
        }
        this.userId = userId;
        this.deliveryMethod = deliveryMethod;
        this.deliveryMethodId = deliveryMethod.getId();
    }

    public Object clone() {
        return new Subscription(this.userId, this.deliveryMethod);
    }

    public AbstractDeliveryMethod getDeliveryMethod() {
        if (this.deliveryMethod == null) {
            for (AbstractDeliveryMethod delivery : IEventNotificationService.availableDeliveryMethods) {
                if (delivery.getId() != this.deliveryMethodId.shortValue()) continue;
                this.deliveryMethod = delivery;
            }
        }
        return this.deliveryMethod;
    }

    public Short getDeliveryMethodId() {
        return this.deliveryMethodId;
    }

    public Event getEvent() {
        return this.event;
    }

    public String getLastOperationMessage() {
        return this.lastOperationMessage;
    }

    public Long getUid() {
        return this.uid;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setDeliveryMethodId(Short deliveryMethodId) {
        this.deliveryMethodId = deliveryMethodId;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setLastOperationMessage(String lastOperationMessage) {
        this.lastOperationMessage = lastOperationMessage;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }
}

