/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import java.util.Date;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.util.HashUtil;

public class Authenticator {
    public static void authenticate(ExtServerOrgMap map, String datetime, String username, String method, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        if (map.getDisabled().booleanValue()) {
            throw new AuthenticationException("The third party server is disabled");
        }
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + method.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticateLoginRequest(ExtServerOrgMap map, String datetime, String username, String method, String lsid, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        if (map.getDisabled().booleanValue()) {
            throw new AuthenticationException("The third party server is disabled");
        }
        if (map.getTimeToLiveLoginRequestEnabled().booleanValue()) {
            long datetimeParam;
            try {
                datetimeParam = Long.parseLong(datetime);
            }
            catch (NumberFormatException e) {
                throw new AuthenticationException("The third party server provided wrong format of datetime, datetime = " + datetime, e);
            }
            int timeToLiveLoginRequest = map.getTimeToLiveLoginRequest();
            Date requestTimePlusTimeToLive = new Date(datetimeParam + (long)(timeToLiveLoginRequest * 60 * 1000));
            Date requestTimeMinusTimeToLive = new Date(datetimeParam - (long)(timeToLiveLoginRequest * 60 * 1000));
            Date now = new Date();
            if (requestTimePlusTimeToLive.before(now) || requestTimeMinusTimeToLive.after(now)) {
                throw new AuthenticationException("Request is not in the time range of " + timeToLiveLoginRequest + " minutes. Please, contact sysadmin.");
            }
        }
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + method.toLowerCase().trim() + ("learnerStrictAuth".equals(method) ? lsid.toLowerCase().trim() : "") + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(ExtServerOrgMap map, String datetime, String username, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        if (map.getDisabled().booleanValue()) {
            throw new AuthenticationException("The third party server is disabled");
        }
        String plaintext = datetime.toLowerCase().trim() + username.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    public static void authenticate(ExtServerOrgMap map, String datetime, String hashValue) throws AuthenticationException {
        if (map == null) {
            throw new AuthenticationException("The third party server is not configured on LAMS server");
        }
        if (map.getDisabled().booleanValue()) {
            throw new AuthenticationException("The third party server is disabled");
        }
        String plaintext = datetime.toLowerCase().trim() + map.getServerid().toLowerCase().trim() + map.getServerkey().toLowerCase().trim();
        Authenticator.checkHash(plaintext, hashValue);
    }

    private static void checkHash(String plaintext, String hashValue) throws AuthenticationException {
        if (!hashValue.equals(HashUtil.sha1(plaintext))) {
            throw new AuthenticationException("Authentication failed!");
        }
    }
}

